/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.PagerAdapter;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.ResType;
import com.nasserkhosravi.appcomponent.data.ImageResource;
import com.nasserkhosravi.appcomponent.view.widget.TouchImageView;
import java.util.List;

public class SliderAdapter
extends PagerAdapter {
    @ResType
    public int resourceType = 0;
    private LayoutInflater mLayoutInflater;
    private List<ImageResource> uriList;
    private Context context;
    private boolean isEnableZooming = false;
    private SliderItemClickListener itemClickListener;
    private int width = -1;
    private int height = -1;

    public void setItems(List<ImageResource> uriList) {
        this.uriList = uriList;
    }

    public int getCount() {
        return this.uriList.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, final int position) {
        ViewGroup.LayoutParams layoutParams;
        if (this.context == null) {
            this.context = container.getContext();
        }
        if (this.mLayoutInflater == null) {
            this.mLayoutInflater = (LayoutInflater)container.getContext().getSystemService("layout_inflater");
        }
        assert (this.mLayoutInflater != null);
        final ImageView imageView = this.getImageImpl();
        if (this.width > -1) {
            layoutParams = imageView.getLayoutParams();
            layoutParams.width = this.width;
        }
        if (this.height > -1) {
            layoutParams = imageView.getLayoutParams();
            layoutParams.height = this.height;
        }
        this.uriList.get(position).loadInto(imageView);
        if (this.itemClickListener != null) {
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SliderAdapter.this.itemClickListener.onItemClickListener((View)imageView, position);
                }
            });
        }
        container.addView((View)imageView);
        return imageView;
    }

    public void setCustomSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public boolean isEnableZooming() {
        return this.isEnableZooming;
    }

    public void setEnableZooming(boolean enableZooming) {
        this.isEnableZooming = enableZooming;
    }

    public void setItemClickListener(SliderItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    private ImageView getImageImpl() {
        Object img = !this.isEnableZooming ? new ImageView(this.context) : new TouchImageView(this.context);
        img.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        img.setId(R.id.imgSlider);
        img.setScaleType(ImageView.ScaleType.FIT_CENTER);
        return img;
    }

    public static interface SliderItemClickListener {
        public void onItemClickListener(View var1, int var2);
    }
}

