/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.view.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.recyclerview.widget.RecyclerView;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.ResourceComponent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H&J\u0018\u0010#\u001a\u00020!2\b\b\u0001\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u001dJ\u0018\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0017H\u0016J\u0018\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u0017H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/nasserkhosravi/appcomponent/view/adapter/BaseComponentAdapter;", "M", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "Lcom/nasserkhosravi/appcomponent/ResourceComponent;", "()V", "context", "Landroid/content/Context;", "value", "ctx", "getCtx", "()Landroid/content/Context;", "setCtx", "(Landroid/content/Context;)V", "inflater", "Landroid/view/LayoutInflater;", "items", "", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "layoutRes", "", "getLayoutRes", "()I", "checkCacheContext", "", "viewGroup", "Landroid/view/ViewGroup;", "getItemCount", "getViewHolder", "view", "Landroid/view/View;", "viewType", "inflateLayout", "layoutId", "container", "onBindViewHolder", "vh", "position", "onCreateViewHolder", "parent", "ItemClickListener", "library_release"})
public abstract class BaseComponentAdapter<M>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ResourceComponent {
    private Context context;
    private LayoutInflater inflater;
    @Nullable
    private List<? extends M> items;

    @Override
    @NotNull
    public Context getCtx() {
        Context context = this.context;
        if (context == null) {
            Intrinsics.throwNpe();
        }
        return context;
    }

    public void setCtx(@NotNull Context value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
    }

    @Nullable
    public final List<M> getItems() {
        return this.items;
    }

    public final void setItems(@Nullable List<? extends M> list) {
        this.items = list;
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (this.inflater == null) {
            this.inflater = LayoutInflater.from((Context)parent.getContext());
        }
        this.checkCacheContext(parent);
        return this.getViewHolder(this.inflateLayout(this.getLayoutRes(), parent), viewType);
    }

    @NotNull
    public abstract RecyclerView.ViewHolder getViewHolder(@NotNull View var1, int var2);

    public abstract int getLayoutRes();

    private final void checkCacheContext(ViewGroup viewGroup) {
        if (this.context == null) {
            this.context = viewGroup.getContext();
        }
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder vh, int position) {
        Intrinsics.checkParameterIsNotNull((Object)vh, (String)"vh");
        View view = vh.itemView;
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"vh.itemView");
        view.setId(R.id.rootView);
    }

    public int getItemCount() {
        if (this.items == null) {
            return 0;
        }
        List<M> list = this.items;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list.size();
    }

    @NotNull
    public final View inflateLayout(@LayoutRes int layoutId, @NotNull ViewGroup container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        LayoutInflater layoutInflater = this.inflater;
        if (layoutInflater == null) {
            Intrinsics.throwNpe();
        }
        View view = layoutInflater.inflate(layoutId, container, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"inflater!!.inflate(layoutId, container, false)");
        return view;
    }

    @Override
    @NotNull
    public String getStringRes(@StringRes int resId) {
        return ResourceComponent.DefaultImpls.getStringRes(this, resId);
    }

    @Override
    @ColorInt
    public int getColorRes(@ColorRes int res) {
        return ResourceComponent.DefaultImpls.getColorRes(this, res);
    }

    @Override
    @NotNull
    public String getResName(int n) {
        return ResourceComponent.DefaultImpls.getResName(this, n);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/nasserkhosravi/appcomponent/view/adapter/BaseComponentAdapter$ItemClickListener;", "", "onRecycleItemClick", "", "view", "Landroid/view/View;", "position", "", "library_release"})
    public static interface ItemClickListener {
        public void onRecycleItemClick(@NotNull View var1, int var2);
    }
}

