/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.data;

import androidx.annotation.RawRes;
import com.nasserkhosravi.appcomponent.AppContext;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\u0010\u0010\b\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/nasserkhosravi/appcomponent/data/OkHttpBuilder;", "", "()V", "okHttpBuilder", "Lokhttp3/OkHttpClient$Builder;", "sslCertificateRaw", "", "timeout", "withSSL", "", "addInterceptor", "interceptor", "Lokhttp3/Interceptor;", "addNetworkInterceptor", "build", "Lokhttp3/OkHttpClient;", "configSSL", "", "okHttpClientBuilder", "initDefaultTimeOut", "certificateRes", "withTimeOut", "library_release"})
public final class OkHttpBuilder {
    private OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder();
    private int timeout = -1;
    private boolean withSSL;
    @RawRes
    private int sslCertificateRaw;

    @NotNull
    public final OkHttpBuilder addInterceptor(@NotNull Interceptor interceptor) {
        Intrinsics.checkParameterIsNotNull((Object)interceptor, (String)"interceptor");
        this.okHttpBuilder.addInterceptor(interceptor);
        return this;
    }

    @NotNull
    public final OkHttpBuilder addNetworkInterceptor(@NotNull Interceptor interceptor) {
        Intrinsics.checkParameterIsNotNull((Object)interceptor, (String)"interceptor");
        this.okHttpBuilder.addNetworkInterceptor(interceptor);
        return this;
    }

    @NotNull
    public final OkHttpBuilder withSSL(@RawRes int certificateRes) {
        this.withSSL = true;
        this.sslCertificateRaw = certificateRes;
        return this;
    }

    @NotNull
    public final OkHttpBuilder withTimeOut(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @NotNull
    public final OkHttpClient build() {
        if (this.timeout == -1) {
            this.initDefaultTimeOut();
        }
        if (this.withSSL) {
            this.configSSL(this.okHttpBuilder);
        }
        OkHttpClient okHttpClient = this.okHttpBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"okHttpBuilder.build()");
        return okHttpClient;
    }

    private final void initDefaultTimeOut() {
        int t = 6;
        this.okHttpBuilder.readTimeout((long)t, TimeUnit.SECONDS).connectTimeout((long)t, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void configSSL(OkHttpClient.Builder okHttpClientBuilder) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        InputStream caInput = AppContext.INSTANCE.get().getResources().openRawResource(this.sslCertificateRaw);
        Certificate ca = null;
        try {
            Certificate certificate = cf.generateCertificate(caInput);
            Intrinsics.checkExpressionValueIsNotNull((Object)certificate, (String)"cf.generateCertificate(caInput)");
            ca = certificate;
        }
        finally {
            caInput.close();
        }
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setCertificateEntry("ca", ca);
        String tmfAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(tmfAlgorithm);
        tmf.init(keyStore);
        TrustManagerFactory trustManagerFactory = tmf;
        Intrinsics.checkExpressionValueIsNotNull((Object)trustManagerFactory, (String)"tmf");
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw (Throwable)new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        X509TrustManager trustManager2 = (X509TrustManager)trustManager;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, new TrustManager[]{trustManager2}, null);
        SSLContext sSLContext = sslContext;
        Intrinsics.checkExpressionValueIsNotNull((Object)sSLContext, (String)"sslContext");
        SSLSocketFactory sslSocketFactory = sSLContext.getSocketFactory();
        okHttpClientBuilder.sslSocketFactory(sslSocketFactory, trustManager2);
    }
}

