/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent;

import android.app.Application;
import android.content.SharedPreferences;
import android.os.Build;
import com.nasserkhosravi.appcomponent.AppContext;
import java.util.Objects;
import java.util.UUID;

public class Device {
    private static Device instance;
    public int width;
    public int height;
    private String deviceId;
    private SharedPreferences pref;

    private Device() {
        Application app = AppContext.INSTANCE.get();
        this.pref = app.getSharedPreferences("device", 0);
        this.width = app.getResources().getDisplayMetrics().widthPixels;
        this.height = app.getResources().getDisplayMetrics().heightPixels;
        this.checkInitDeviceId();
    }

    public static Device get() {
        if (instance == null) {
            instance = new Device();
        }
        return instance;
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    private void checkInitDeviceId() {
        String string = this.pref.getString("id", "null");
        if (Objects.requireNonNull(string).equals("null")) {
            this.recordDeviceId();
        }
        this.loadDeviceId();
    }

    private void recordDeviceId() {
        this.pref.edit().putString("id", this.generateDeviceId()).apply();
    }

    private String generateDeviceId() {
        return UUID.randomUUID().toString();
    }

    private void loadDeviceId() {
        String id = this.pref.getString("id", "null");
        if (id.equals("null")) {
            throw new IllegalArgumentException();
        }
        this.deviceId = id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }
}

