/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import com.nasserkhosravi.appcomponent.AppComponent;
import com.nasserkhosravi.appcomponent.BaseViewGroupManager;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.ViewComponentConfig;
import com.nasserkhosravi.appcomponent.utils.DimensUtils;
import com.nasserkhosravi.appcomponent.view.NoConnectionView;
import com.nasserkhosravi.appcomponent.view.ProgressBuilder;
import com.nasserkhosravi.appcomponent.view.ProgressController;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\nJ\u0010\u0010!\u001a\u00020\u00192\b\b\u0001\u0010\"\u001a\u00020\u001dJ\u000e\u0010!\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0013H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0016@BX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/nasserkhosravi/appcomponent/BaseViewAccessor;", "", "component", "Lcom/nasserkhosravi/appcomponent/AppComponent;", "viewGroupManager", "Lcom/nasserkhosravi/appcomponent/BaseViewGroupManager;", "config", "Lcom/nasserkhosravi/appcomponent/ViewComponentConfig;", "(Lcom/nasserkhosravi/appcomponent/AppComponent;Lcom/nasserkhosravi/appcomponent/BaseViewGroupManager;Lcom/nasserkhosravi/appcomponent/ViewComponentConfig;)V", "banView", "Landroid/view/View;", "noConnectionView", "Lcom/nasserkhosravi/appcomponent/view/NoConnectionView;", "<set-?>", "Lcom/nasserkhosravi/appcomponent/view/ProgressController;", "progress", "getProgress", "()Lcom/nasserkhosravi/appcomponent/view/ProgressController;", "toolbar", "Landroid/view/ViewGroup;", "getToolbar", "()Landroid/view/ViewGroup;", "Landroid/widget/TextView;", "tvTitle", "buildProgress", "", "constructLayout", "createAndShowBanViewTo", "layoutRes", "", "to", "getNoConnectionView", "removeBanView", "setTitleToolBar", "res", "titleToolBar", "", "setupBackButton", "toolBarLayout", "library_release"})
public final class BaseViewAccessor {
    private TextView tvTitle;
    @NotNull
    private ProgressController progress;
    private NoConnectionView noConnectionView;
    private View banView;
    private final AppComponent component;
    private final BaseViewGroupManager viewGroupManager;
    private final ViewComponentConfig config;

    @NotNull
    public final ProgressController getProgress() {
        ProgressController progressController = this.progress;
        if (progressController == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"progress");
        }
        return progressController;
    }

    @NotNull
    public final ViewGroup getToolbar() {
        View view = this.viewGroupManager.getViewGroup().findViewById(R.id.toolbarLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewGroupManager.getView\u2026wById(R.id.toolbarLayout)");
        return (ViewGroup)view;
    }

    public final void constructLayout() {
        if (this.config.isEnableToolBar()) {
            ViewGroup viewGroup = this.viewGroupManager.getViewGroup();
            ViewGroup toolBarLayout = (ViewGroup)viewGroup.findViewById(R.id.toolbarLayout);
            if (toolBarLayout == null) {
                throw (Throwable)new IllegalArgumentException("enable toolbar is true but you did not supply toolbar");
            }
            this.tvTitle = (TextView)toolBarLayout.findViewById(R.id.tvTitleToolbar);
            if (this.config.isEnableBackButton()) {
                this.setupBackButton(toolBarLayout);
            }
        }
        this.buildProgress();
    }

    private final void setupBackButton(ViewGroup toolBarLayout) {
        ImageView imgArrowBack = new ImageView(toolBarLayout.getContext());
        imgArrowBack.setImageResource(R.drawable.ic_arrow_back_black_24dp);
        imgArrowBack.setColorFilter(this.component.getColorRes(R.color.toolbar_child_color), PorterDuff.Mode.SRC_IN);
        RelativeLayout.LayoutParams imgLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        imgLayoutParams.addRule(20);
        imgLayoutParams.addRule(15);
        int px = DimensUtils.INSTANCE.dpToPx(10);
        imgArrowBack.setPadding(px, px, px, px);
        imgArrowBack.setLayoutParams((ViewGroup.LayoutParams)imgLayoutParams);
        imgArrowBack.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ BaseViewAccessor this$0;

            public final void onClick(View it) {
                Context context = BaseViewAccessor.access$getComponent$p(this.this$0).getCtx();
                if (context == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
                }
                ((Activity)context).onBackPressed();
            }
            {
                this.this$0 = baseViewAccessor;
            }
        });
        toolBarLayout.addView((View)imgArrowBack);
    }

    public final void setTitleToolBar(@NotNull String titleToolBar) {
        Intrinsics.checkParameterIsNotNull((Object)titleToolBar, (String)"titleToolBar");
        TextView textView = this.tvTitle;
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        textView.setText((CharSequence)titleToolBar);
    }

    public final void setTitleToolBar(@StringRes int res) {
        TextView textView = this.tvTitle;
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        textView.setText(res);
    }

    public final void buildProgress() {
        if (this.viewGroupManager.getViewGroup().findViewById(R.id.progressView) == null) {
            View view = ProgressBuilder.Companion.createFrom(this.component.getCtx(), this.config);
            this.progress = new ProgressController(view, this.viewGroupManager.getViewGroup());
        }
    }

    public final void createAndShowBanViewTo(@LayoutRes int layoutRes, @NotNull View to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        ViewParent viewParent = to.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup toParent = (ViewGroup)viewParent;
        View view = this.banView = View.inflate((Context)to.getContext(), (int)layoutRes, null);
        if (view == null) {
            Intrinsics.throwNpe();
        }
        view.setId(R.id.layoutBanView);
        ViewGroup.LayoutParams lpToView = to.getLayoutParams();
        View view2 = this.banView;
        if (view2 == null) {
            Intrinsics.throwNpe();
        }
        view2.setLayoutParams(lpToView);
        int indexOfChild = toParent.indexOfChild(to);
        toParent.addView(this.banView, indexOfChild);
        to.setVisibility(8);
        View view3 = this.banView;
        if (view3 == null) {
            Intrinsics.throwNpe();
        }
        view3.setVisibility(0);
    }

    public final void removeBanView(@NotNull View to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
        ViewParent viewParent = to.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup toParent = (ViewGroup)viewParent;
        to.setVisibility(0);
        if (this.banView != null) {
            toParent.removeView(this.banView);
        }
    }

    @NotNull
    public final NoConnectionView getNoConnectionView() {
        if (this.noConnectionView == null) {
            this.noConnectionView = new NoConnectionView(this.viewGroupManager.getViewGroup());
        }
        NoConnectionView noConnectionView = this.noConnectionView;
        if (noConnectionView == null) {
            Intrinsics.throwNpe();
        }
        return noConnectionView;
    }

    public BaseViewAccessor(@NotNull AppComponent component, @NotNull BaseViewGroupManager viewGroupManager, @NotNull ViewComponentConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)viewGroupManager, (String)"viewGroupManager");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.component = component;
        this.viewGroupManager = viewGroupManager;
        this.config = config;
    }

    public static final /* synthetic */ AppComponent access$getComponent$p(BaseViewAccessor $this) {
        return $this.component;
    }
}

