package com.nasserkhosravi.appcomponent.view.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.annotation.LayoutRes
import androidx.recyclerview.widget.RecyclerView
import com.nasserkhosravi.appcomponent.R
import com.nasserkhosravi.appcomponent.ResourceComponent

abstract class BaseComponentAdapter<M> : RecyclerView.Adapter<RecyclerView.ViewHolder>(), ResourceComponent {

    private var context: Context? = null
    private var inflater: LayoutInflater? = null
    override var ctx: Context
        get() = context!!
        set(value) {}

    var items: List<M>? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        if (inflater == null) {
            inflater = LayoutInflater.from(parent.context)
        }
        checkCacheContext(parent)
        return getViewHolder(inflateLayout(layoutRes, parent), viewType)
    }

    abstract fun getViewHolder(view: View, viewType: Int): RecyclerView.ViewHolder
    abstract val layoutRes: Int

    private fun checkCacheContext(viewGroup: ViewGroup) {
        if (this.context == null) {
            this.context = viewGroup.context
        }
    }

    override fun onBindViewHolder(vh: RecyclerView.ViewHolder, position: Int) {
        vh.itemView.id = R.id.rootView
    }

    override fun getItemCount(): Int {
        if (items == null) {
            return 0
        }
        return items!!.size
    }

    fun inflateLayout(@LayoutRes layoutId: Int, container: ViewGroup): View {
        return inflater!!.inflate(layoutId, container, false)
    }

    interface ItemClickListener {
        fun onRecycleItemClick(view: View, position: Int)
    }
}

@Retention(AnnotationRetention.RUNTIME)
@Target(AnnotationTarget.FIELD)
annotation class ClickListenerBinder