package com.nasserkhosravi.appcomponent.utils

import android.content.Context
import android.os.Environment
import android.os.storage.StorageManager
import android.text.format.Formatter
import android.util.Log
import com.nasserkhosravi.appcomponent.AppContext
import java.io.File
import java.lang.reflect.InvocationTargetException

class KFileUtils {

    fun getListOfVolumes(context: Context) {
        val storageManager = context.getSystemService(Context.STORAGE_SERVICE) as StorageManager
        try {
            val volumes = storageManager.javaClass.getMethod("getVolumePaths", *arrayOfNulls(0)).invoke(
                storageManager,
                *arrayOfNulls(0)
            ) as Array<String>
            for (i in 0 until volumes.size) {
                Log.d("getListOfVolumes", volumes[i])
                val file = File(volumes[i])
                Log.d(
                    "getListOfVolumes",
                    "Free Space:" + format(file.freeSpace) + "Total Space:" + format(file.totalSpace)
                )
                Log.d("getListOfVolumes", "Status of the Media:" + Environment.getExternalStorageState(file))
            }
        } catch (e: IllegalAccessException) {
            e.printStackTrace()
        } catch (e: InvocationTargetException) {
            e.printStackTrace()
        } catch (e: NoSuchMethodException) {
            e.printStackTrace()
        }

    }


    private fun format(bytes: Long): String {
        return Formatter.formatShortFileSize(AppContext.get(), bytes)
    }
}