package com.nasserkhosravi.appcomponent.error

import io.reactivex.subjects.PublishSubject

object ErrorPublisher {

    private var networkPublisher: PublishSubject<NetworkErrorModel>? = null

    fun publishNetworkException(model: NetworkErrorModel) {
        networkPublisher!!.onNext(model)
    }

    init {
        networkPublisher = PublishSubject.create<NetworkErrorModel>()
        networkPublisher!!.publish().autoConnect()
    }

    fun clear() {
        networkPublisher = null
    }
}