/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.LayoutRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.tabs.TabLayout;
import com.nasserkhosravi.appcomponent.ResHelper;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\rJ\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0001\u0010\u001c\u001a\u00020\rJ\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010*\u001a\u00020&J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\"\u00100\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u00020 2\b\b\u0001\u00102\u001a\u00020\rJ\u0018\u00103\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\f\u001a\u00020\rJ\u001a\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u001c\u001a\u00020\rH\u0007\u00a8\u00065"}, d2={"Lcom/nasserkhosravi/appcomponent/utils/UIUtils;", "", "()V", "activityChooserSafe", "", "activity", "Landroid/app/Activity;", "intent", "Landroid/content/Intent;", "changeBottomLineEditText", "editText", "Landroid/widget/EditText;", "colorRes", "", "changeFontTabs", "tabLayout", "Lcom/google/android/material/tabs/TabLayout;", "typeface", "Landroid/graphics/Typeface;", "drawLineOn", "tv", "Landroid/widget/TextView;", "filterColor", "drawable", "Landroid/graphics/drawable/Drawable;", "id", "img", "Landroid/widget/ImageView;", "color", "filterColorInt", "getParentColor", "view", "Landroid/view/View;", "hideKeyboard", "hideKeyboardFrom", "context", "Landroid/content/Context;", "isRTL", "", "locale", "Ljava/util/Locale;", "isRTLCompat", "isRTLCompatByLocal", "layoutDirectionToLTR", "window", "Landroid/view/Window;", "layoutDirectionToRTL", "makefullScreen", "replaceViewWith", "from", "toLayout", "setNavigationBarColor", "setStatusBarColor", "library_release"})
public final class UIUtils {
    public static final UIUtils INSTANCE;

    @Nullable
    public final View replaceViewWith(@NotNull Context context, @NotNull View from, @LayoutRes int toLayout) {
        View newV;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)from, (String)"from");
        ViewParent viewParent = from.getParent();
        if (viewParent == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup parent = (ViewGroup)viewParent;
        ViewGroup.LayoutParams lpFrom = from.getLayoutParams();
        View view = newV = View.inflate((Context)context, (int)toLayout, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"newV");
        view.setLayoutParams(lpFrom);
        parent.removeView(from);
        parent.addView(newV);
        return newV;
    }

    public final void layoutDirectionToRTL(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        view.setLayoutDirection(1);
    }

    public final void filterColor(@NotNull ImageView img, @ColorRes int color2) {
        Intrinsics.checkParameterIsNotNull((Object)img, (String)"img");
        img.setColorFilter(ResHelper.INSTANCE.getColorRes(color2), PorterDuff.Mode.SRC_IN);
    }

    public final void filterColor(@NotNull Drawable drawable2, @ColorRes int id2) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        this.filterColorInt(drawable2, ResHelper.INSTANCE.getColorRes(id2));
    }

    public final void filterColorInt(@NotNull Drawable drawable2, @ColorInt int color2) {
        Intrinsics.checkParameterIsNotNull((Object)drawable2, (String)"drawable");
        Drawable drawable3 = drawable2;
        if (drawable3 instanceof ShapeDrawable) {
            Paint paint = ((ShapeDrawable)drawable2).getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"drawable.paint");
            paint.setColor(color2);
        } else if (drawable3 instanceof GradientDrawable) {
            ((GradientDrawable)drawable2).setColor(color2);
        } else if (drawable3 instanceof ColorDrawable) {
            ((ColorDrawable)drawable2).setColor(color2);
        }
    }

    public final void hideKeyboard(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Object object = activity.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        View view = activity.getCurrentFocus();
        if (view == null) {
            view = new View((Context)activity);
        }
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public final void hideKeyboardFrom(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = context.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager imm = (InputMethodManager)object;
        imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    public final void activityChooserSafe(@NotNull Activity activity, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        try {
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)((Context)activity), (CharSequence)"You don'resultBack have GoogleHelper Play installed", (int)1).show();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void changeFontTabs(@NotNull TabLayout tabLayout, @NotNull Typeface typeface) {
        Intrinsics.checkParameterIsNotNull((Object)tabLayout, (String)"tabLayout");
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        View view = tabLayout.getChildAt(0);
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup vg = (ViewGroup)view;
        int tabsCount = vg.getChildCount();
        int n = 0;
        int n2 = tabsCount;
        while (n < n2) {
            void j;
            View view2 = vg.getChildAt((int)j);
            if (view2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            ViewGroup vgTab = (ViewGroup)view2;
            int tabChildCount = vgTab.getChildCount();
            int n3 = 0;
            int n4 = tabChildCount;
            while (n3 < n4) {
                void i;
                View tabViewChild = vgTab.getChildAt((int)i);
                if (tabViewChild instanceof TextView) {
                    ((TextView)tabViewChild).setTypeface(typeface);
                }
                ++i;
            }
            ++j;
        }
    }

    private final int getParentColor(View view) {
        if (view.getParent() != null) {
            ViewParent viewParent = view.getParent();
            if (viewParent == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
            }
            ViewGroup viewGroup = (ViewGroup)viewParent;
            Drawable background = viewGroup.getBackground();
            if (background instanceof ColorDrawable) {
                return ((ColorDrawable)background).getColor();
            }
        }
        return 0;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    public final void makefullScreen(@NotNull Activity activity) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        int n = Build.VERSION.SDK_INT;
        if (12 <= n && 18 >= n) {
            View v;
            Window window = activity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            View view = v = window.getDecorView();
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
            view.setSystemUiVisibility(8);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            View decorView = window.getDecorView();
            int uiOptions = 4098;
            View view = decorView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"decorView");
            view.setSystemUiVisibility(uiOptions);
        }
    }

    @TargetApi(value=21)
    public final void setStatusBarColor(@NotNull Activity activity, @ColorRes int color2) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        activity.getWindow().addFlags(Integer.MIN_VALUE);
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        window.setStatusBarColor(ResHelper.INSTANCE.getColorRes(color2));
    }

    public final void layoutDirectionToLTR(@NotNull Window window) {
        Intrinsics.checkParameterIsNotNull((Object)window, (String)"window");
        View view = window.getDecorView();
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"window.decorView");
        view.setLayoutDirection(0);
    }

    public final void changeBottomLineEditText(@NotNull EditText editText, @ColorRes int colorRes) {
        Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
        editText.getBackground().mutate().setColorFilter(ResHelper.INSTANCE.getColorRes(colorRes), PorterDuff.Mode.SRC_ATOP);
    }

    public final void drawLineOn(@NotNull TextView tv) {
        Intrinsics.checkParameterIsNotNull((Object)tv, (String)"tv");
        tv.setPaintFlags(tv.getPaintFlags() | 0x10);
    }

    public final void setNavigationBarColor(@NotNull Activity activity, @ColorRes int colorRes) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Window window = activity.getWindow();
        Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
        window.setNavigationBarColor(ContextCompat.getColor((Context)((Context)activity), (int)colorRes));
    }

    public final boolean isRTL(@NotNull Locale locale) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        byte directionality = Character.getDirectionality(locale.getDisplayName().charAt(0));
        return directionality == 1 || directionality == 2;
    }

    public final boolean isRTL(@NotNull Activity activity) {
        Configuration config;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Resources resources = activity.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"activity.resources");
        Configuration configuration = config = resources.getConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"config");
        return configuration.getLayoutDirection() == 1;
    }

    public final boolean isRTLCompat(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public final boolean isRTLCompatByLocal() {
        return TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
    }

    private UIUtils() {
    }

    static {
        UIUtils uIUtils;
        INSTANCE = uIUtils = new UIUtils();
    }
}

