/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.utils;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.nasserkhosravi.appcomponent.AppContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class FileUtils {
    public static String HOME_NAME = "";

    public static File getHomeStoragePath() {
        File homeDirectory = new File(Environment.getExternalStorageDirectory() + File.separator + HOME_NAME);
        if (!homeDirectory.exists() && !homeDirectory.mkdirs()) {
            Log.d((String)"home dir", (String)"can't resultBack create home directory");
        }
        return homeDirectory;
    }

    public static boolean isFileExistInHome(String fileName) {
        return new File(FileUtils.getHomeStoragePath().getPath() + "/" + fileName).exists();
    }

    public static File getFileByName(String fileName) {
        return new File(FileUtils.getHomeStoragePath().getPath() + "/" + fileName);
    }

    public static boolean deleteFile(String name) {
        return FileUtils.getFileByName(name).delete();
    }

    public static Drawable drawableFromAsset(Context context, String resName) throws IOException {
        InputStream inputStream = context.getAssets().open(resName);
        Drawable drawable = Drawable.createFromStream((InputStream)inputStream, null);
        inputStream.close();
        return drawable;
    }

    public static String readStringFromAsset(String fullFileName) {
        try {
            String str;
            Application app = AppContext.INSTANCE.get();
            InputStream is = app.getAssets().open(fullFileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            StringBuilder buf = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                buf.append(str);
            }
            return buf.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File newFileAtHome(String fileName) {
        return new File(FileUtils.getHomeStoragePath(), fileName);
    }

    public static Boolean saveBitmapAsJPGInHome(Bitmap bitmap, String fileName) {
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(FileUtils.newFileAtHome(fileName));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)fOut);
            fOut.flush();
            ((OutputStream)fOut).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Bitmap extractBitmap(File file) {
        return BitmapFactory.decodeFile((String)file.getAbsolutePath());
    }

    public static Uri extractURI(File file) {
        return Uri.fromFile((File)file);
    }
}

