/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.error;

import com.google.gson.stream.MalformedJsonException;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.error.HttpException;
import com.nasserkhosravi.appcomponent.error.NetworkErrorModel;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/nasserkhosravi/appcomponent/error/ErrorInspector;", "", "()V", "networkExceptionTypeFactory", "Lcom/nasserkhosravi/appcomponent/error/NetworkErrorModel;", "throwable", "", "errorId", "", "library_release"})
public final class ErrorInspector {
    public static final ErrorInspector INSTANCE;

    @NotNull
    public final NetworkErrorModel networkExceptionTypeFactory(@NotNull Throwable throwable, int errorId) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        int code = 0;
        int resourceString = 0;
        if (throwable instanceof SocketTimeoutException || throwable instanceof NoRouteToHostException) {
            code = 3;
            resourceString = R.string.No_server_connection;
        } else if (throwable instanceof ConnectException || throwable instanceof UnknownHostException) {
            code = 2;
            resourceString = R.string.No_internet_connection;
        } else if (throwable instanceof HttpException || throwable instanceof MalformedJsonException) {
            code = 1;
            resourceString = R.string.Problem_in_catching_data;
        } else {
            code = 0;
            resourceString = R.string.Un_expected_exception;
        }
        return new NetworkErrorModel(errorId, code, resourceString);
    }

    private ErrorInspector() {
    }

    static {
        ErrorInspector errorInspector;
        INSTANCE = errorInspector = new ErrorInspector();
    }
}

