/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.data;

import com.nasserkhosravi.appcomponent.AppComponent;
import com.nasserkhosravi.appcomponent.data.GeneralResponse;
import com.nasserkhosravi.appcomponent.error.ErrorInspector;
import com.nasserkhosravi.appcomponent.error.ErrorPublisher;
import com.nasserkhosravi.appcomponent.error.HttpException;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00030\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/nasserkhosravi/appcomponent/data/RxRetrofitObserver;", "T", "Lio/reactivex/Observer;", "Lretrofit2/Response;", "Lcom/nasserkhosravi/appcomponent/data/GeneralResponse;", "appComponent", "Lcom/nasserkhosravi/appcomponent/AppComponent;", "requestId", "", "(Lcom/nasserkhosravi/appcomponent/AppComponent;I)V", "(Lcom/nasserkhosravi/appcomponent/AppComponent;)V", "getAppComponent", "()Lcom/nasserkhosravi/appcomponent/AppComponent;", "disposable", "Lio/reactivex/disposables/Disposable;", "httpException", "", "onComplete", "onError", "e", "", "onNext", "response", "onSubscribe", "onSuccessful", "(Ljava/lang/Object;)V", "library_release"})
public abstract class RxRetrofitObserver<T>
implements Observer<Response<GeneralResponse<T>>> {
    private Disposable disposable;
    private int requestId;
    @NotNull
    private final AppComponent appComponent;

    protected final void onSuccessful(T response) {
    }

    public void onSubscribe(@NotNull Disposable disposable) {
        Intrinsics.checkParameterIsNotNull((Object)disposable, (String)"disposable");
        this.disposable = disposable;
        this.appComponent.getViewAccessor().getProgress().show();
    }

    public void onNext(@NotNull Response<GeneralResponse<T>> response) {
        Intrinsics.checkParameterIsNotNull(response, (String)"response");
        if (response.isSuccessful()) {
            Object object = response.body();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"response.body()!!");
            this.onSuccessful(((GeneralResponse)object).getResponse());
        } else {
            this.httpException();
        }
    }

    public void onError(@NotNull Throwable e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        ErrorPublisher.INSTANCE.publishNetworkException(ErrorInspector.INSTANCE.networkExceptionTypeFactory(e, this.requestId));
        this.onComplete();
    }

    public void onComplete() {
        if (this.disposable != null) {
            Disposable disposable = this.disposable;
            if (disposable == null) {
                Intrinsics.throwNpe();
            }
            if (!disposable.isDisposed()) {
                Disposable disposable2 = this.disposable;
                if (disposable2 == null) {
                    Intrinsics.throwNpe();
                }
                disposable2.dispose();
            }
        }
        this.appComponent.getViewAccessor().getProgress().hide();
    }

    public final void httpException() {
        this.onError(new HttpException());
    }

    @NotNull
    public final AppComponent getAppComponent() {
        return this.appComponent;
    }

    public RxRetrofitObserver(@NotNull AppComponent appComponent) {
        Intrinsics.checkParameterIsNotNull((Object)appComponent, (String)"appComponent");
        this.appComponent = appComponent;
    }

    public RxRetrofitObserver(@NotNull AppComponent appComponent, int requestId) {
        Intrinsics.checkParameterIsNotNull((Object)appComponent, (String)"appComponent");
        this(appComponent);
        this.requestId = requestId;
    }
}

