/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.data;

import android.support.annotation.NonNull;
import com.nasserkhosravi.appcomponent.AppComponent;
import com.nasserkhosravi.appcomponent.data.GeneralResponse;
import com.nasserkhosravi.appcomponent.error.ErrorPublisher;
import com.nasserkhosravi.appcomponent.error.HttpException;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import retrofit2.Response;

public abstract class RxBaseObserver<T>
implements Observer<Response<GeneralResponse<T>>> {
    private Disposable disposable;
    private AppComponent delegate;
    private int requestId = -1;

    public RxBaseObserver(@NonNull AppComponent delegate) {
        this.delegate = delegate;
    }

    public RxBaseObserver(AppComponent delegate, int requestId) {
        this.delegate = delegate;
        this.requestId = requestId;
    }

    protected void onSuccessful(T response) {
    }

    public int getRequestId() {
        return this.requestId;
    }

    public void onSubscribe(Disposable d2) {
        this.disposable = d2;
        this.delegate.getViewAccessor().getProgress().show();
    }

    public void onNext(Response<GeneralResponse<T>> response) {
        if (response.isSuccessful()) {
            this.onSuccessful(((GeneralResponse)response.body()).getResponse());
        } else {
            this.httpException();
        }
    }

    public void onError(Throwable e) {
        ErrorPublisher.INSTANCE.publishException(e, this.requestId);
        this.onComplete();
    }

    public void onComplete() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
        this.delegate.getViewAccessor().getProgress().hide();
    }

    public void httpException() {
        this.onError(new HttpException());
    }
}

