/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent.data;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import com.nasserkhosravi.appcomponent.AppContext;
import com.nasserkhosravi.appcomponent.ResType;
import com.nasserkhosravi.appcomponent.utils.FileUtils;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0012\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u00020\u0003H\u0007J\u0006\u0010\u001c\u001a\u00020\u0007R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u0018\u0010\u0010\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0005R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\t\"\u0004\b\u0014\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/nasserkhosravi/appcomponent/data/ImageResource;", "", "resType", "", "(I)V", "()V", "assetPath", "", "getAssetPath", "()Ljava/lang/String;", "setAssetPath", "(Ljava/lang/String;)V", "drawableRes", "filePath", "getFilePath", "setFilePath", "resourceType", "resourceType$annotations", "url", "getUrl", "setUrl", "getAsBitmap", "Landroid/graphics/Bitmap;", "getContext", "Landroid/app/Application;", "getDrawable", "Landroid/graphics/drawable/Drawable;", "getType", "getURI", "Companion", "library_release"})
public final class ImageResource {
    @Nullable
    private String url;
    @Nullable
    private String assetPath;
    @Nullable
    private String filePath;
    private int drawableRes;
    private int resourceType;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string2) {
        this.url = string2;
    }

    @Nullable
    public final String getAssetPath() {
        return this.assetPath;
    }

    public final void setAssetPath(@Nullable String string2) {
        this.assetPath = string2;
    }

    @Nullable
    public final String getFilePath() {
        return this.filePath;
    }

    public final void setFilePath(@Nullable String string2) {
        this.filePath = string2;
    }

    @ResType
    private static /* synthetic */ void resourceType$annotations() {
    }

    @ResType
    public final int getType() {
        return this.resourceType;
    }

    @Nullable
    public final Drawable getDrawable() {
        switch (this.resourceType) {
            case 1: {
                Drawable drawable2 = null;
                try {
                    drawable2 = FileUtils.drawableFromAsset((Context)this.getContext(), this.assetPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return drawable2;
            }
            case 2: {
                return this.getContext().getDrawable(this.drawableRes);
            }
            case 3: {
                return (Drawable)new BitmapDrawable(this.getContext().getResources(), this.filePath);
            }
            case 0: {
                throw (Throwable)new NotImplementedError("");
            }
        }
        return null;
    }

    @NotNull
    public final Bitmap getAsBitmap() {
        switch (this.resourceType) {
            case 3: {
                Bitmap bitmap = FileUtils.extractBitmap(FileUtils.getFileByName(this.filePath));
                Intrinsics.checkExpressionValueIsNotNull((Object)bitmap, (String)"FileUtils.extractBitmap(\u2026.getFileByName(filePath))");
                return bitmap;
            }
        }
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    @NotNull
    public final String getURI() {
        switch (this.resourceType) {
            case 1: {
                String string2 = this.assetPath;
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                return string2;
            }
            case 2: {
                return String.valueOf(this.drawableRes);
            }
            case 3: {
                String string3 = this.filePath;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                return string3;
            }
            case 0: {
                String string4 = this.url;
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                return string4;
            }
        }
        throw (Throwable)new NotImplementedError(null, 1, null);
    }

    private final Application getContext() {
        return AppContext.INSTANCE.get();
    }

    private ImageResource() {
    }

    private ImageResource(@ResType int resType) {
        this();
        this.resourceType = resType;
    }

    public /* synthetic */ ImageResource(@ResType int resType, DefaultConstructorMarker $constructor_marker) {
        this(resType);
    }

    public static final /* synthetic */ int access$getDrawableRes$p(ImageResource $this) {
        return $this.drawableRes;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\u00042\b\b\u0001\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcom/nasserkhosravi/appcomponent/data/ImageResource$Companion;", "", "()V", "from", "Lcom/nasserkhosravi/appcomponent/data/ImageResource;", "uri", "", "resourceType", "", "fromAsset", "assetPath", "fromDrawable", "drawableRes", "fromFile", "fullFilePath", "fromWeb", "url", "library_release"})
    public static final class Companion {
        @NotNull
        public final ImageResource fromAsset(@NotNull String assetPath) {
            Intrinsics.checkParameterIsNotNull((Object)assetPath, (String)"assetPath");
            ImageResource image = new ImageResource(1, null);
            image.setAssetPath(assetPath);
            return image;
        }

        @NotNull
        public final ImageResource fromWeb(@NotNull String url) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            ImageResource image = new ImageResource(0, null);
            image.setUrl(url);
            return image;
        }

        @NotNull
        public final ImageResource fromFile(@NotNull String fullFilePath) {
            Intrinsics.checkParameterIsNotNull((Object)fullFilePath, (String)"fullFilePath");
            ImageResource image = new ImageResource(3, null);
            image.setFilePath(fullFilePath);
            return image;
        }

        @NotNull
        public final ImageResource fromDrawable(@DrawableRes int drawableRes) {
            ImageResource image = new ImageResource(2, null);
            image.drawableRes = drawableRes;
            return image;
        }

        @NotNull
        public final ImageResource from(@NotNull String uri, int resourceType) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            ImageResource image = new ImageResource(resourceType, null);
            switch (resourceType) {
                case 1: {
                    image.setAssetPath(uri);
                    break;
                }
                case 2: {
                    image.drawableRes = Integer.parseInt(uri);
                    break;
                }
                case 3: {
                    image.setFilePath(uri);
                    break;
                }
                case 0: {
                    image.setUrl(uri);
                }
            }
            return image;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

