/*
 * Decompiled with CFR 0.152.
 */
package com.nasserkhosravi.appcomponent;

import android.app.Activity;
import android.content.Context;
import android.graphics.PorterDuff;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nasserkhosravi.appcomponent.AppComponent;
import com.nasserkhosravi.appcomponent.BaseConfig;
import com.nasserkhosravi.appcomponent.BaseViewGroupManager;
import com.nasserkhosravi.appcomponent.R;
import com.nasserkhosravi.appcomponent.utils.DimensUtils;
import com.nasserkhosravi.appcomponent.view.NoConnectionView;
import com.nasserkhosravi.appcomponent.view.ProgressBuilder;
import com.nasserkhosravi.appcomponent.view.ProgressProxy;
import com.nasserkhosravi.appcomponent.view.ProgressView;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\fJ\u0006\u0010\"\u001a\u00020\u001fJ\u0010\u0010#\u001a\u00020\u001f2\b\b\u0001\u0010$\u001a\u00020%J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010)\u001a\u00020\u0015H\u0002J\u0018\u0010*\u001a\u00020\u001f2\b\b\u0001\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/nasserkhosravi/appcomponent/BaseViewAccessor;", "", "component", "Lcom/nasserkhosravi/appcomponent/AppComponent;", "viewGroupManager", "Lcom/nasserkhosravi/appcomponent/BaseViewGroupManager;", "config", "Lcom/nasserkhosravi/appcomponent/BaseConfig;", "(Lcom/nasserkhosravi/appcomponent/AppComponent;Lcom/nasserkhosravi/appcomponent/BaseViewGroupManager;Lcom/nasserkhosravi/appcomponent/BaseConfig;)V", "banView", "Landroid/view/View;", "noConnectionView", "Lcom/nasserkhosravi/appcomponent/view/NoConnectionView;", "<set-?>", "Lcom/nasserkhosravi/appcomponent/view/ProgressProxy;", "progress", "getProgress", "()Lcom/nasserkhosravi/appcomponent/view/ProgressProxy;", "setProgress", "(Lcom/nasserkhosravi/appcomponent/view/ProgressProxy;)V", "toolbar", "Landroid/view/ViewGroup;", "getToolbar", "()Landroid/view/ViewGroup;", "Landroid/widget/TextView;", "tvTitle", "getTvTitle", "()Landroid/widget/TextView;", "setTvTitle", "(Landroid/widget/TextView;)V", "buildProgress", "", "constructLayout", "getNoConnectionView", "hideBanView", "setTitleToolBar", "res", "", "titleToolBar", "", "setupBackButton", "toolBarLayout", "showBanViewTo", "layoutRes", "to", "library_release"})
public final class BaseViewAccessor {
    @Nullable
    private TextView tvTitle;
    @Nullable
    private ProgressProxy progress;
    private NoConnectionView noConnectionView;
    private final View banView;
    private final AppComponent component;
    private final BaseViewGroupManager viewGroupManager;
    private final BaseConfig config;

    @Nullable
    public final TextView getTvTitle() {
        return this.tvTitle;
    }

    private final void setTvTitle(TextView textView) {
        this.tvTitle = textView;
    }

    @Nullable
    public final ProgressProxy getProgress() {
        return this.progress;
    }

    private final void setProgress(ProgressProxy progressProxy) {
        this.progress = progressProxy;
    }

    @NotNull
    public final ViewGroup getToolbar() {
        View view = this.viewGroupManager.getViewGroup().findViewById(R.id.ac_toolbarLayout);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewGroupManager.viewGro\u2026Id(R.id.ac_toolbarLayout)");
        return (ViewGroup)view;
    }

    public final void constructLayout() {
        if (this.config.isEnableToolBar()) {
            ViewGroup viewGroup = this.viewGroupManager.getViewGroup();
            ViewGroup toolBarLayout = (ViewGroup)viewGroup.findViewById(R.id.ac_toolbarLayout);
            if (toolBarLayout == null) {
                throw (Throwable)new IllegalArgumentException("enable toolbar is true but you did not supply toolbar");
            }
            this.tvTitle = (TextView)toolBarLayout.findViewById(R.id.ac_tvTitleToolbar);
            if (this.config.isEnableBackButton()) {
                this.setupBackButton(toolBarLayout);
            }
        }
        this.buildProgress();
    }

    private final void setupBackButton(ViewGroup toolBarLayout) {
        ImageView imgArrowBack = new ImageView(toolBarLayout.getContext());
        imgArrowBack.setImageResource(R.drawable.ac_ic_arrow_back_black_24dp);
        imgArrowBack.setColorFilter(this.component.getColorRes(R.color.ac_toolbar_child_color), PorterDuff.Mode.SRC_IN);
        RelativeLayout.LayoutParams imgLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        imgLayoutParams.addRule(20);
        imgLayoutParams.addRule(15);
        int px = DimensUtils.INSTANCE.dpToPx(10);
        imgArrowBack.setPadding(px, px, px, px);
        imgArrowBack.setLayoutParams((ViewGroup.LayoutParams)imgLayoutParams);
        imgArrowBack.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ BaseViewAccessor this$0;

            public final void onClick(View $noName_0) {
                Context context = BaseViewAccessor.access$getComponent$p(this.this$0).getCtx();
                if (context == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.app.Activity");
                }
                ((Activity)context).onBackPressed();
            }
            {
                this.this$0 = baseViewAccessor;
            }
        });
        toolBarLayout.addView((View)imgArrowBack);
    }

    public final void setTitleToolBar(@NotNull String titleToolBar) {
        Intrinsics.checkParameterIsNotNull((Object)titleToolBar, (String)"titleToolBar");
        TextView textView = this.tvTitle;
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        textView.setText((CharSequence)titleToolBar);
    }

    public final void setTitleToolBar(@StringRes int res) {
        TextView textView = this.tvTitle;
        if (textView == null) {
            Intrinsics.throwNpe();
        }
        textView.setText(res);
    }

    public final void buildProgress() {
        if (this.viewGroupManager.getViewGroup().findViewById(R.id.ac_progressView) == null) {
            ProgressView view = new ProgressBuilder(this.component.getCtx()).build();
            ViewGroup viewGroup = this.viewGroupManager.getViewGroup();
            Intrinsics.checkExpressionValueIsNotNull((Object)viewGroup, (String)"viewGroupManager.viewGroup");
            this.progress = new ProgressProxy(view, viewGroup);
        }
    }

    public final void showBanViewTo(@LayoutRes int layoutRes, @NotNull View to) {
        Intrinsics.checkParameterIsNotNull((Object)to, (String)"to");
    }

    public final void hideBanView() {
        View view = this.banView;
        if (view == null) {
            Intrinsics.throwNpe();
        }
        view.setVisibility(8);
    }

    @NotNull
    public final NoConnectionView getNoConnectionView() {
        if (this.noConnectionView == null) {
            this.noConnectionView = new NoConnectionView(this.viewGroupManager.getViewGroup());
        }
        NoConnectionView noConnectionView = this.noConnectionView;
        if (noConnectionView == null) {
            Intrinsics.throwNpe();
        }
        return noConnectionView;
    }

    public BaseViewAccessor(@NotNull AppComponent component, @NotNull BaseViewGroupManager viewGroupManager, @NotNull BaseConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)viewGroupManager, (String)"viewGroupManager");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.component = component;
        this.viewGroupManager = viewGroupManager;
        this.config = config;
    }

    @NotNull
    public static final /* synthetic */ AppComponent access$getComponent$p(BaseViewAccessor $this) {
        return $this.component;
    }
}

