package com.nasserkhosravi.appcomponent.view.adapter

import android.content.Context
import android.support.annotation.LayoutRes
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.nasserkhosravi.appcomponent.*

abstract class BaseAdapter2<M> : RecyclerView.Adapter<RecyclerView.ViewHolder>(), ResourceComponent {

    private var context: Context? = null
    override var ctx: Context
        get() = context!!
        set(value) {}

    var items: List<M>? = null
    var itemClickListener: ItemClickListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        checkCacheContext(parent)
        return getViewHolder(inflateLayout(getLayoutRes(), parent), viewType)
    }

    abstract fun getViewHolder(view: View, viewType: Int): RecyclerView.ViewHolder
    abstract fun getLayoutRes(): Int

    fun checkCacheContext(viewGroup: ViewGroup) {
        if (this.context == null) {
            this.context = viewGroup.context
        }
    }

    override fun onBindViewHolder(vh: RecyclerView.ViewHolder, position: Int) {
        vh.itemView.id = R.id.ac_rootView
        itemClickListener?.let {
            bindListener(vh, position)
        }
    }

    private fun bindItemClickListener(vh: RecyclerView.ViewHolder, position: Int) {
        val itemView = vh.itemView as ViewGroup
        val childCount = itemView.childCount
        for (i in 0..childCount) {
            val childAt = itemView.getChildAt(i)
            if (childAt?.id != View.NO_ID) {
                AppLog.d(this, "register: ${ResHelper.getResName(childAt.id)} $position")
                childAt?.setOnClickListener {
                    AppLog.d(this, "on: ${ResHelper.getResName(childAt.id)}")
//                    itemClickListener?.onRecycleItemClick(it, position)
                }
            }
        }
    }

    override fun getItemCount(): Int {
        return items!!.size
    }

    fun inflateLayout(@LayoutRes layoutId: Int, container: ViewGroup): View {
        return LayoutInflater.from(this.context).inflate(layoutId, container, false)
    }

    private fun bindListener(vh: RecyclerView.ViewHolder, position: Int) {
        vh.itemView.setOnClickListener {
            itemClickListener?.onRecycleItemClick(it, position)
        }
        JReflection.find<View>(vh, ListenerBinder::class.java).forEach {
            it.setOnClickListener {
                itemClickListener?.onRecycleItemClick(it, position)
            }
        }
    }

    interface ItemClickListener {
        fun onRecycleItemClick(view: View, position: Int)
    }
}

@Retention(AnnotationRetention.RUNTIME)
@Target(AnnotationTarget.FIELD)
annotation class ListenerBinder