package com.nasserkhosravi.appcomponent.view.adapter

import android.content.Context
import android.support.annotation.LayoutRes
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.nasserkhosravi.appcomponent.ResourceComponent

/**
 * Created by Nasser Khosravi on 11/24/2017
 */
abstract class BaseAdapter<M, VH : RecyclerView.ViewHolder> : RecyclerView.Adapter<VH>(), ResourceComponent {

    private var context: Context? = null
    override var ctx: Context
        get() = context!!
        set(value) {}

    var items: List<M>? = null

    fun checkCacheContext(viewGroup: ViewGroup) {
        if (this.context == null) {
            this.context = viewGroup.context
        }
    }

    override fun getItemCount(): Int {
        return items!!.size
    }

    fun inflateLayout(@LayoutRes layoutId: Int, container: ViewGroup): View {
        return LayoutInflater.from(this.context).inflate(layoutId, container, false)
    }
}