package com.nasserkhosravi.appcomponent.view

import android.content.Context
import android.graphics.PorterDuff
import android.support.annotation.ColorRes
import android.support.design.widget.CoordinatorLayout
import android.support.v4.content.ContextCompat
import android.util.AttributeSet
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.ProgressBar
import com.nasserkhosravi.appcomponent.R
import com.nasserkhosravi.appcomponent.utils.DimensUtils

class ProgressView @JvmOverloads constructor(
    context: Context,
    attrs: AttributeSet? = null,
    defStyle: Int = 0
) : ProgressBar(context, attrs, defStyle) {

    val isBusy: Boolean
        get() = visibility == View.VISIBLE

    fun show() {
        visibility = View.VISIBLE
    }

    fun hide() {
        visibility = View.GONE
    }

    fun setColor(@ColorRes colorRes: Int) {
        indeterminateDrawable.setColorFilter(ContextCompat.getColor(context, colorRes), PorterDuff.Mode.SRC_IN)
    }
}

class ProgressProxy constructor(view: ProgressView, layout: ViewGroup) {

    private val view: ProgressView

    init {
        view!!
        layout!!
        this.view = view
        if (view.parent == null) {
            layout.addView(view)
        } else {
            val oldLayout = view.parent as ViewGroup
            oldLayout.removeView(view)
            layout.addView(view)
        }
    }

    fun show() {
        view.show()
    }

    fun hide() {
        view.hide()
    }
}


/**
 * Created by Nasser Khosravi on 2/10/2018
 * it should just focus on option of building
 */
class ProgressBuilder(private var context: Context?) {

    private var size = 0
    private var layoutGravity = Gravity.CENTER

    fun inCenter(): ProgressBuilder {
        layoutGravity = Gravity.CENTER
        return this
    }

    fun withSize(dp: Int): ProgressBuilder {
        this.size = DimensUtils.dpToPx(dp)
        return this
    }

    fun build(): ProgressView {
        val view = ProgressView(context!!, null, android.R.attr.progressBarStyleInverse)
        view.id = R.id.ac_progressView
        view.visibility = View.GONE
        view.isIndeterminate = true
        if (size == 0) {
            withSize(40)
        }
        val layoutParams = CoordinatorLayout.LayoutParams(size, size)
        if (layoutGravity == Gravity.CENTER) {
            layoutParams.gravity = Gravity.CENTER
        }
        view.layoutParams = layoutParams
        return view
    }

}

