package com.nasserkhosravi.appcomponent.utils;

import com.nasserkhosravi.appcomponent.utils.calendar.DateUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;


/**
 * Created by Nasser on 9/26/2017
 */
public class CalenderUtils {
    private CalenderUtils() {
    }


    public static Date convertToDate(final String date, final DateFormats format) {
        try {
            return new SimpleDateFormat(format.asString()).parse(date);
        } catch (ParseException e) {
            throw new IllegalArgumentException("Date or Format is not correct." + " Date is:" + date + " Format is:" + format);
        }
    }

    public static String convertToString(final long date, final DateFormats format) {
        return new SimpleDateFormat(format.asString()).format(new Date(date));
    }

    public static String YMDtoJalali(final String gregorianDate) {
        Date date = convertToDate(gregorianDate, DateFormats.YEAR_MONTH_DAY);
        return DateUtils.getPersianDateString(date);
    }

    public static String getFormattedCurrentDateYID() {
        return new SimpleDateFormat(DateFormats.YEAR_MONTH_DAY.asString(), Locale.getDefault()).format(new Date());
    }

    public static long getCurrentTime() {
        return new Date().getTime();
    }


}
