package com.nasserkhosravi.appcomponent.error;

import android.support.annotation.IntDef;
import android.support.annotation.StringRes;

/**
 * Created by Nasser Khosravi on 12/15/2017.
 */

public class ErrorModel {
    public static final int HTTP = 1;
    public static final int NO_INTERNET = 2;
    public static final int NO_SERVER_CONNECTION = 3;
    public static final int UN_KNOWN = 0;
    public int stringRes;
    private int errorId;
    private int errorType;

    public ErrorModel(int errorId, @Type int errorType, @StringRes int stringRes) {
        this.errorId = errorId;
        this.errorType = errorType;
        this.stringRes = stringRes;
    }

    public int getErrorType() {
        return errorType;
    }

    public int getStringRes() {
        return stringRes;
    }

    public int getErrorId() {
        return errorId;
    }

    @IntDef({HTTP, NO_INTERNET, NO_SERVER_CONNECTION, UN_KNOWN})
    public @interface Type {
    }

}
