package com.nasserkhosravi.appcomponent.data

import android.app.Application
import android.graphics.Bitmap
import android.graphics.drawable.BitmapDrawable
import android.graphics.drawable.Drawable
import android.support.annotation.DrawableRes
import com.nasserkhosravi.appcomponent.AppContext
import com.nasserkhosravi.appcomponent.Res
import com.nasserkhosravi.appcomponent.ResType
import com.nasserkhosravi.appcomponent.utils.FileUtils
import java.io.IOException

class ImageResource private constructor() {
    var url: String? = null
    var assetPath: String? = null
    var filePath: String? = null
    private var drawableRes: Int = 0
    @ResType
    private var resourceType: Int = 0

    @ResType
    fun getType(): Int {
        return resourceType
    }

    private constructor(@ResType resType: Int) : this() {
        resourceType = resType
    }

    fun getDrawable(): Drawable? {
        when (resourceType) {
            Res.ASSET -> {
                var drawable: Drawable? = null
                try {
                    drawable = FileUtils.drawableFromAsset(getContext(), assetPath)
                } catch (e: IOException) {
                    e.printStackTrace()
                }

                return drawable
            }
            Res.DRAWABLE -> return getContext().getDrawable(drawableRes)
            Res.FILE -> return BitmapDrawable(getContext().getResources(), filePath)
            Res.WEB -> throw NotImplementedError("")
        }
        return null
    }

    fun getAsBitmap(): Bitmap {
        when (resourceType) {
            Res.FILE -> return FileUtils.extractBitmap(FileUtils.getFileByName(filePath))

            else -> throw NotImplementedError()
        }
    }

    fun getURI(): String {
        when (resourceType) {
            Res.ASSET -> return assetPath!!
            Res.DRAWABLE -> return drawableRes.toString()
            Res.FILE -> return filePath!!
            Res.WEB -> return url!!
            else -> throw NotImplementedError()
        }
    }

    private fun getContext(): Application {
        return AppContext.get()
    }

    companion object {

        fun fromAsset(assetPath: String): ImageResource {
            val image = ImageResource(Res.ASSET)
            image.assetPath = assetPath
            return image
        }

        fun fromWeb(url: String): ImageResource {
            val image = ImageResource(Res.WEB)
            image.url = url
            return image
        }

        fun fromFile(fullFilePath: String): ImageResource {
            val image = ImageResource(Res.FILE)
            image.filePath = fullFilePath
            return image
        }

        fun fromDrawable(@DrawableRes drawableRes: Int): ImageResource {
            val image = ImageResource(Res.DRAWABLE)
            image.drawableRes = drawableRes
            return image
        }

        fun from(uri: String, resourceType: Int): ImageResource {
            val image = ImageResource(resourceType)
            when (resourceType) {
                Res.ASSET -> image.assetPath = uri
                Res.DRAWABLE -> image.drawableRes = Integer.parseInt(uri)
                Res.FILE -> image.filePath = uri
                Res.WEB -> image.url = uri
            }
            return image
        }
    }
}
