package com.nasserkhosravi.appcomponent;

import android.support.v7.widget.RecyclerView;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class JReflection {

    public static <T> ArrayList<T> find(RecyclerView.ViewHolder vh, Class<? extends Annotation> certainAnnotate) {
        Class<? extends RecyclerView.ViewHolder> c = vh.getClass();
        ArrayList<T> result = new ArrayList<>();
        for (Field field : c.getDeclaredFields()) {
            if (field.isAnnotationPresent(certainAnnotate)) {
                field.setAccessible(true);
                try {
                    T v = (T) field.get(vh);
                    result.add(v);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

}
