package com.nasserkhosravi.appcomponent;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;

import java.util.UUID;

/**
 * Created by Nasser Khosravi on 12/8/2017.
 */

public class Device {
    private static Device instance;
    public int width;
    public int height;
    private String deviceId;
    private SharedPreferences pref;

    private Device() {
        Application app = AppContext.INSTANCE.get();
        pref = app.getSharedPreferences("device", Context.MODE_PRIVATE);
        width = app.getResources().getDisplayMetrics().widthPixels;
        height = app.getResources().getDisplayMetrics().heightPixels;
        controlDeviceId();
    }

    public static Device get() {
        if (instance == null) {
            instance = new Device();
        }
        return instance;
    }

    public static boolean isEmulator() {
        return Build.FINGERPRINT.startsWith("generic")
                || Build.FINGERPRINT.startsWith("unknown")
                || Build.MODEL.contains("google_sdk")
                || Build.MODEL.contains("Emulator")
                || Build.MODEL.contains("Android SDK built for x86")
                || Build.MANUFACTURER.contains("Genymotion")
                || (Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic"))
                || "google_sdk".equals(Build.PRODUCT);
    }

    /**
     * life cycle of id is per install
     * reset ability is imposable
     */
    private void controlDeviceId() {
        String string = pref.getString("id", "null");
        if (string.equals("null")) {
            setDeviceId();
        } else {
            loadDeviceId();
        }
    }

    private void setDeviceId() {
        String generateId = UUID.randomUUID().toString();
        pref.edit().putString("id", generateId).apply();
        deviceId = generateId;
    }

    private void loadDeviceId() {
        String id = pref.getString("id", "null");
        if (!id.equals("null")) {
            deviceId = id;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getDeviceId() {
        return deviceId;
    }
}
