package com.nasserkhosravi.appcomponent;

import android.view.ViewGroup;

/**
 * Created by Nasser Khosravi on 12/24/2017
 */
public class BaseViewGroupManager {
    private ViewGroup viewGroup;

    BaseViewGroupManager() {
    }

    public ViewGroup getViewGroup() {
        if (viewGroup == null) {
            build();
        }
        return viewGroup;
    }

    public void setViewGroup(ViewGroup newViewGroup) {
        this.viewGroup = newViewGroup;
    }

    private void build() {
        if (viewGroup == null) {
            throw new NullPointerException("on view group.");
        }
    }

    public void destroy() {
        viewGroup = null;
    }
}
