package com.nasserkhosravi.appcomponent

import android.content.Context
import android.support.annotation.NonNull
import android.view.ViewGroup

/**
 * Created by Nasser Khosravi on 12/24/2017
 */
class AppComponent(override var ctx: Context) : ResourceComponent {

    private lateinit var config: BaseConfig
    private lateinit var viewGroupManager: BaseViewGroupManager
    private lateinit var viewManger: BaseViewAccessor

    fun construct() {
        config = BaseConfig()
        viewGroupManager = BaseViewGroupManager()
        viewManger = BaseViewAccessor(this, viewGroupManager, config)
    }

    fun getConfig(): BaseConfig {
        return config
    }

    fun getViewAccessor(): BaseViewAccessor {
        return viewManger
    }

    fun getViewGroupManager(): BaseViewGroupManager {
        return viewGroupManager
    }

    @NonNull
    fun getViewGroup(): ViewGroup? {
        return viewGroupManager.viewGroup
    }


}