/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.adapters;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.NRLabel;
import java.util.List;
import nanorep.nanowidget.R;
import nanorep.nanowidget.adapters.NRBaseAdapter;

public class NRLabelsAdapter
extends NRBaseAdapter<ViewHolder> {
    private final NRLabelsListener listener;
    private int titleItemLabel;
    private List<NRLabel> labels;

    @Override
    public void setEnabledViewHolderClicks(boolean enable) {
        this.enableClicks = enable;
    }

    public NRLabelsAdapter(NRLabelsListener listener, int titleItemLabel, @NonNull List<NRLabel> labels) {
        this.titleItemLabel = titleItemLabel;
        this.enableClicks = true;
        this.listener = listener;
        this.labels = labels;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Context context = parent.getContext();
        View view = LayoutInflater.from((Context)context).inflate(this.titleItemLabel, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        NRLabel label = this.labels.get(position);
        holder.textView.setText((CharSequence)label.getTitle());
        this.loadImage(holder.imageView, label.getIcon());
    }

    private void loadImage(final ImageView imageView, String url) {
        if (url == null || url.length() == 0) {
            return;
        }
        Nanorep.getInstance().getWidgetListener().onCachedImageRequest(url, new Nanorep.NRCachedImageResponder(){

            public void onBitmapResponse(Bitmap bitmap) {
                if (bitmap != null) {
                    imageView.setImageBitmap(bitmap);
                }
            }
        });
    }

    public int getItemCount() {
        return this.labels.size();
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        public ImageView imageView;
        public TextView textView;

        public ViewHolder(View view) {
            super(view);
            view.findViewById(R.id.titleLayout).setOnClickListener((View.OnClickListener)this);
            this.textView = (TextView)view.findViewById(R.id.titleTextView);
            this.imageView = (ImageView)view.findViewById(R.id.label_image);
        }

        public void onClick(View v) {
            if (NRLabelsAdapter.this.enableClicks) {
                NRLabelsAdapter.this.enableClicks = false;
                NRLabelsAdapter.this.listener.onLabelSelected((NRLabel)NRLabelsAdapter.this.labels.get(this.getAdapterPosition()));
            }
        }
    }

    public static interface NRLabelsListener {
        public void onLabelSelected(NRLabel var1);
    }
}

