/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRHtmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.R;

public class NRContentView
extends NRCustomContentView
implements View.OnKeyListener {
    private WebView mWebView;
    private ProgressBar mLoadingView;
    boolean loadingFinished = true;
    boolean redirect = false;
    private Pattern mPattern;

    public NRContentView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.content, (ViewGroup)this);
        this.mPattern = Pattern.compile("(?<=src=\")[^\"]*(?<!\")");
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.mWebView = (WebView)child.findViewById(R.id.nrWebview);
        this.mLoadingView = (ProgressBar)child.findViewById(R.id.contentProgressBar);
        this.mWebView.setVerticalScrollBarEnabled(false);
        this.mWebView.setHorizontalScrollBarEnabled(false);
        this.mWebView.setOnKeyListener((View.OnKeyListener)this);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return this.shouldOverrideUrl(view, url);
            }

            @TargetApi(value=21)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                return this.shouldOverrideUrl(view, request.getUrl().toString());
            }

            private boolean shouldOverrideUrl(WebView webView, String url) {
                String phonePrefix = "tel://";
                if (url.contains("answerId")) {
                    NRContentView.this.linkedArticle(url);
                    return true;
                }
                if (url.startsWith("tel://")) {
                    try {
                        Intent intent = new Intent("android.intent.action.DIAL");
                        intent.setData(Uri.parse((String)("tel:" + "tel://".length())));
                        NRContentView.this.getContext().startActivity(intent);
                    }
                    catch (Exception intent) {
                        // empty catch block
                    }
                    return true;
                }
                if (url.endsWith("pdf") || !Nanorep.getInstance().getAccountParams().isOpenLinksInternally()) {
                    try {
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)url));
                        NRContentView.this.getContext().startActivity(intent);
                    }
                    catch (Exception exception) {
                        Log.i((String)"LinkError", (String)"Cannot open link externally");
                    }
                    return true;
                }
                if (!url.startsWith("file:///")) {
                    NRContentView.this.mListener.onLinkClicked(url);
                }
                return false;
            }

            public void onPageStarted(WebView view, String url, Bitmap facIcon) {
                NRContentView.this.loadingFinished = false;
                NRContentView.this.mLoadingView.setVisibility(0);
            }

            public void onPageFinished(WebView view, String url) {
                if (!NRContentView.this.redirect) {
                    NRContentView.this.loadingFinished = true;
                }
                if (NRContentView.this.loadingFinished && !NRContentView.this.redirect) {
                    NRContentView.this.mLoadingView.setVisibility(4);
                } else {
                    NRContentView.this.redirect = false;
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                if (Build.VERSION.SDK_INT < 23) {
                    super.onReceivedError(view, errorCode, description, failingUrl);
                    NRContentView.this.mListener.onError(NRError.error((String)NRContentView.class.getName(), (int)errorCode, (String)(failingUrl + ": " + description)));
                }
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                if (Build.VERSION.SDK_INT >= 23) {
                    super.onReceivedError(view, request, error);
                    NRContentView.this.mListener.onError(NRError.error((String)NRContentView.class.getName(), (int)error.getErrorCode(), (String)error.getDescription().toString()));
                }
            }
        });
    }

    private void linkedArticle(String link) {
        this.mListener.onLinkedArticleClicked(Uri.parse((String)link));
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mWebView.requestDisallowInterceptTouchEvent(true);
        return super.onTouchEvent(event);
    }

    @Override
    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @Override
    public void loadData(final String data, final String mimeType, final String encoding) {
        String iframe = this.isFrameExist(data);
        String domain = null;
        if (iframe != null) {
            domain = this.getDomain(iframe);
        }
        if (domain == null) {
            domain = "file://";
            this.loadRedirectedUrl(domain, data, mimeType, encoding);
        } else {
            HandlerThread fetchRedirect = new HandlerThread("fetchRedirect");
            fetchRedirect.start();
            Handler handler = new Handler(fetchRedirect.getLooper());
            final String finalDomain = domain;
            handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        final URLConnection con = new URL(finalDomain).openConnection();
                        con.connect();
                        InputStream is = con.getInputStream();
                        is.close();
                        NRContentView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                NRContentView.this.loadRedirectedUrl(con.getURL().toString(), data, mimeType, encoding);
                            }
                        });
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private String isFrameExist(String data) {
        String iframe = null;
        int start = data.indexOf("<iframe");
        if (start != -1) {
            iframe = data.substring(start);
            int end = iframe.indexOf("</iframe>");
            if (end == -1) {
                end = iframe.indexOf("/>");
            }
            if (end != -1) {
                iframe = iframe.substring(0, end);
            }
        }
        return iframe;
    }

    private String getDomain(String iframe) {
        String domain = null;
        Matcher matcher = this.mPattern.matcher(iframe);
        while (matcher.find()) {
            domain = matcher.group();
        }
        return domain;
    }

    private void loadRedirectedUrl(String url, String data, String mimeType, String encoding) {
        NRHtmlParser parser = new NRHtmlParser(data);
        String parsed = parser.getParsedHtml();
        String script = "\n<style>\n        img {\n            max-width: 100% !important;\n            height: auto !important;\n            }\n        body {\n            font-family: Roboto-Light;\n            color: #6c6c6c;\n            }\n</style>\n\n\n<script>\n\t\t(function() {\n\t\t\tvar embeds = document.querySelectorAll('iframe');\n\t\t\tfor (var i = 0, embed, content, width, height, ratio, wrapper; i < embeds.length; i++) {\n\t\t\t\tembed = embeds[i];\n\t\t\t\twidth = embed.getAttribute('width'),\n\t\t\t\theight = embed.getAttribute('height')\n\t\t\t\tratio = width / height;\n\n\t\t\t\t// skip frames with relative dimensions\n\t\t\t\tif (isNaN(ratio)) continue;\n\n\t\t\t\t// set wrapper styles\n\t\t\t\twrapper = document.createElement('div');\n\t\t\t\twrapper.style.position = 'relative';\n\t\t\t\twrapper.style.width = width.indexOf('%') < 0 ? parseFloat(width) + 'px' : width;\n\t\t\t\twrapper.style.maxWidth = '100%';\n\n\t\t\t\t// set content styles\n\t\t\t\tcontent = document.createElement('div');\n\t\t\t\tcontent.style.paddingBottom = 100 / ratio + '%';\n\n\t\t\t\t// set embed styles\n\t\t\t\tembed.style.position = 'absolute';\n\t\t\t\tembed.style.width = '100%';\n\t\t\t\tembed.style.height = '100%';\n\n\t\t\t\t// update DOM structure\n\t\t\t\tembed.parentNode.insertBefore(wrapper, embed);\n\t\t\t\tcontent.appendChild(embed);\n\t\t\t\twrapper.appendChild(content);\n\t\t\t}\n\t\t}());\n\t</script>";
        parsed = parsed + script;
        if (this.mWebView != null) {
            this.mWebView.loadDataWithBaseURL(url, parsed, mimeType, encoding, "file://");
        }
    }

    @Override
    public void loadUrl(String url) {
        this.mWebView.loadUrl(url);
    }

    @Override
    public void loadDataRAW(String content, String mime, String encoding) {
        this.mWebView.loadData("<html><body>" + content + "</body></html>", mime, encoding);
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (event.getAction() == 0 && keyCode == 4) {
            if (this.mWebView.getUrl().startsWith("http")) {
                if (this.mWebView.canGoBack()) {
                    this.mWebView.goBack();
                }
            } else if (this.mListener != null) {
                this.mListener.onDismiss();
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.mWebView.clearHistory();
        this.mWebView.clearCache(true);
        this.mWebView.clearFormData();
        this.mWebView.freeMemory();
    }

    public static interface Listener {
        public void onLinkedArticleClicked(@NonNull Uri var1);

        public void onLinkClicked(String var1);

        public void onDismiss();

        public void onError(NRError var1);
    }
}

