package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.gson.Gson;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.model.NRResult;
import com.nanorep.nanoclient.model.ResultResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.FAQDataSource;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.SearchFetcherListener;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

import static android.view.View.GONE;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FETCH_DATA;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.SESSION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.noSuggestions;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.noSuggestionsInCache;
import static com.nanorep.nanoclient.Handlers.NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE;
import static com.nanorep.nanoclient.model.ResultResponseKt.faqType;

public class ResultsFragment extends Fragment implements
        NRSearchBarListener,
        NRSuggestionsListener,
        NRResultsView.Listener,
        NRErrorHandler.Listener {

    public static final String TAG = ResultsFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRFetchedDataManager mFetchedDataManager;

    private NRCustomViewAdapter viewAdapter;

    private ProgressBar mLoadingView;

    private boolean resetSuggestions = false;

    private SearchViewsProvider viewsProvider;

    private FrameLayout contentMain;

    private Nanorep.NanoRepWidgetListener widgetListener;

    private FragmentManager fragmentManager;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private List<ResultResponse> results;
    private String title;

    private boolean autocompleteEnabled = true;

    // no connection
    private LinearLayout noConnectionView;

    private boolean fragmentPaused;
    private NRResultsView resultsView;
    private boolean killedBySystem;
    private NRLabel label;

    private ViewGroup container;
    private boolean clearUIInstance;

    private FAQDataSource faqDataSource;
    private @Nullable String labelId;

    public static ResultsFragment newInstance(@Nullable String labelId, FAQDataSource faqDataSource, SearchViewsProvider viewsProvider) {

        ResultsFragment fragment = new ResultsFragment();
        fragment.faqDataSource = faqDataSource;
        fragment.labelId = labelId;
        fragment.viewsProvider = viewsProvider;

        return fragment;
    }

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider, List<ResultResponse> results, String title) {

        ResultsFragment fragment = new ResultsFragment();

        fragment.viewsProvider = viewsProvider;
        fragment.results = results;
        fragment.title = title;

        return fragment;
    }

    public static ResultsFragment newInstance(SearchInjector searchInjector, NRLabel label) {

        ResultsFragment fragment = new ResultsFragment();

        fragment.viewsProvider = searchInjector.getUiProvider();
        fragment.label = label;

        return fragment;
    }

    public static ResultsFragment newInstance(SearchInjector searchInjector) {

        ResultsFragment fragment = new ResultsFragment();

        fragment.viewsProvider = searchInjector.getUiProvider();
        fragment.label = null;

        return fragment;
    }

    public static ResultsFragment newInstance() {

        ResultsFragment fragment = new ResultsFragment();

        fragment.label = null;

        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private void initDataManager() {

        SearchFetcherListener fetcherListener = new SearchFetcherListener() {

            @Override
            public void reloadWithAnimation() {

            }

            @Override
            public void reload() {

            }

            @Override
            public void insertRows(final List<ResultResponse> results, final String searchContext) {
                if (isDetached() || getContext() == null) {
                    return;
                }

                NanorepUI.getInstance().updateDynamicContextValue(searchContext);

                //String searchContextValue = NanorepUI.getInstance().getSearchContextValue();

                String tag = null;

                NRResult result = null;

                if (results == null || (results.size() == 1 && ((NRResult) results.get(0)).getFetchedResult() == null)) {
                    if (searchBarView.getSearchQuery() != null) {
                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    if (results == null) {
                        Map<String, Object> params = new HashMap<>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = (NRResult) results.get(0);
                    }

                    tag = ArticleFragment.TAG;

                    openArticleFragment(result, 0, null, tag ,true);


                } else if (results.size() == 1) {
                    final NRResult currentResult = (NRResult) results.get(0);
                    if (currentResult != null) {
                        final NRQueryResult fetchedResult = currentResult.getFetchedResult();
                        if (fetchedResult != null) {


                            result = (NRResult) results.get(0);

                            result.setSingle(true);

                            tag = result.getFetchedResult().getId();

                            requestFocus();
                        }
                    }

                    openArticleFragment(result, 0, null, tag, true);

                } else if (results.size() > 1) {
                    NanorepUI.getInstance().setResults(results);
                    openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (searchBarView != null && searchBarView.getSearchQuery() != null && !searchBarView.getSearchQuery().isEmpty() && !resetSuggestions && searchBarView.getSearchQuery().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);
                    mSuggestionViewContainer.setVisibility(View.VISIBLE);
                    Nanorep.getInstance().onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
               Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, CONNECTION, getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                NanorepUI.getInstance().updateDynamicContextValue(null);

                if (resultsView != null){
                    resultsView.enableAdapterClicks(true);
                }

                resetSuggestions = true;
            }
        };

        NanorepUI.getInstance().setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener() {
            @Override
            public void onError(NRError error) {

                mLoadingView.setVisibility(GONE);

                if (error != null) {

                    Context context = getContext();

                    switch (error.getCode()) {
                        case CONNECTION:
                            if (context != null) {
                                NRErrorView errorView = new NRErrorView(context);
                                errorView.setListener(new NRErrorView.Listener() {
                                    @Override
                                    public void tryAgain() {
                                        mFetchedDataManager.fetchConfiguration();
                                        mLoadingView.setVisibility(View.VISIBLE);
                                    }
                                });

                                contentMain.addView(errorView);
                            }
                            break;

                        case noSuggestions:
                        case noSuggestionsInCache:
                            clearSuggestionsView();
                    }
                }
            }
        });

        NanorepUI.getInstance().setContext(getContext());
        mFetchedDataManager = NanorepUI.getInstance().getDataManager(fetcherListener);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        this.container = container;

        return inflater.inflate(R.layout.fragment_results, container, false);
    }

    @Override
    public void onStart() {
        super.onStart();
        clearUIInstance = true;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        if (NanorepUI.getInstance().getLabel() != null) {
            label = NanorepUI.getInstance().getLabel();
        } else {
            NanorepUI.getInstance().setLabel(label);
        }

        if (savedInstanceState != null) {
            Gson gson = new Gson();

            label = gson.fromJson(savedInstanceState.getString("label"), NRLabel.class );

            String restoredLabelId = savedInstanceState.getString("labelId");

            if (restoredLabelId != null) {
                this.labelId = restoredLabelId;
            }

            NanorepUI.getInstance().setLabel(label);
        }

        killedBySystem = false;

        widgetListener = Nanorep.getInstance().getWidgetListener();
        fragmentManager = getFragmentManager();

        if (viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider(viewsProvider);
        } else {
            if (Nanorep.getInstance().getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) Nanorep.getInstance().getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        NRErrorHandler.getInstance().setListener(this);

        initDataManager();

        contentMain = view.findViewById(R.id.results_content_main);
        mLoadingView = contentMain.findViewById(R.id.results_loadingView);
        noConnectionView = view.findViewById(R.id.results_noConnectionView);

        mLoadingView.setVisibility(View.VISIBLE);

        setViews(view);

        if (NanorepUI.getInstance().getResults() != null) {
            results = NanorepUI.getInstance().getResults();
        }

        label = NanorepUI.getInstance().getLabel();

        if (results == null || results.isEmpty()) {
            if (Nanorep.getInstance().getAccountParams().isSupportCenterMode() && faqDataSource != null) {
                fetchSupportCenter();
            } else {
                fetchResultsForLabel();
            }
        } else {
            openNRResultView(results, title);
        }

    }


    private void fetchSupportCenter() {

        results = new ArrayList<>();

        openNRResultView(results, "");
        resultsView.setAnimated(false);

        faqDataSource.setLabel(labelId, new Function1<List<? extends ResultResponse>, Unit>() {
            @Override
            public Unit invoke(List<? extends ResultResponse> resultResponses) {

                List<ResultResponse> resultResponse = new ArrayList<>(resultResponses);
                resultsView.updateList(resultResponse);

                return null;
            }
        }, new Function1<Integer, Unit>() {
            @Override
            public Unit invoke(Integer integer) {
                resultsView.notifyItemChanged(integer);
                return null;
            }
        });
    }

    private void fetchResultsForLabel() {
        if (label == null) {
            label = new NRLabel();
        }
        NanorepUI.getInstance().getDataManager().fetchLabelFAQ(label, new NanorepUI.FaqsListener() {
            @Override
            public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
                Context context = getContext();
                if (groups != null) {
                    if (context != null) {
                        openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), context), groups.get(0).getTitle());
                    } else if (widgetListener != null) {
                        Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, SESSION, "the context is null"));
                    }
                } else {
                    showConnectionError(TIMEOUT_UPPER_LINE);
                    mLoadingView.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void enableSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    @Override
    public void onClearSearchText() {

        NanorepUI.getInstance().updateDynamicContextValue(null);

        fetchResultsForLabel();

        resetSuggestions = true;

        clearSuggestionsView();

        if (resultsView != null) {
            resultsView.enableAdapterClicks(true);
        }

        setLoadingState(false);
    }

    private void clearSuggestionsView() {
        if (mSuggestionsView != null) {
            mSuggestionsView.setSuggestions(null);
        }

        if (mSuggestionViewContainer != null) {
            mSuggestionViewContainer.setVisibility(GONE);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        searchBarView.setViewsProvider(viewsProvider);

        String titleBGColor;

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        } else {
            titleBGColor = "#0aa0ff";
        }

        searchBarContainer.setBackgroundColor(Color.parseColor(titleBGColor));

        if (viewsProvider != null && label != null && !viewsProvider.isSearchBarAlwaysOnTop()) {
            searchBarView.adaptSearchBarDisplay(true, label.getTitle(), false);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {

        Context context = nanoView.getContext();

        if (context != null && viewAdapter != null) {
            // suggestion view
            mSuggestionViewContainer = nanoView.findViewById(R.id.results_suggestion_view_container);

            mSuggestionsView = viewAdapter.getSuggestionsView(context);

            if (mSuggestionsView == null) {
                mSuggestionsView = new NRSuggestionsView(context);
            }

            mSuggestionsView.setListener(this);

            mSuggestionViewContainer.addView(mSuggestionsView);

            // search bar
            searchBarContainer = nanoView.findViewById(R.id.results_search_bar_container);

            searchBarView = viewAdapter.getSearchBar(context);

            if (searchBarView == null && viewsProvider != null) {
                searchBarView = new NRSearchBar(context, viewsProvider.getSearchBarLayout());
            }

            searchBarView.setListener(this);

            if (searchBarView.getParent() != null) {
                ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
            }

            searchBarView.presentSuggestions(false);

            searchBarContainer.addView(searchBarView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));

            updateTitleNormalText();
            updateSearchBar();

        }
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        NanorepUI.getInstance().hideKeyboard(container);
        if (resultsView != null) {
            resultsView.enableAdapterClicks(false);
        }
        resetSuggestions = true;
        clearSuggestionsView();
        mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        if (fragmentManager != null) {
            fragmentManager.popBackStack();
        }
    }

    @Override
    public void onEmptyQuery() {

    }

    @Override
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation anim = null;

        if (nextAnim != 0) {
            anim = AnimationUtils.loadAnimation(getActivity(), nextAnim);

            anim.setAnimationListener(new Animation.AnimationListener() {

                @Override
                public void onAnimationStart(Animation animation) {
                    NanorepUI.getInstance().hideKeyboard(contentMain);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                }
            });
        }

        return anim;
    }

    @Override
    public void onSuggestionSelected(String suggestion) {

        NanorepUI.getInstance().hideKeyboard(container);
        resultsView.enableAdapterClicks(false);
        resetSuggestions = true;
        searchBarView.updateText(suggestion, false);
        mFetchedDataManager.searchText(suggestion);
        clearSuggestionsView();
    }

    @Override
    public void onResultSelected(final int y, ResultResponse result) {

        String tag;

        resetSuggestions = true;

        if (result != null) {

            if (result.getResponseType() == faqType) {

                NRResult nrResult = ((NRResult) result);

                if (nrResult.getFetchedResult() != null) {
                    tag = nrResult.getFetchedResult().getId();
                } else {
                    tag = ArticleFragment.TAG;

                }

                openArticleFragment(nrResult, y, null, tag, false);

            } else { //Result is a label

                fragmentManager
                        .beginTransaction()
                        .setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right)
                        .replace(container.getId(), newInstance(result.getResponseId(), faqDataSource, viewsProvider))
                        .addToBackStack(null)
                        .commitAllowingStateLoss();
            }
        }
    }

    private void openArticleFragment(NRResult result, int y, String searchContext, String tag, boolean clearSearchText) {

        clearUIInstance = false;

        if (searchBarView != null && clearSearchText) {
            searchBarView.clearText();
        }

        View view = getView();

        Nanorep.getInstance().clearSuggestionsData();

        if (view != null) {
            mLoadingView.setVisibility(View.VISIBLE);
            setLoadingState(true);

            NanorepUI.getInstance().addToArticleStuck(result);

            if (fragmentManager != null && container != null) {
                fragmentManager
                        .beginTransaction()
                        .setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right)
                        .replace(container.getId(), ArticleFragment.newInstance(result, y, searchContext, false), tag)
                        .addToBackStack(null)
                        .commitAllowingStateLoss();
            }
        }
    }

    private void requestFocus() {
        View view = getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                if (resultsView != null) {
                    resultsView.enableAdapterClicks(true);
                    setLoadingState(true);
                }
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                    NanorepUI.getInstance().hideKeyboard(getView());
                }

                break;
        }
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }

            View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

            actionBar.setCustomView(customActionBar, layout);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);

            Toolbar parent = (Toolbar) customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
            parent.setContentInsetsAbsolute(0, 0);

            TextView actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


            // titleConfig text
            String titleText = Nanorep.getInstance().getNRConfiguration().getTitleText();
            setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

            // titleConfig color
            if (!isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor(titleColor));
            }

            // titleConfig background color
            if (!isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
            }

            // titleConfig font
            if (!isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    @Override
    public void dismissConnectionError() { }

    private void openNRResultView(List<ResultResponse> results, String title) {
        try {

            NanorepUI.getInstance().setResults(results);

            View fragmentView = getView();

            if (fragmentView != null && viewsProvider != null) {

                dismissConnectionError();

                resultsView = new NRResultsView(getActivity());

                resultsView.setListener(ResultsFragment.this);

                int faqLayout = viewsProvider.getFaqItemLayout();
                int labelLayout = viewsProvider.getLabelItemLayout();

                resultsView.setResults(results, title, viewAdapter, faqLayout, labelLayout);

                resultsView.setIsAnimated(true);
                resultsView.enableAdapterClicks(true);

                contentMain.requestFocus();

                requestFocus();

                setLoadingState(false);
                mLoadingView.setVisibility(GONE);

                contentMain.addView(resultsView);

                String queryText = Nanorep.getInstance().getPreviousQueryText();
                ArrayList<Spannable> suggestions = Nanorep.getInstance().getPreviousSuggestions();

                if (queryText != null && suggestions != null) {
                    NanorepUI.getInstance().getDataManager().getFetcherListener().presentSuggestion(queryText, suggestions);
                }
            }

            enableSuggestionsView();
            clearSuggestionsView();

        } catch(Exception e){
            Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, FETCH_DATA, getString(R.string.results_view_error)));
        }
    }

    private void setLoadingState(boolean state) {
        resultsView.setLoading(state);
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();

        viewsProvider = null;
        widgetListener = null;
        clearSuggestionsView();

        if (!killedBySystem) {

            if (fragmentManager != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    String tag = fragment.getTag();
                    if (tag != null && tag.equals(NRWebContentFragment.TAG))
                        fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
                }
            }

            if (clearUIInstance) {
                NanorepUI.getInstance().setResults(null);
                Nanorep.getInstance().clearSuggestionsData();
                NanorepUI.getInstance().clearCurrentLabel();
                NanorepUI.getInstance().clearInstance();
            }
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            fragmentPaused = false;
        }

        if (resultsView != null) {
            resultsView.enableAdapterClicks(true);
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        killedBySystem = true;

        Gson gson = new Gson();
        outState.putString("labelId", labelId);
        outState.putString("label", gson.toJson(NanorepUI.getInstance().getLabel()));
    }
}
