/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.ChannelPresenters;

import android.net.Uri;
import android.util.Log;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingChatForm;
import com.nanorep.nanoclient.Channeling.NRChannelingContactForm;
import com.nanorep.nanoclient.Channeling.NRChannelingOpenCustomURL;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.NRResult;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import org.json.JSONObject;

public class NRWebContentChannelPresenter
implements NRChannelPresenter {
    private Nanorep mNanoRep;
    private NRChanneling mChanneling;

    public NRWebContentChannelPresenter(Nanorep nanoRep) {
        this.mNanoRep = nanoRep;
    }

    @Override
    public void present() {
        Uri.Builder channelUri = new Uri.Builder();
        channelUri.scheme("http").authority("dev4.nanorep.com");
        AccountParams accountParams = this.mNanoRep.getAccountParams();
        NRQueryResult queryResult = this.mChanneling.getQueryResult();
        String url = null;
        switch (this.mChanneling.getType()) {
            case ContactForm: {
                channelUri.appendEncodedPath("sdk/mobile/contactform.html");
                channelUri.appendQueryParameter("account", accountParams.getAccount());
                channelUri.appendQueryParameter("articleId", queryResult.getId());
                channelUri.appendQueryParameter("context", "null").appendQueryParameter("host", "my.nanorep.com");
                channelUri.appendQueryParameter("kb", accountParams.getKnowledgeBase());
                channelUri.appendQueryParameter("text", queryResult.getTitle());
                channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm)this.mChanneling).getContactForms());
                channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                break;
            }
            case ChatForm: {
                channelUri.appendEncodedPath("sdk/mobile/chat.html");
                channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm)this.mChanneling).getChatProvider());
                channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm)this.mChanneling).getAccountNum());
                channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                break;
            }
            case OpenCustomURL: {
                channelUri = null;
                url = ((NRChannelingOpenCustomURL)this.mChanneling).getLinkUrl();
            }
        }
        String mUrl = url == null ? channelUri.toString() : url;
    }

    @Override
    public String getUrl() {
        if (this.mChanneling != null) {
            NRQueryResult queryResult = this.mChanneling.getQueryResult();
            AccountParams accountParams = this.mNanoRep.getAccountParams();
            JSONObject channelingExtraData = this.mChanneling.getExtraData();
            Uri.Builder channelUri = accountParams.getUri();
            String host = accountParams.getHost() != null ? accountParams.getHost() + ".nanorep.com" : accountParams.getAccount() + ".nanorep.co";
            String url = null;
            String articleId = "0";
            String title = "No Results";
            if (queryResult != null) {
                articleId = queryResult.getId();
                title = queryResult.getTitle();
            }
            switch (this.mChanneling.getType()) {
                case ContactForm: {
                    channelUri.appendEncodedPath("sdk/mobile/contactform.html");
                    if (this.mChanneling.getQueryResult() != null) {
                        channelUri.appendQueryParameter("articleId", articleId);
                        channelUri.appendQueryParameter("text", title);
                    }
                    channelUri.appendQueryParameter("account", accountParams.getAccount());
                    channelUri.appendQueryParameter("kb", accountParams.getKnowledgeBase());
                    channelUri.appendQueryParameter("contactFormId", ((NRChannelingContactForm)this.mChanneling).getContactForms());
                    channelUri.appendQueryParameter("customCSS", ".CF_textFieldDiv%20%7B%20background%3A%20none%20!important%20%7D%0Alabel.fieldElement%20%7B%20background%3A%20none%20!important%20%7D%0Ainput%5Bname%3D%22submitbutton%22%5D%20%7B%20background%3A%20%2348af4a%20!important%20%7D\"");
                    channelUri.appendQueryParameter("channelName", this.mChanneling.getName());
                    channelUri.appendQueryParameter("host", host);
                    if (channelingExtraData == null) break;
                    channelUri.appendQueryParameter("predefinedValues", channelingExtraData.toString());
                    break;
                }
                case ChatForm: {
                    channelUri.appendEncodedPath("sdk/mobile/chat.html");
                    channelUri.appendQueryParameter("channel.chatProvider", ((NRChannelingChatForm)this.mChanneling).getChatProvider());
                    channelUri.appendQueryParameter("channelUri.appendQueryParameter", ((NRChannelingChatForm)this.mChanneling).getAccountNum());
                    channelUri.appendQueryParameter("channel.chatOptions.apiKey", "c774b56ff8a64cbba27743a8d4418b26");
                    break;
                }
                case OpenCustomURL: {
                    channelUri = null;
                    url = ((NRChannelingOpenCustomURL)this.mChanneling).getLinkUrl();
                }
            }
            url = url == null && channelUri != null ? channelUri.toString() : url;
            Log.d((String)"NRWebContentChannel", (String)url);
            return url;
        }
        return null;
    }

    @Override
    public void setChannel(NRChanneling channeling) {
        this.mChanneling = channeling;
    }

    @Override
    public NRResult getResult() {
        return null;
    }
}

