package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.model.ResultResponse;

import java.util.List;

import nanorep.nanowidget.R;
import nanorep.nanowidget.adapters.NRResultsAdapter;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;


/**
 * Created by noat on 08/11/2016.
 */

public class NRResultsView extends BaseListView implements NRResultsAdapter.Listener{
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private ProgressBar loadingView;
    private TextView faqTitle;

    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public interface Listener{
        void onResultSelected(int y, ResultResponse resultResponse);
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.results_view, this);
    }

    @Override
    public void enableAdapterClicks(boolean enable) {
        if (adapter != null) {
            adapter.setEnabledViewHolderClicks(enable);
        }
    }

    @Override
    public void setLoading(boolean loading) {
        loadingView.setVisibility(loading ? VISIBLE : INVISIBLE);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        adapter = new NRResultsAdapter();
        mResultsRecyclerView = child.findViewById(R.id.resultsListRecycler);
        mResultsRecyclerView.addItemDecoration(new SimpleDividerItemDecoration(getContext(), getResources(), SimpleDividerItemDecoration.PAGE_RESULTS));
        mResultsRecyclerView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        if (!isAnimated) {
            SimpleItemAnimator animator = ((SimpleItemAnimator) mResultsRecyclerView.getItemAnimator());
            if (animator != null) {
                animator.setSupportsChangeAnimations(false);
            }
        }
        mResultsRecyclerView.setAdapter(adapter);

        loadingView = child.findViewById(R.id.loading_view);

        if (!Nanorep.getInstance().getAccountParams().isSupportCenterMode()) {
            faqTitle = child.findViewById(R.id.faqTitle);
            faqTitle.setVisibility(VISIBLE);
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<ResultResponse> results, String title, NRCustomViewAdapter viewAdapter, int faqItemLayout, int labelItemLayout)  {

        this.title = title;

        adapter.setFaqItemLayout(faqItemLayout);
        adapter.setLabelItemLayout(labelItemLayout);
        adapter.setListener(this);
        updateList(results);
    }

    public String getTitle() {
        return title;
    }

    @Override
    public void onResultItemSelected(ResultResponse result, int pos) {
        listener.onResultSelected(0, result);
    }

    public void notifyItemChanged(Integer integer) {
        adapter.notifyItemChanged(integer);
    }

    public void updateList(List<ResultResponse> results) {
        adapter.updateItems(results);
        adapter.notifyDataSetChanged();
    }
}
