package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.R;
import nanorep.nanowidget.adapters.NRBaseAdapter;
import nanorep.nanowidget.adapters.NRCategoriesAdapter;
import nanorep.nanowidget.adapters.NRLabelsAdapter;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;

/**
 * Created by noat on 08/11/2016.
 */

public class NRCategoriesView extends BaseListView {

    private RecyclerView mResultsRecyclerView;
    private ProgressBar loadingView;
    private TextView faqTitle;
    private NRBaseAdapter adapter = null;
    private int labelItemTitleView;

    @Override
    public void enableAdapterClicks(boolean enable) {
        if (adapter != null) {
            adapter.setEnabledViewHolderClicks(enable);
        }
    }

    @Override
    public void setLoading(boolean loading) {
        loadingView.setVisibility(loading ? VISIBLE : INVISIBLE);
    }

    public interface Listener {
        void onCategorySelected(NRFAQGroupItem groupItem);
    }

    public NRCategoriesView(Context context, int resultsView) {
        super(context);

        try {
            LayoutInflater.from(context).inflate(resultsView, this);
        } catch (NullPointerException | InflateException e) {
            LayoutInflater.from(context).inflate(R.layout.results_view, this);
        }
    }

    public void setLabelItemTitleView(int labelItemTitleView) {
        this.labelItemTitleView = labelItemTitleView;
    }

    public NRBaseAdapter getAdapter() {
        return adapter;
    }


    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        faqTitle = child.findViewById(R.id.faqTitle);
        mResultsRecyclerView = child.findViewById(R.id.resultsListRecycler);
        mResultsRecyclerView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        mResultsRecyclerView.setItemAnimator(null);
        mResultsRecyclerView.addItemDecoration(new SimpleDividerItemDecoration(getContext(), getResources(), SimpleDividerItemDecoration.PAGE_LABELS));
        loadingView = child.findViewById(R.id.loading_view);
        faqTitle.setVisibility(GONE);
    }


    public void setCategories(ArrayList<NRFAQGroupItem> categories, NRCustomViewAdapter viewAdapter, Listener listener)  {
        adapter = new NRCategoriesAdapter();

        ((NRCategoriesAdapter)adapter).setTitleItemLabelView(labelItemTitleView);
        ((NRCategoriesAdapter)adapter).setListener(listener);
        ((NRCategoriesAdapter)adapter).setViewAdapter(viewAdapter);
        ((NRCategoriesAdapter)adapter).addItems(categories);
        mResultsRecyclerView.addItemDecoration(new SimpleDividerItemDecoration(getContext(), getResources(), SimpleDividerItemDecoration.PAGE_LABELS));

        mResultsRecyclerView.setAdapter(adapter);
    }

    public void initLabelsAdapter(@NonNull List<NRLabel> labels, NRLabelsAdapter.NRLabelsListener listener) {
        adapter = new NRLabelsAdapter(listener, labelItemTitleView, labels);
        mResultsRecyclerView.setAdapter(adapter);
    }
}
