package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRResult;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.model.ResultResponse;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.adapters.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.SearchFetcherListener;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

import static android.view.View.GONE;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.noSuggestions;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.noSuggestionsInCache;
import static com.nanorep.nanoclient.Handlers.NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE;

public class NRMainFragment extends Fragment implements
        NRSearchBarListener,
        NRLabelsAdapter.NRLabelsListener,
        NRSuggestionsListener,
        NRCategoriesView.Listener,
        NRErrorHandler.Listener, NanorepUI.FaqsListener {

    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private ProgressBar mLoadingView;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private FragmentManager fragmentManager;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private NRCategoriesView categoriesView;

    private boolean resetSuggestions = false;
    private String previousQueryText;
    private ArrayList<Spannable> previousSuggestions;

    private boolean autocompleteEnabled = true;

    // no connection
    private LinearLayout noConnectionView;

    private AccountParams accountParams;

    private NRLabel currentLabel;
    private boolean fragmentPaused;
    private long previousClickTime;
    private boolean killedBySystem;
    private ViewGroup container;
    private Context context;
    private boolean clearUIInstance;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    public static NRMainFragment newInstance(String context) {
        return new NRMainFragment();
    }

    /***
     * provide the views provider by the search injector
     * @param injector  - If equals to null, a default views provider would be created
     * @return
     */
    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();

        fragment.viewsProvider = injector.getUiProvider();

        return fragment;
    }

    public static NRMainFragment newInstance() {

        Bundle args = new Bundle();

        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private void initDataManager() {
        
        SearchFetcherListener fetcherListener = new SearchFetcherListener() {

            @Override
            public void reloadWithAnimation() {}

            @Override
            public void reload() {}

            @Override
            public void insertRows(final List<ResultResponse> results, final String searchContext) {
                if (isDetached() || context == null) {
                    return;
                }

                clearSuggestionsView();

                NanorepUI.getInstance().updateDynamicContextValue(searchContext);

                if (results == null || (results.size() == 1 && ((NRResult) results.get(0)).getFetchedResult() == null)) {
                    if (searchBarView.getSearchQuery() != null) {
                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    NRResult result;

                    if (results == null) {
                        Map<String, Object> params = new HashMap<>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = (NRResult)results.get(0);
                    }

                    openArticleFragment(result, ArticleFragment.TAG);

                } else if (results.size() == 1) {
                    final NRResult currentResult = (NRResult)results.get(0);
                    if (currentResult != null) {
                        final NRQueryResult fetchedResult = currentResult.getFetchedResult();
                        if (fetchedResult != null) {

                            NRResult result = (NRResult)results.get(0);

                            result.setSingle(true);
                            openArticleFragment(result, fetchedResult.getId());
                        }
                    }

                } else if (results.size() > 1) {
                    openResultsFragment(results, null, true);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (searchBarView != null && searchBarView.getSearchQuery() != null && !searchBarView.getSearchQuery().isEmpty() && !resetSuggestions && searchBarView.getSearchQuery().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);
                    mSuggestionViewContainer.setVisibility(View.VISIBLE);
                    Nanorep.getInstance().onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, CONNECTION, getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                NanorepUI.getInstance().updateDynamicContextValue(null);

                if (categoriesView != null){
                    categoriesView.enableAdapterClicks(true);
                }
                resetSuggestions = true;
                clearSuggestionsView();
            }
        };

        NanorepUI.getInstance().setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener() {
            @Override
            public void onError(NRError error) {
                mLoadingView.setVisibility(GONE);

                if (error != null) {

                    switch (error.getCode()) {
                        case CONNECTION:
                            if (context != null) {
                                NRErrorView errorView = new NRErrorView(context);
                                errorView.setListener(new NRErrorView.Listener() {
                                    @Override
                                    public void tryAgain() {
                                        mFetchedDataManager.fetchConfiguration();
                                        mLoadingView.setVisibility(View.VISIBLE);
                                    }
                                });

                                contentMain.addView(errorView);
                            }
                            break;

                        case noSuggestions:
                        case noSuggestionsInCache:
                            clearSuggestionsView();
                    }
                }
            }
        });

        mFetchedDataManager = NanorepUI.getInstance().getDataManager(fetcherListener);

       if (previousSuggestions != null && previousQueryText != null) {
           previousQueryText = Nanorep.getInstance().getPreviousQueryText();
           previousSuggestions = Nanorep.getInstance().getPreviousSuggestions();
           fetcherListener.presentSuggestion(previousQueryText, previousSuggestions);
       }
    }

    @Override
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation anim = null;

        if (nextAnim != 0) {
            anim = AnimationUtils.loadAnimation(getActivity(), nextAnim);

            anim.setAnimationListener(new Animation.AnimationListener() {

                @Override
                public void onAnimationStart(Animation animation) {
                    NanorepUI.getInstance().hideKeyboard(contentMain);
                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                }

                @Override
                public void onAnimationEnd(Animation animation) {
                }
            });
        }

        return anim;
    }

    private void openArticleFragment(NRResult result, String tag) {

        clearUIInstance = false;

        setLoadingState(true);
        mLoadingView.setVisibility(View.VISIBLE);

        Nanorep.getInstance().clearSuggestionsData();

//        int container = ((View) getView().getParent()).getId();

        NanorepUI.getInstance().addToArticleStuck(result);

        if (fragmentManager != null && container != null) {
            fragmentManager
                    .beginTransaction()
                    .setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right)
                    .replace(container.getId(), ArticleFragment.newInstance(result, 0, NanorepUI.getInstance().getSearchContextValue(), false), tag)
                    .addToBackStack(null)
                    .commitAllowingStateLoss();
        }
    }

    private void openResultsFragment(List<ResultResponse> results, String title, boolean animateAndAddToBackStack) {

        clearUIInstance = false;

        if (results.isEmpty()) {
            NanorepUI.getInstance().updateDynamicContextValue(null);
        }

        NanorepUI.getInstance().setResults(results);

        setLoadingState(true);

        if (fragmentManager != null) {
            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();

            if (animateAndAddToBackStack && this.container != null) {
                fragmentTransaction.addToBackStack(null);
                fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
            }

            if (container != null) {
                fragmentTransaction.replace(container.getId(), ResultsFragment.newInstance(viewsProvider, results, title), ResultsFragment.TAG);
                fragmentTransaction.commitAllowingStateLoss();
            }
        }
    }

    private void openResultsFragment(boolean animateAndAddToBackStack, NRLabel label) {

        clearUIInstance = false;

        NanorepUI.getInstance().updateDynamicContextValue(null);

        if (searchBarView != null) {
            searchBarView.clearText();
        }

        setLoadingState(true);

        if (fragmentManager != null) {

            FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();

            if (animateAndAddToBackStack) {
                fragmentTransaction.addToBackStack(null);
                fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
            }

            if (container != null) {
                fragmentTransaction.replace(container.getId(), ResultsFragment.newInstance(new SearchInjector() {
                    @Override
                    public SearchViewsProvider getUiProvider() {
                        return viewsProvider;
                    }
                }, label), ResultsFragment.TAG);
                fragmentTransaction.commitAllowingStateLoss();
            }
        }
    }

    private void openListView() {

       NanorepUI.getInstance().prepareDataSource(new NanorepUI.DataListener() {
            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {

                View view = getView();

                if (view != null) {

                    if (Nanorep.getInstance().getAccountParams().isLabelsMode()) {

                        contentMain = view.findViewById(R.id.categories_content_main);

                        contentMain.requestFocus();
                        mLoadingView = contentMain.findViewById(R.id.categories_loadingView);
                        noConnectionView = view.findViewById(R.id.categories_noConnectionView);
                        mLoadingView.setVisibility(GONE);

                        setViews(view);
/*
                        View childView = contentMain.getChildAt(contentMain.getChildCount() - 1);
                        if (childView instanceof NRErrorView) {
                            contentMain.removeView(childView);
                        }*/

                        if (viewsProvider != null) {

                            categoriesView = new NRCategoriesView(getActivity(), viewsProvider.getResultsViewLayout());

                            categoriesView.setLabelItemTitleView(viewsProvider.getLabelItemLayout());

                            if (accountParams.isLabelsMode() && Nanorep.getInstance().getNRConfiguration().getLabels() != null && Nanorep.getInstance().getNRConfiguration().getLabels().size() > 0) {
                                categoriesView.initLabelsAdapter(Nanorep.getInstance().getNRConfiguration().getLabels(), NRMainFragment.this);
                            } else if (groups != null && groups.get(0).getGroupId() != 0) {
                                categoriesView.setCategories(groups, viewAdapter, NRMainFragment.this);
                            } else if (accountParams.isLabelsMode()) {
                                Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, 6, getString(R.string.failed_load_labels_error)));
                            }

                            setLoadingState(false);
                            contentMain.addView(categoriesView);
                        }
                        clearSuggestionsView();
                    }
                }
            }

            @Override
            public void onError(NRError error) {
                Nanorep.getInstance().getWidgetListener().onError(error);
            }
        });
    }

    @Override
    public void onStart() {
        super.onStart();
        clearUIInstance = true;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.container = container;
        return inflater.inflate(R.layout.fragment_categories, container, false);
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        context = getContext();

        NanorepUI.getInstance().setContext(context);
        NanorepUI.getInstance().setResults(null);

        accountParams = Nanorep.getInstance().getAccountParams();
        fragmentManager = getFragmentManager();

        if (viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider(viewsProvider);
        } else {
            if (Nanorep.getInstance().getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) Nanorep.getInstance().getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        NRErrorHandler.getInstance().setListener(this);

        initDataManager();

        openListView();
    }

    @Override
    public void onClearSearchText() {

        NanorepUI.getInstance().clearAllContexts();

        resetSuggestions = true;

        clearSuggestionsView();

        if (categoriesView != null) {
            categoriesView.enableAdapterClicks(true);
        }

        setLoadingState(false);
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        searchBarView.setViewsProvider(viewsProvider);

        String titleBGColor;

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        } else {
            titleBGColor = "#0aa0ff";
        }

        searchBarContainer.setBackgroundColor(Color.parseColor(titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }

            View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

            actionBar.setCustomView(customActionBar, layout);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);

            Toolbar parent = (Toolbar) customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
            parent.setContentInsetsAbsolute(0, 0);

            TextView actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


            // titleConfig text
            String titleText = Nanorep.getInstance().getNRConfiguration().getTitleText();
            setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

            // titleConfig color
            if (!isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor(titleColor));
            }

            // titleConfig background color
            if (!isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
            }

            // titleConfig font
            if (!isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = accountParams.getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }


    private void setViews(View nanoView) {

        dismissConnectionError();

        Context context = nanoView.getContext();

        mLoadingView.setVisibility(GONE);

        if (context != null && viewAdapter != null) {

            // suggestion view
            mSuggestionViewContainer = nanoView.findViewById(R.id.categories_suggestion_view_container);

            mSuggestionsView = viewAdapter.getSuggestionsView(context);

            if (mSuggestionsView == null) {
                mSuggestionsView = new NRSuggestionsView(context);
            }

            mSuggestionsView.setListener(this);

            if (mSuggestionsView.getParent() != null) {
                ((LinearLayout) mSuggestionsView.getParent()).removeView(mSuggestionsView);
            }

            mSuggestionViewContainer.addView(mSuggestionsView);

            // search bar
            searchBarContainer = nanoView.findViewById(R.id.categories_search_bar_container);


            searchBarView = viewAdapter.getSearchBar(context);

            if (searchBarView == null && viewsProvider != null) {
                searchBarView = new NRSearchBar(context, viewsProvider.getSearchBarLayout());
            }

            searchBarView.setListener(this);

            if (searchBarView.getParent() != null) {
                ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
            }

            searchBarView.presentSuggestions(false);

            searchBarContainer.addView(searchBarView, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        }
        updateTitleNormalText();
        updateSearchBar();
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        NanorepUI.getInstance().hideKeyboard(container);
        categoriesView.enableAdapterClicks(false);
        resetSuggestions = true;
        clearSuggestionsView();
        mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        if (fragmentManager != null) {
            fragmentManager.popBackStack();
        }
    }

    @Override
    public void onEmptyQuery() {

    }

    @Override
    public void onSuggestionSelected(String suggestion) {

        NanorepUI.getInstance().hideKeyboard(container);
        if (categoriesView != null) {
            categoriesView.enableAdapterClicks(false);
        }
        resetSuggestions = true;
        searchBarView.updateText(suggestion, false);
        mFetchedDataManager.searchText(suggestion);
        clearSuggestionsView();
    }

    private void enableSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    private void requestFocus() {
        View view = getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (localCurrentView instanceof NRArticleView) {
            updateSearchBarTextForResultTop(localCurrentView);
        } else {

            if (! (localCurrentView != null && contentMain.getChildAt(contentMain.getChildCount() - 1) instanceof NRResultsView)) {
                searchBarView.updateText("", false);
            }

            String title = Nanorep.getInstance().getNRConfiguration().getTitleText();

            categoriesView.enableAdapterClicks(true);

            setActionBarTitleText(currentLabel == null ? title : currentLabel.getTitle());
        }

        requestFocus();

        setLoadingState(false);

        if (localCurrentView != null) {
            localCurrentView.setVisibility(View.VISIBLE);
        }
    }

    private void updateSearchBarTextForResultTop(View view) {

        NRArticleView articleView = (NRArticleView) view;

        if (articleView != null) {
            NRResult result = articleView.getResult();
            if (result != null && result.getFetchedResult() instanceof NRAnswer) {
                searchBarView.updateText(result.getFetchedResult().getTitle(), true);
                resetSuggestions = true;
                clearSuggestionsView();
                requestFocus();
            }
        }
    }

    private void clearSuggestionsView() {
        if (mSuggestionsView != null) {
            mSuggestionsView.setSuggestions(null);
        }

        if (mSuggestionViewContainer != null) {
            mSuggestionViewContainer.setVisibility(GONE);
        }
    }

    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                if (categoriesView != null) {
                    categoriesView.enableAdapterClicks(true);
                }
                setLoadingState(true);
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                    NanorepUI.getInstance().hideKeyboard(getView());
                }

                break;
        }

    }

    @Override
    public void dismissConnectionError() {
        setLoadingState(false);

        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(GONE);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);

        NanorepUI.getInstance().setLabel(label);

        if (label.getContext().isEmpty()) {
            openResultsFragment(true, label);
        } else {
            Nanorep.getInstance().setContext(label.getContext(), new OnDataResponse<DefaultResponse>() {
                @Override
                public void onSuccess(DefaultResponse response) {
//                    NanorepUI.getInstance().updateLabelContext(); it has been done already
                    openResultsFragment(true, label);
                }

                @Override
                public void onError(NRConnectionException error) {
                    showConnectionError(TIMEOUT_UPPER_LINE);
                    Nanorep.getInstance().getWidgetListener().onError(NRError.error(TAG, CONNECTION, error.getMessage()));
                }
            });
        }
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        final long threshold = 300;
        if (currentTime - this.previousClickTime < threshold) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {

        if (isBouncing()) {
            return;
        }

        if (context != null) {
            openResultsFragment(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), context), groupItem.getTitle(), true);
        }
    }


    private void setLoadingState(boolean state) {
        if (categoriesView != null) {
            categoriesView.setLoading(state);
        }
    }

    @Override
    public void onDestroyView() {
        viewsProvider = null;
        clearSuggestionsView();

        if (!killedBySystem) {
            if (fragmentManager != null) {
                for (Fragment fragment : fragmentManager.getFragments()) {
                    String tag = fragment.getTag();
                    if (tag != null && (tag.equals(NRWebContentFragment.TAG) || tag.equals(ResultsFragment.TAG ))) {
                        fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
                    }
                }
            }

            if (clearUIInstance) {
                NanorepUI.getInstance().clearInstance();
            }

            Nanorep.getInstance().clearSuggestionsData();
        }

        super.onDestroyView();
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            fragmentPaused = false;
            NRErrorHandler.getInstance().setListener(this);
        }
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        killedBySystem = true;
    }

    @Override
    public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
        if (context != null) {
            openResultsFragment(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), context), groups.get(0).getTitle(), true);
        }
    }
}