/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.model.NRResult;
import com.nanorep.nanoclient.model.ResultResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.FAQDataSource;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.SearchFetcherListener;
import nanorep.nanowidget.Fragments.ArticleFragment;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

public class ResultsFragment
extends Fragment
implements NRSearchBarListener,
NRSuggestionsListener,
NRResultsView.Listener,
NRErrorHandler.Listener {
    public static final String TAG = ResultsFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private ProgressBar mLoadingView;
    private boolean resetSuggestions = false;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private FragmentManager fragmentManager;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private List<ResultResponse> results;
    private String title;
    private boolean autocompleteEnabled = true;
    private LinearLayout noConnectionView;
    private boolean fragmentPaused;
    private NRResultsView resultsView;
    private boolean killedBySystem;
    private NRLabel label;
    private ViewGroup container;
    private boolean clearUIInstance;
    private FAQDataSource faqDataSource;
    @Nullable
    private String labelId;

    public static ResultsFragment newInstance(@Nullable String labelId, FAQDataSource faqDataSource, SearchViewsProvider viewsProvider) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.faqDataSource = faqDataSource;
        fragment.labelId = labelId;
        fragment.viewsProvider = viewsProvider;
        return fragment;
    }

    public static ResultsFragment newInstance(SearchViewsProvider viewsProvider, List<ResultResponse> results, String title) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.viewsProvider = viewsProvider;
        fragment.results = results;
        fragment.title = title;
        return fragment;
    }

    public static ResultsFragment newInstance(SearchInjector searchInjector, NRLabel label) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.viewsProvider = searchInjector.getUiProvider();
        fragment.label = label;
        return fragment;
    }

    public static ResultsFragment newInstance(SearchInjector searchInjector) {
        ResultsFragment fragment = new ResultsFragment();
        fragment.viewsProvider = searchInjector.getUiProvider();
        fragment.label = null;
        return fragment;
    }

    public static ResultsFragment newInstance() {
        ResultsFragment fragment = new ResultsFragment();
        fragment.label = null;
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    private void initDataManager() {
        SearchFetcherListener fetcherListener = new SearchFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<ResultResponse> results, String searchContext) {
                if (ResultsFragment.this.isDetached() || ResultsFragment.this.getContext() == null) {
                    return;
                }
                NanorepUI.getInstance().updateDynamicContextValue(searchContext);
                String tag = null;
                NRResult result = null;
                if (results == null || results.size() == 1 && ((NRResult)results.get(0)).getFetchedResult() == null) {
                    if (ResultsFragment.this.searchBarView.getSearchQuery() != null) {
                        while (ResultsFragment.this.contentMain.getChildCount() > 2) {
                            ResultsFragment.this.contentMain.removeViewAt(ResultsFragment.this.contentMain.getChildCount() - 1);
                        }
                    }
                    if (results == null) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = (NRResult)results.get(0);
                    }
                    tag = ArticleFragment.TAG;
                    ResultsFragment.this.openArticleFragment(result, 0, null, tag, true);
                } else if (results.size() == 1) {
                    NRQueryResult fetchedResult;
                    NRResult currentResult = (NRResult)results.get(0);
                    if (currentResult != null && (fetchedResult = currentResult.getFetchedResult()) != null) {
                        result = (NRResult)results.get(0);
                        result.setSingle(true);
                        tag = result.getFetchedResult().getId();
                        ResultsFragment.this.requestFocus();
                    }
                    ResultsFragment.this.openArticleFragment(result, 0, null, tag, true);
                } else if (results.size() > 1) {
                    NanorepUI.getInstance().setResults(results);
                    ResultsFragment.this.openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (ResultsFragment.this.searchBarView != null && ResultsFragment.this.searchBarView.getSearchQuery() != null && !ResultsFragment.this.searchBarView.getSearchQuery().isEmpty() && !ResultsFragment.this.resetSuggestions && ResultsFragment.this.searchBarView.getSearchQuery().length() - querytext.length() <= 1 && ResultsFragment.this.autocompleteEnabled) {
                    ResultsFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    ResultsFragment.this.mSuggestionViewContainer.setVisibility(0);
                    Nanorep.getInstance().onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)1, (String)ResultsFragment.this.getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                NanorepUI.getInstance().updateDynamicContextValue(null);
                if (ResultsFragment.this.resultsView != null) {
                    ResultsFragment.this.resultsView.enableAdapterClicks(true);
                }
                ResultsFragment.this.resetSuggestions = true;
            }
        };
        NanorepUI.getInstance().setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener(){

            @Override
            public void onError(NRError error) {
                ResultsFragment.this.mLoadingView.setVisibility(8);
                if (error != null) {
                    Context context = ResultsFragment.this.getContext();
                    switch (error.getCode()) {
                        case 1: {
                            if (context == null) break;
                            NRErrorView errorView = new NRErrorView(context);
                            errorView.setListener(new NRErrorView.Listener(){

                                @Override
                                public void tryAgain() {
                                    ResultsFragment.this.mFetchedDataManager.fetchConfiguration();
                                    ResultsFragment.this.mLoadingView.setVisibility(0);
                                }
                            });
                            ResultsFragment.this.contentMain.addView((View)errorView);
                            break;
                        }
                        case 1002: 
                        case 1003: {
                            ResultsFragment.this.clearSuggestionsView();
                        }
                    }
                }
            }
        });
        NanorepUI.getInstance().setContext(this.getContext());
        this.mFetchedDataManager = NanorepUI.getInstance().getDataManager(fetcherListener);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.container = container;
        return inflater.inflate(R.layout.fragment_results, container, false);
    }

    public void onStart() {
        super.onStart();
        this.clearUIInstance = true;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (NanorepUI.getInstance().getLabel() != null) {
            this.label = NanorepUI.getInstance().getLabel();
        } else {
            NanorepUI.getInstance().setLabel(this.label);
        }
        if (savedInstanceState != null) {
            Gson gson = new Gson();
            this.label = (NRLabel)gson.fromJson(savedInstanceState.getString("label"), NRLabel.class);
            String restoredLabelId = savedInstanceState.getString("labelId");
            if (restoredLabelId != null) {
                this.labelId = restoredLabelId;
            }
            NanorepUI.getInstance().setLabel(this.label);
        }
        this.killedBySystem = false;
        this.widgetListener = Nanorep.getInstance().getWidgetListener();
        this.fragmentManager = this.getFragmentManager();
        if (this.viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = Nanorep.getInstance().getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)Nanorep.getInstance().getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        this.initDataManager();
        this.contentMain = (FrameLayout)view.findViewById(R.id.results_content_main);
        this.mLoadingView = (ProgressBar)this.contentMain.findViewById(R.id.results_loadingView);
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.results_noConnectionView);
        this.mLoadingView.setVisibility(0);
        this.setViews(view);
        if (NanorepUI.getInstance().getResults() != null) {
            this.results = NanorepUI.getInstance().getResults();
        }
        this.label = NanorepUI.getInstance().getLabel();
        if (this.results == null || this.results.isEmpty()) {
            if (Nanorep.getInstance().getAccountParams().isSupportCenterMode() && this.faqDataSource != null) {
                this.fetchSupportCenter();
            } else {
                this.fetchResultsForLabel();
            }
        } else {
            this.openNRResultView(this.results, this.title);
        }
    }

    private void fetchSupportCenter() {
        this.results = new ArrayList<ResultResponse>();
        this.openNRResultView(this.results, "");
        this.resultsView.setAnimated(false);
        this.faqDataSource.setLabel(this.labelId, (Function1<? super List<? extends ResultResponse>, Unit>)new Function1<List<? extends ResultResponse>, Unit>(){

            public Unit invoke(List<? extends ResultResponse> resultResponses) {
                ArrayList<ResultResponse> resultResponse = new ArrayList<ResultResponse>(resultResponses);
                ResultsFragment.this.resultsView.updateList(resultResponse);
                return null;
            }
        }, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>(){

            public Unit invoke(Integer integer) {
                ResultsFragment.this.resultsView.notifyItemChanged(integer);
                return null;
            }
        });
    }

    private void fetchResultsForLabel() {
        if (this.label == null) {
            this.label = new NRLabel();
        }
        NanorepUI.getInstance().getDataManager().fetchLabelFAQ(this.label, new NanorepUI.FaqsListener(){

            @Override
            public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
                Context context = ResultsFragment.this.getContext();
                if (groups != null) {
                    if (context != null) {
                        ResultsFragment.this.openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), context), groups.get(0).getTitle());
                    } else if (ResultsFragment.this.widgetListener != null) {
                        Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)2, (String)"the context is null"));
                    }
                } else {
                    ResultsFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    ResultsFragment.this.mLoadingView.setVisibility(0);
                }
            }
        });
    }

    private void enableSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    @Override
    public void onClearSearchText() {
        NanorepUI.getInstance().updateDynamicContextValue(null);
        this.fetchResultsForLabel();
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        if (this.resultsView != null) {
            this.resultsView.enableAdapterClicks(true);
        }
        this.setLoadingState(false);
    }

    private void clearSuggestionsView() {
        if (this.mSuggestionsView != null) {
            this.mSuggestionsView.setSuggestions(null);
        }
        if (this.mSuggestionViewContainer != null) {
            this.mSuggestionViewContainer.setVisibility(8);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        String titleBGColor = !ResultsFragment.isEmpty(titleConfig.getTitleBGColor()) ? titleConfig.getTitleBGColor() : "#0aa0ff";
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
        if (this.viewsProvider != null && this.label != null && !this.viewsProvider.isSearchBarAlwaysOnTop()) {
            this.searchBarView.adaptSearchBarDisplay(true, this.label.getTitle(), false);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        Context context = nanoView.getContext();
        if (context != null && this.viewAdapter != null) {
            this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.results_suggestion_view_container);
            this.mSuggestionsView = this.viewAdapter.getSuggestionsView(context);
            if (this.mSuggestionsView == null) {
                this.mSuggestionsView = new NRSuggestionsView(context);
            }
            this.mSuggestionsView.setListener(this);
            this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
            this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.results_search_bar_container);
            this.searchBarView = this.viewAdapter.getSearchBar(context);
            if (this.searchBarView == null && this.viewsProvider != null) {
                this.searchBarView = new NRSearchBar(context, this.viewsProvider.getSearchBarLayout());
            }
            this.searchBarView.setListener(this);
            if (this.searchBarView.getParent() != null) {
                ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
            }
            this.searchBarView.presentSuggestions(false);
            this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
            this.updateTitleNormalText();
            this.updateSearchBar();
        }
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        NanorepUI.getInstance().hideKeyboard((View)this.container);
        if (this.resultsView != null) {
            this.resultsView.enableAdapterClicks(false);
        }
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        this.clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }

    @Override
    public void onEmptyQuery() {
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation anim2 = null;
        if (nextAnim != 0) {
            anim2 = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)nextAnim);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    NanorepUI.getInstance().hideKeyboard((View)ResultsFragment.this.contentMain);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                }
            });
        }
        return anim2;
    }

    @Override
    public void onSuggestionSelected(String suggestion) {
        NanorepUI.getInstance().hideKeyboard((View)this.container);
        this.resultsView.enableAdapterClicks(false);
        this.resetSuggestions = true;
        this.searchBarView.updateText(suggestion, false);
        this.mFetchedDataManager.searchText(suggestion);
        this.clearSuggestionsView();
    }

    @Override
    public void onResultSelected(int y, ResultResponse result) {
        this.resetSuggestions = true;
        if (result != null) {
            if (result.getResponseType() == 1) {
                NRResult nrResult = (NRResult)result;
                String tag = nrResult.getFetchedResult() != null ? nrResult.getFetchedResult().getId() : ArticleFragment.TAG;
                this.openArticleFragment(nrResult, y, null, tag, false);
            } else {
                this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).replace(this.container.getId(), (Fragment)ResultsFragment.newInstance(result.getResponseId(), this.faqDataSource, this.viewsProvider)).addToBackStack(null).commitAllowingStateLoss();
            }
        }
    }

    private void openArticleFragment(NRResult result, int y, String searchContext, String tag, boolean clearSearchText) {
        this.clearUIInstance = false;
        if (this.searchBarView != null && clearSearchText) {
            this.searchBarView.clearText();
        }
        View view = this.getView();
        Nanorep.getInstance().clearSuggestionsData();
        if (view != null) {
            this.mLoadingView.setVisibility(0);
            this.setLoadingState(true);
            NanorepUI.getInstance().addToArticleStuck(result);
            if (this.fragmentManager != null && this.container != null) {
                this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).replace(this.container.getId(), ArticleFragment.newInstance(result, y, searchContext, false), tag).addToBackStack(null).commitAllowingStateLoss();
            }
        }
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view;
                if (this.resultsView != null) {
                    this.resultsView.enableAdapterClicks(true);
                    this.setLoadingState(true);
                }
                if ((view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1)) instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                NanorepUI.getInstance().hideKeyboard(this.getView());
            }
        }
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            TextView actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = Nanorep.getInstance().getNRConfiguration().getTitleText();
            this.setActionBarTitleText(titleText);
            if (!ResultsFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!ResultsFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!ResultsFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = Nanorep.getInstance().getAccountParams().getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public void dismissConnectionError() {
    }

    private void openNRResultView(List<ResultResponse> results, String title) {
        try {
            NanorepUI.getInstance().setResults(results);
            View fragmentView = this.getView();
            if (fragmentView != null && this.viewsProvider != null) {
                this.dismissConnectionError();
                this.resultsView = new NRResultsView((Context)this.getActivity());
                this.resultsView.setListener(this);
                int faqLayout = this.viewsProvider.getFaqItemLayout();
                int labelLayout = this.viewsProvider.getLabelItemLayout();
                this.resultsView.setResults(results, title, this.viewAdapter, faqLayout, labelLayout);
                this.resultsView.setIsAnimated(true);
                this.resultsView.enableAdapterClicks(true);
                this.contentMain.requestFocus();
                this.requestFocus();
                this.setLoadingState(false);
                this.mLoadingView.setVisibility(8);
                this.contentMain.addView((View)this.resultsView);
                String queryText = Nanorep.getInstance().getPreviousQueryText();
                ArrayList suggestions = Nanorep.getInstance().getPreviousSuggestions();
                if (queryText != null && suggestions != null) {
                    NanorepUI.getInstance().getDataManager().getFetcherListener().presentSuggestion(queryText, suggestions);
                }
            }
            this.enableSuggestionsView();
            this.clearSuggestionsView();
        }
        catch (Exception e) {
            Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)4, (String)this.getString(R.string.results_view_error)));
        }
    }

    private void setLoadingState(boolean state) {
        this.resultsView.setLoading(state);
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.viewsProvider = null;
        this.widgetListener = null;
        this.clearSuggestionsView();
        if (!this.killedBySystem) {
            if (this.fragmentManager != null) {
                for (Fragment fragment : this.fragmentManager.getFragments()) {
                    String tag = fragment.getTag();
                    if (tag == null || !tag.equals(NRWebContentFragment.TAG)) continue;
                    this.fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
                }
            }
            if (this.clearUIInstance) {
                NanorepUI.getInstance().setResults(null);
                Nanorep.getInstance().clearSuggestionsData();
                NanorepUI.getInstance().clearCurrentLabel();
                NanorepUI.getInstance().clearInstance();
            }
        }
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
        }
        if (this.resultsView != null) {
            this.resultsView.enableAdapterClicks(true);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.killedBySystem = true;
        Gson gson = new Gson();
        outState.putString("labelId", this.labelId);
        outState.putString("label", gson.toJson((Object)NanorepUI.getInstance().getLabel()));
    }
}

