/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.model.NRResult;
import com.nanorep.nanoclient.model.ResultResponse;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.SearchFetcherListener;
import nanorep.nanowidget.Fragments.ArticleFragment;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.Fragments.ResultsFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.adapters.NRLabelsAdapter;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;

public class NRMainFragment
extends Fragment
implements NRSearchBarListener,
NRLabelsAdapter.NRLabelsListener,
NRSuggestionsListener,
NRCategoriesView.Listener,
NRErrorHandler.Listener,
NanorepUI.FaqsListener {
    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;
    private NRFetchedDataManager mFetchedDataManager;
    private NRCustomViewAdapter viewAdapter;
    private ProgressBar mLoadingView;
    private SearchViewsProvider viewsProvider;
    private FrameLayout contentMain;
    private FragmentManager fragmentManager;
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;
    private NRCategoriesView categoriesView;
    private boolean resetSuggestions = false;
    private String previousQueryText;
    private ArrayList<Spannable> previousSuggestions;
    private boolean autocompleteEnabled = true;
    private LinearLayout noConnectionView;
    private AccountParams accountParams;
    private NRLabel currentLabel;
    private boolean fragmentPaused;
    private long previousClickTime;
    private boolean killedBySystem;
    private ViewGroup container;
    private Context context;
    private boolean clearUIInstance;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof NRCustomViewAdapter) {
            this.viewAdapter = (NRCustomViewAdapter)context;
        }
    }

    public static NRMainFragment newInstance(String context) {
        return new NRMainFragment();
    }

    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();
        fragment.viewsProvider = injector.getUiProvider();
        return fragment;
    }

    public static NRMainFragment newInstance() {
        Bundle args = new Bundle();
        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    private void initDataManager() {
        SearchFetcherListener fetcherListener = new SearchFetcherListener(){

            @Override
            public void reloadWithAnimation() {
            }

            @Override
            public void reload() {
            }

            @Override
            public void insertRows(List<ResultResponse> results, String searchContext) {
                if (NRMainFragment.this.isDetached() || NRMainFragment.this.context == null) {
                    return;
                }
                NRMainFragment.this.clearSuggestionsView();
                NanorepUI.getInstance().updateDynamicContextValue(searchContext);
                if (results == null || results.size() == 1 && ((NRResult)results.get(0)).getFetchedResult() == null) {
                    NRResult result;
                    if (NRMainFragment.this.searchBarView.getSearchQuery() != null) {
                        while (NRMainFragment.this.contentMain.getChildCount() > 2) {
                            NRMainFragment.this.contentMain.removeViewAt(NRMainFragment.this.contentMain.getChildCount() - 1);
                        }
                    }
                    if (results == null) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = (NRResult)results.get(0);
                    }
                    NRMainFragment.this.openArticleFragment(result, ArticleFragment.TAG);
                } else if (results.size() == 1) {
                    NRQueryResult fetchedResult;
                    NRResult currentResult = (NRResult)results.get(0);
                    if (currentResult != null && (fetchedResult = currentResult.getFetchedResult()) != null) {
                        NRResult result = (NRResult)results.get(0);
                        result.setSingle(true);
                        NRMainFragment.this.openArticleFragment(result, fetchedResult.getId());
                    }
                } else if (results.size() > 1) {
                    NRMainFragment.this.openResultsFragment(results, null, true);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (NRMainFragment.this.searchBarView != null && NRMainFragment.this.searchBarView.getSearchQuery() != null && !NRMainFragment.this.searchBarView.getSearchQuery().isEmpty() && !NRMainFragment.this.resetSuggestions && NRMainFragment.this.searchBarView.getSearchQuery().length() - querytext.length() <= 1 && NRMainFragment.this.autocompleteEnabled) {
                    NRMainFragment.this.mSuggestionsView.setSuggestions(suggestions);
                    NRMainFragment.this.mSuggestionViewContainer.setVisibility(0);
                    Nanorep.getInstance().onSuggestionsPresented(suggestions, querytext);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {
                Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)1, (String)NRMainFragment.this.getString(R.string.connection_error_message)));
            }

            @Override
            public void onContextDialogCanceled() {
                NanorepUI.getInstance().updateDynamicContextValue(null);
                if (NRMainFragment.this.categoriesView != null) {
                    NRMainFragment.this.categoriesView.enableAdapterClicks(true);
                }
                NRMainFragment.this.resetSuggestions = true;
                NRMainFragment.this.clearSuggestionsView();
            }
        };
        NanorepUI.getInstance().setDataManagerErrorListener(new NanorepUI.DataManagerErrorListener(){

            @Override
            public void onError(NRError error) {
                NRMainFragment.this.mLoadingView.setVisibility(8);
                if (error != null) {
                    switch (error.getCode()) {
                        case 1: {
                            if (NRMainFragment.this.context == null) break;
                            NRErrorView errorView = new NRErrorView(NRMainFragment.this.context);
                            errorView.setListener(new NRErrorView.Listener(){

                                @Override
                                public void tryAgain() {
                                    NRMainFragment.this.mFetchedDataManager.fetchConfiguration();
                                    NRMainFragment.this.mLoadingView.setVisibility(0);
                                }
                            });
                            NRMainFragment.this.contentMain.addView((View)errorView);
                            break;
                        }
                        case 1002: 
                        case 1003: {
                            NRMainFragment.this.clearSuggestionsView();
                        }
                    }
                }
            }
        });
        this.mFetchedDataManager = NanorepUI.getInstance().getDataManager(fetcherListener);
        if (this.previousSuggestions != null && this.previousQueryText != null) {
            this.previousQueryText = Nanorep.getInstance().getPreviousQueryText();
            this.previousSuggestions = Nanorep.getInstance().getPreviousSuggestions();
            fetcherListener.presentSuggestion(this.previousQueryText, this.previousSuggestions);
        }
    }

    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        Animation anim2 = null;
        if (nextAnim != 0) {
            anim2 = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)nextAnim);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    NanorepUI.getInstance().hideKeyboard((View)NRMainFragment.this.contentMain);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                }
            });
        }
        return anim2;
    }

    private void openArticleFragment(NRResult result, String tag) {
        this.clearUIInstance = false;
        this.setLoadingState(true);
        this.mLoadingView.setVisibility(0);
        Nanorep.getInstance().clearSuggestionsData();
        NanorepUI.getInstance().addToArticleStuck(result);
        if (this.fragmentManager != null && this.container != null) {
            this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right).replace(this.container.getId(), ArticleFragment.newInstance(result, 0, NanorepUI.getInstance().getSearchContextValue(), false), tag).addToBackStack(null).commitAllowingStateLoss();
        }
    }

    private void openResultsFragment(List<ResultResponse> results, String title, boolean animateAndAddToBackStack) {
        this.clearUIInstance = false;
        if (results.isEmpty()) {
            NanorepUI.getInstance().updateDynamicContextValue(null);
        }
        NanorepUI.getInstance().setResults(results);
        this.setLoadingState(true);
        if (this.fragmentManager != null) {
            FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
            if (animateAndAddToBackStack && this.container != null) {
                fragmentTransaction.addToBackStack(null);
                fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
            }
            if (this.container != null) {
                fragmentTransaction.replace(this.container.getId(), (Fragment)ResultsFragment.newInstance(this.viewsProvider, results, title), ResultsFragment.TAG);
                fragmentTransaction.commitAllowingStateLoss();
            }
        }
    }

    private void openResultsFragment(boolean animateAndAddToBackStack, NRLabel label) {
        this.clearUIInstance = false;
        NanorepUI.getInstance().updateDynamicContextValue(null);
        if (this.searchBarView != null) {
            this.searchBarView.clearText();
        }
        this.setLoadingState(true);
        if (this.fragmentManager != null) {
            FragmentTransaction fragmentTransaction = this.fragmentManager.beginTransaction();
            if (animateAndAddToBackStack) {
                fragmentTransaction.addToBackStack(null);
                fragmentTransaction.setCustomAnimations(R.anim.slide_from_right, R.anim.slide_to_left, R.anim.slide_from_left, R.anim.slide_to_right);
            }
            if (this.container != null) {
                fragmentTransaction.replace(this.container.getId(), (Fragment)ResultsFragment.newInstance(new SearchInjector(){

                    @Override
                    public SearchViewsProvider getUiProvider() {
                        return NRMainFragment.this.viewsProvider;
                    }
                }, label), ResultsFragment.TAG);
                fragmentTransaction.commitAllowingStateLoss();
            }
        }
    }

    private void openListView() {
        NanorepUI.getInstance().prepareDataSource(new NanorepUI.DataListener(){

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                View view = NRMainFragment.this.getView();
                if (view != null && Nanorep.getInstance().getAccountParams().isLabelsMode()) {
                    NRMainFragment.this.contentMain = (FrameLayout)view.findViewById(R.id.categories_content_main);
                    NRMainFragment.this.contentMain.requestFocus();
                    NRMainFragment.this.mLoadingView = (ProgressBar)NRMainFragment.this.contentMain.findViewById(R.id.categories_loadingView);
                    NRMainFragment.this.noConnectionView = (LinearLayout)view.findViewById(R.id.categories_noConnectionView);
                    NRMainFragment.this.mLoadingView.setVisibility(8);
                    NRMainFragment.this.setViews(view);
                    if (NRMainFragment.this.viewsProvider != null) {
                        NRMainFragment.this.categoriesView = new NRCategoriesView((Context)NRMainFragment.this.getActivity(), NRMainFragment.this.viewsProvider.getResultsViewLayout());
                        NRMainFragment.this.categoriesView.setLabelItemTitleView(NRMainFragment.this.viewsProvider.getLabelItemLayout());
                        if (NRMainFragment.this.accountParams.isLabelsMode() && Nanorep.getInstance().getNRConfiguration().getLabels() != null && Nanorep.getInstance().getNRConfiguration().getLabels().size() > 0) {
                            NRMainFragment.this.categoriesView.initLabelsAdapter(Nanorep.getInstance().getNRConfiguration().getLabels(), NRMainFragment.this);
                        } else if (groups != null && groups.get(0).getGroupId() != 0) {
                            NRMainFragment.this.categoriesView.setCategories(groups, NRMainFragment.this.viewAdapter, NRMainFragment.this);
                        } else if (NRMainFragment.this.accountParams.isLabelsMode()) {
                            Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)6, (String)NRMainFragment.this.getString(R.string.failed_load_labels_error)));
                        }
                        NRMainFragment.this.setLoadingState(false);
                        NRMainFragment.this.contentMain.addView((View)NRMainFragment.this.categoriesView);
                    }
                    NRMainFragment.this.clearSuggestionsView();
                }
            }

            @Override
            public void onError(NRError error) {
                Nanorep.getInstance().getWidgetListener().onError(error);
            }
        });
    }

    public void onStart() {
        super.onStart();
        this.clearUIInstance = true;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.container = container;
        return inflater.inflate(R.layout.fragment_categories, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.context = this.getContext();
        NanorepUI.getInstance().setContext(this.context);
        NanorepUI.getInstance().setResults(null);
        this.accountParams = Nanorep.getInstance().getAccountParams();
        this.fragmentManager = this.getFragmentManager();
        if (this.viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = Nanorep.getInstance().getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)Nanorep.getInstance().getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        if (this.viewAdapter == null) {
            this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        }
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        this.initDataManager();
        this.openListView();
    }

    @Override
    public void onClearSearchText() {
        NanorepUI.getInstance().clearAllContexts();
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        if (this.categoriesView != null) {
            this.categoriesView.enableAdapterClicks(true);
        }
        this.setLoadingState(false);
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = Nanorep.getInstance().getNRConfiguration().getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = Nanorep.getInstance().getNRConfiguration().getSearchBar();
        this.searchBarView.setHint(searchBarConfig.getInitialText());
        this.searchBarView.setViewsProvider(this.viewsProvider);
        String titleBGColor = !NRMainFragment.isEmpty(titleConfig.getTitleBGColor()) ? titleConfig.getTitleBGColor() : "#0aa0ff";
        this.searchBarContainer.setBackgroundColor(Color.parseColor((String)titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = Nanorep.getInstance().getNRConfiguration().getTitle();
        if (this.getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            View customActionBar = this.getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout2 = new ActionBar.LayoutParams(-1, -1);
            actionBar.setCustomView(customActionBar, layout2);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);
            Toolbar parent = (Toolbar)customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);
            parent.setContentInsetsAbsolute(0, 0);
            TextView actionBarTextView = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            String titleText = Nanorep.getInstance().getNRConfiguration().getTitleText();
            this.setActionBarTitleText(titleText);
            if (!NRMainFragment.isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor((String)titleColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = (RelativeLayout)actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor((String)titleBGColor));
            }
            if (!NRMainFragment.isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create((String)titleFont, (int)0));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (this.getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity)this.getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }
            String fixedTitle = this.accountParams.getFixedTitle();
            TextView tv = (TextView)actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText((CharSequence)(fixedTitle != null ? fixedTitle : title));
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private void setViews(View nanoView) {
        this.dismissConnectionError();
        Context context = nanoView.getContext();
        this.mLoadingView.setVisibility(8);
        if (context != null && this.viewAdapter != null) {
            this.mSuggestionViewContainer = (LinearLayout)nanoView.findViewById(R.id.categories_suggestion_view_container);
            this.mSuggestionsView = this.viewAdapter.getSuggestionsView(context);
            if (this.mSuggestionsView == null) {
                this.mSuggestionsView = new NRSuggestionsView(context);
            }
            this.mSuggestionsView.setListener(this);
            if (this.mSuggestionsView.getParent() != null) {
                ((LinearLayout)this.mSuggestionsView.getParent()).removeView((View)this.mSuggestionsView);
            }
            this.mSuggestionViewContainer.addView((View)this.mSuggestionsView);
            this.searchBarContainer = (LinearLayout)nanoView.findViewById(R.id.categories_search_bar_container);
            this.searchBarView = this.viewAdapter.getSearchBar(context);
            if (this.searchBarView == null && this.viewsProvider != null) {
                this.searchBarView = new NRSearchBar(context, this.viewsProvider.getSearchBarLayout());
            }
            this.searchBarView.setListener(this);
            if (this.searchBarView.getParent() != null) {
                ((LinearLayout)this.searchBarView.getParent()).removeView((View)this.searchBarView);
            }
            this.searchBarView.presentSuggestions(false);
            this.searchBarContainer.addView((View)this.searchBarView, new ViewGroup.LayoutParams(-1, -1));
        }
        this.updateTitleNormalText();
        this.updateSearchBar();
    }

    @Override
    public void onStartRecording(ImageButton button) {
    }

    @Override
    public void fetchSuggestionsForText(String text) {
        this.resetSuggestions = false;
        this.mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        NanorepUI.getInstance().hideKeyboard((View)this.container);
        this.categoriesView.enableAdapterClicks(false);
        this.resetSuggestions = true;
        this.clearSuggestionsView();
        this.mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        this.clearSuggestionsView();
    }

    @Override
    public void onTopBackButtonPressed() {
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }

    @Override
    public void onEmptyQuery() {
    }

    @Override
    public void onSuggestionSelected(String suggestion) {
        NanorepUI.getInstance().hideKeyboard((View)this.container);
        if (this.categoriesView != null) {
            this.categoriesView.enableAdapterClicks(false);
        }
        this.resetSuggestions = true;
        this.searchBarView.updateText(suggestion, false);
        this.mFetchedDataManager.searchText(suggestion);
        this.clearSuggestionsView();
    }

    private void enableSuggestionsView() {
        if (!Nanorep.getInstance().getNRConfiguration().getAutocompleteEnabled()) {
            this.autocompleteEnabled = false;
        }
    }

    private void requestFocus() {
        View view = this.getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (localCurrentView instanceof NRArticleView) {
            this.updateSearchBarTextForResultTop(localCurrentView);
        } else {
            if (localCurrentView == null || !(this.contentMain.getChildAt(this.contentMain.getChildCount() - 1) instanceof NRResultsView)) {
                this.searchBarView.updateText("", false);
            }
            String title = Nanorep.getInstance().getNRConfiguration().getTitleText();
            this.categoriesView.enableAdapterClicks(true);
            this.setActionBarTitleText(this.currentLabel == null ? title : this.currentLabel.getTitle());
        }
        this.requestFocus();
        this.setLoadingState(false);
        if (localCurrentView != null) {
            localCurrentView.setVisibility(0);
        }
    }

    private void updateSearchBarTextForResultTop(View view) {
        NRResult result;
        NRArticleView articleView = (NRArticleView)view;
        if (articleView != null && (result = articleView.getResult()) != null && result.getFetchedResult() instanceof NRAnswer) {
            this.searchBarView.updateText(result.getFetchedResult().getTitle(), true);
            this.resetSuggestions = true;
            this.clearSuggestionsView();
            this.requestFocus();
        }
    }

    private void clearSuggestionsView() {
        if (this.mSuggestionsView != null) {
            this.mSuggestionsView.setSuggestions(null);
        }
        if (this.mSuggestionViewContainer != null) {
            this.mSuggestionViewContainer.setVisibility(8);
        }
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                if (this.categoriesView != null) {
                    this.categoriesView.enableAdapterClicks(true);
                }
                this.setLoadingState(true);
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
                NanorepUI.getInstance().hideKeyboard(this.getView());
            }
        }
    }

    public void dismissConnectionError() {
        this.setLoadingState(false);
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (this.isBouncing()) {
            return;
        }
        this.setLoadingState(true);
        NanorepUI.getInstance().setLabel(label);
        if (label.getContext().isEmpty()) {
            this.openResultsFragment(true, label);
        } else {
            Nanorep.getInstance().setContext(label.getContext(), (OnDataResponse)new OnDataResponse<DefaultResponse>(){

                public void onSuccess(DefaultResponse response) {
                    NRMainFragment.this.openResultsFragment(true, label);
                }

                public void onError(NRConnectionException error) {
                    NRMainFragment.this.showConnectionError(NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE);
                    Nanorep.getInstance().getWidgetListener().onError(NRError.error((String)TAG, (int)1, (String)error.getMessage()));
                }
            });
        }
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        long threshold = 300L;
        if (currentTime - this.previousClickTime < 300L) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {
        if (this.isBouncing()) {
            return;
        }
        if (this.context != null) {
            this.openResultsFragment(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), this.context), groupItem.getTitle(), true);
        }
    }

    private void setLoadingState(boolean state) {
        if (this.categoriesView != null) {
            this.categoriesView.setLoading(state);
        }
    }

    public void onDestroyView() {
        this.viewsProvider = null;
        this.clearSuggestionsView();
        if (!this.killedBySystem) {
            if (this.fragmentManager != null) {
                for (Fragment fragment : this.fragmentManager.getFragments()) {
                    String tag = fragment.getTag();
                    if (tag == null || !tag.equals(NRWebContentFragment.TAG) && !tag.equals(ResultsFragment.TAG)) continue;
                    this.fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();
                }
            }
            if (this.clearUIInstance) {
                NanorepUI.getInstance().clearInstance();
            }
            Nanorep.getInstance().clearSuggestionsData();
        }
        super.onDestroyView();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
            NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        }
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        this.killedBySystem = true;
    }

    @Override
    public void onFaqsFetched(ArrayList<NRFAQGroupItem> groups) {
        if (this.context != null) {
            this.openResultsFragment(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), this.context), groups.get(0).getTitle(), true);
        }
    }
}

