package nanorep.nanowidget.adapters

import android.view.LayoutInflater
import android.view.ViewGroup
import com.nanorep.nanoclient.model.ResultResponse
import com.nanorep.nanoclient.model.labelType


class NRSupportLabelsAdapter(labelLayoutRes: Int, var listData: MutableList<ResultResponse>,
                             private val onListItemSelected: (id: String?, type: Int) -> Int?)
    : NRBaseAdapter<ResultsBaseViewHolder?>() {

    private val labelLayoutRes: Int
    private var list: MutableList<ResultResponse>

    init {
        enableClicks = true
        this.labelLayoutRes = labelLayoutRes
        this.list = listData
    }

    override fun getItemViewType(position: Int): Int {
        return listData[position].responseType
    }

    override fun setEnabledViewHolderClicks(enable: Boolean) {
        enableClicks = true
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ResultsBaseViewHolder {

        return if (viewType == labelType) {
            val context = parent.context
            val view = LayoutInflater.from(context).inflate(labelLayoutRes, parent, false)
            LabelViewHolder(view)
        } else {
            val context = parent.context
            val view = LayoutInflater.from(context).inflate(labelLayoutRes, parent, false)
            FaqViewHolder(view)
        }

    }

    override fun getItemCount(): Int {
        return listData.size
    }

    override fun onBindViewHolder(holder: ResultsBaseViewHolder, position: Int) {

        listData[position].let{

            holder.bind(it){
                onListItemSelected.invoke(it.responseId,  it.responseType)
                null
            }
        }
    }
}

/*
abstract class SupportViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    private var onClick: (()->Unit?)? = null

    init {
        itemView.setOnClickListener{
            onClick?.invoke()
        }
    }

    open fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        this.onClick = onClick
    }

    fun loadImage(imageView: ImageView, url: String?) {
        if (url == null || url.isEmpty()) {
            return
        }
        Nanorep.getInstance().widgetListener.onCachedImageRequest(url) { bitmap ->
            if (bitmap != null) {
                imageView.setImageBitmap(bitmap)
            }
        }
    }

}

class LabelViewHolder(itemView: View) : SupportViewHolder(itemView) {

    private val imageView: ImageView = itemView.findViewById(R.id.label_image)
    private val textView: TextView = itemView.findViewById(R.id.titleTextView)

    override fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        super.bind(listItem, onClick)
        (listItem as? SupportLabel)?.run {
            //loadImage(imageView, icons?.getIconUrl())
            textView.text = name
        }
    }
}

class FaqViewHolder(view: View) : SupportViewHolder(view) {

    var textView: TextView = view.findViewById(R.id.titleTextView)

    override fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        super.bind(listItem, onClick)
        (listItem as? NRResult)?.run {
            textView.text = fetchedResult.title
        }
    }
}*/
