package nanorep.nanowidget.Components.ChannelPresenters;


import android.content.Context;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Nanorep;


/**
 * Created by nissimpardo on 26/06/16.
 */
public class NRChannelStrategy {
    public static NRChannelPresenter presenter(Context context, NRChanneling channeling, Nanorep nanoRep) {
        NRChannelPresenter presenter = null;
        switch (channeling.getType()) {
            case OpenCustomURL:
            case ChatForm:
            case ContactForm:
                presenter = new NRWebContentChannelPresenter(nanoRep);
                break;
            case PhoneNumber:
                presenter = new NRPhoneChannelPresenter(context);
                break;
            case CustomScript:
                presenter = new NRCustomScriptChannelPresenter(context, nanoRep.getWidgetListener());
                break;
        }
        presenter.setChannel(channeling);
        return presenter;
    }

}
