package nanorep.nanowidget.adapters

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.nanorep.nanoclient.model.ResultResponse
import com.nanorep.nanoclient.model.labelType
import java.util.*

class NRResultsAdapter : NRBaseAdapter<ResultsBaseViewHolder?>() {

    private var results: MutableList<ResultResponse>
    private var listener: Listener? = null
    private var labelItemLayout = 0
    private var faqItemLayout = 0
    override fun setEnabledViewHolderClicks(enable: Boolean) {
        enableClicks = enable
    }

    fun setLabelItemLayout(labelItemLayout: Int) {
        this.labelItemLayout = labelItemLayout
    }

    fun setFaqItemLayout(faqItemLayout: Int) {
        this.faqItemLayout = faqItemLayout
    }

    interface Listener {
        fun onResultItemSelected(result: ResultResponse?, pos: Int)
    }

    override fun getItemViewType(position: Int): Int {
        return results[position].responseType
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ResultsBaseViewHolder {
        val view: View
        return if (viewType == labelType) {
            view = LayoutInflater.from(parent.context).inflate(labelItemLayout, parent, false)
            LabelViewHolder(view)
        } else {
            view = LayoutInflater.from(parent.context).inflate(faqItemLayout, parent, false)
            FaqViewHolder(view)
        }
    }

    override fun onBindViewHolder(holder: ResultsBaseViewHolder, position: Int) {
        holder.bind(results[position]) {
            if (listener != null) {
                listener!!.onResultItemSelected(results[position], position)
            }
            null
        }
    }

    override fun getItemCount(): Int {
        return results.size
    }

    fun updateItems(results: List<ResultResponse>) {
        if (results.isNotEmpty()) {
            if (results[0].responseType == labelType) {
                this.results = results.toMutableList()
            } else {
                addItems(results)
            }
            notifyDataSetChanged()
        }
    }

    fun addItems(items: List<ResultResponse>?) {

        items?.run {
            results.addAll(this)
        }
    }

    override fun onViewRecycled(holder: ResultsBaseViewHolder) {
        super.onViewRecycled(holder)
        holder.clear()
    }

    fun getItems(): List<ResultResponse> {
        return results
    }

    fun setListener(listener: Listener?) {
        this.listener = listener
    }

    init {
        enableClicks = false
        results = ArrayList()
    }
}