package nanorep.nanowidget.DataClass;

import android.content.Context;

import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Interfaces.NRSpeechRecognizerCompletion;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.R;
import com.nanorep.nanoclient.RequestParams.NRFAQLikeParams;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRFAQAnswer;
import com.nanorep.nanoclient.Response.NRFAQData;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.model.NRResult;
import com.nanorep.nanoclient.Response.NRSearchResponse;
import com.nanorep.nanoclient.Response.NRSuggestions;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.model.ResultResponse;
import com.nanorep.nanoclient.network.OnDataResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FETCH_DATA;

/**
 * Created by nissimpardo on 04/06/16.
 */
public class NRFetchedDataManager {

    private static String TAG = NRFetchedDataManager.class.getName();

    private NRFAQData mFaqData;
    private SearchFetcherListener mFetcherListener;
    private NRConfigFetcherListener mconfigFetcherListener;
    private Context context;
    private String preContextSelectionQuery;
    private String searchContext;
    private List<Map<String, Object>> contextList;
    private String selectionDialogTitle;

    public NRFetchedDataManager(Context context, NRConfigFetcherListener configFetcherListener) {
        this.context = context;
        mconfigFetcherListener = configFetcherListener;
        fetchConfiguration();
    }

    public void fetchConfiguration() {
        if (Nanorep.getInstance().getNRConfiguration() != null) {
            mconfigFetcherListener.onConfigurationReady();
//            prepareDatasource();
        }
    }

    public SearchFetcherListener getFetcherListener() {
        return mFetcherListener;
    }

    public void setFetcherListener(SearchFetcherListener listener) {
        mFetcherListener = listener;
    }

    public void setConfigFetcherListener(NRConfigFetcherListener mconfigFetcherListener) {
        this.mconfigFetcherListener = mconfigFetcherListener;
    }

    private void prepareDatasource() {
        if (Nanorep.getInstance().getAccountParams().isLabelsMode() && Nanorep.getInstance().getNRConfiguration().getLabels() != null) {
            mconfigFetcherListener.insertRows(null);
            return;
        }

        NRConnection.Listener listener = new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {

                if (error != null) {
                    mconfigFetcherListener.onError(error);
                } else {
                    final ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                    if (responseParam instanceof HashMap) {
                        final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                        final NRFAQGroupItem group = new NRFAQGroupItem(map);
                        groups.add(group);
                        mconfigFetcherListener.insertRows(groups);
                    }
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        };

        Nanorep.getInstance().updateFaqList(null, Nanorep.getInstance().getAccountParams().getContext(), listener);
    }

    public static ArrayList<ResultResponse> generateNRResultArray(ArrayList<NRQueryResult> queryResults, Context context) {
        if (queryResults != null) {
            int height = Integer.valueOf(Nanorep.getInstance().getNRConfiguration().getTitle().getTitleRowHeight());
            ArrayList<ResultResponse> results = new ArrayList<>();
            for (NRQueryResult result : queryResults) {
                NRResult currentResult = new NRResult(result, NRResult.RowType.TITLE);
                currentResult.setHeight((int) Calculate.pxFromDp(context, height));
                results.add(currentResult);
            }
            return results;
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    public void searchText(final String text) {
        Nanorep.getInstance().searchText(text, new Nanorep.OnSearchResultsFetchedListener() {
            @Override
            public void onSearchResponse(NRSearchResponse response, NRError error) {
                if (error != null) {
                    mconfigFetcherListener.onError(error);
                } else {
                    // Response null or no results found:

                    if (response == null || (response.getAnswerList() == null || response.getAnswerList().isEmpty())) {
                        NRResult noResult = getNoResultResponse(response, text);
                        mconfigFetcherListener.noResultFound(noResult, searchContext);
                        return;
                    }

                    // Results found:

                    boolean contextSelectionOnly;
                    String contextName = null;

                    ArrayList<ResultResponse> results = generateNRResultArray(response.getAnswerList(), context);

                    // try to generate contextList from the response.
                    try {
                        if (contextList == null && response.getParams().containsKey("context")) {
                            contextList = (List<Map<String, Object>>) ((Map<String, Object>) response.getParams().get("context")).get("values");
                        }

                        contextSelectionOnly = (boolean) response.getAnswerList().get(0).getParams().get("contextSelectionOnly");

                        List<Integer> selectionContextIds = response.getSelectionContextId();

                        if (contextList != null && !contextList.isEmpty()) {
                            contextName = findContextName(selectionContextIds, contextList);
                        }

                        if (contextName != null && contextName.length() == 0) {
                            contextSelectionOnly = false;
                        }

                    } catch (NullPointerException | ClassCastException e) {
                        contextSelectionOnly = false;
                    }

                    // responses handling:

                         // Has dynamic context
                    if (contextSelectionOnly && contextName != null && !contextName.isEmpty()) {
                        preContextSelectionQuery = text;
                        fetchContextSelectionData(contextName);

                        // Doesn't have dynamic context but has results
                    } else {
                        mFetcherListener.insertRows(results, searchContext);
                    }
                }
            }
        });
    }

    private String findContextName(List<Integer> ids, List<Map<String, Object>> contextList) {
        StringBuilder ctx = new StringBuilder();

        for (int id : ids) {
            for (Map<String, Object> map : contextList) {
                String _id = String.valueOf(map.get("id"));
                if (_id.equals(String.valueOf(id))) {
                    if (ctx.length() > 0) {
                        ctx.append(",");
                    }
                    selectionDialogTitle = (String) map.get("selectionText");
                    ctx.append((String) map.get("name"));
                }
            }
        }

        return ctx.toString();
    }


    private NRResult getNoResultResponse(NRSearchResponse response, String text) {
        response.getParams().put("originalSearch", text);
        return new NRResult(response.getParams());
    }

    private void fetchContextSelectionData(final String contextName) {
        Nanorep.getInstance().getContextValues(contextName, new OnDataResponse<String>() {
            @Override
            public void onSuccess(String response) {
                try {
                    String[] keys = contextName.split(",");
                    ContextValue contextValues = new ContextValue(keys[0]);
                    extractContext(new JSONObject(response), contextValues, keys, 0);
                    mconfigFetcherListener.showContextSelectionDialog(contextValues);
                } catch (Exception e) {
                    e.printStackTrace();
                }

            }

            @Override
            public void onError(NRConnectionException error) {
                mconfigFetcherListener.onError(NRError.error(TAG, CONNECTION, error.getMessage()));
            }
        });
    }

    private void extractContext(JSONObject json, ContextValue contextValue, String[] key, int depth) throws JSONException {
        Iterator<String> jsonKeys = json.keys();
        while (jsonKeys.hasNext()) {
            String propName = jsonKeys.next();
            ContextValue subContext;
            if (propName.equals("values")) {
                subContext = contextValue;
            } else {
                subContext = new ContextValue(key[depth]);
                subContext.setParentContextValue(propName);
                contextValue.getSubContext().add(subContext);
            }

            JSONArray arr = json.getJSONArray(propName);
            for (int i = 0; i < arr.length(); i++) {
                if (arr.get(i) instanceof String) {
                    subContext.getValues().add((String) arr.get(i));
                } else {
                    extractContext((JSONObject) arr.get(i), subContext, key, depth + 1);
                }
            }
        }
    }

    public void presentResultsForSelectedContext(final String selectedSearchContext) {
        Nanorep.getInstance().setContext(selectedSearchContext, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Nanorep.getInstance().removeFromSearchCache(preContextSelectionQuery);
                if (searchContext == null) {
                    searchContext = "";
                }
                searchContext = selectedSearchContext;
                Nanorep.getInstance().searchText(preContextSelectionQuery, new Nanorep.OnSearchResultsFetchedListener() {
                    @Override
                    public void onSearchResponse(NRSearchResponse response, NRError error) {
                        if (error != null) {
                            mconfigFetcherListener.onError(error);
                        } else {
                            ArrayList<ResultResponse> results = generateNRResultArray(response.getAnswerList(), context);
                            if (results != null) {
                                mFetcherListener.insertRows(results, searchContext);
                            } else {
                                NRResult noResult = getNoResultResponse(response, preContextSelectionQuery);
                                ArrayList<ResultResponse> noResultsArrayList = new ArrayList<>();
                                noResultsArrayList.add(noResult);
                                mFetcherListener.insertRows(noResultsArrayList, searchContext);
                            }
                        }
                    }
                });
            }

            @Override
            public void onError(NRConnectionException error) {
                mconfigFetcherListener.onError(NRError.error(TAG, CONNECTION, error.getMessage()));
            }
        });
    }

    public void searchSuggestion(final String suggestion) {
        Nanorep.getInstance().suggestionsForText(suggestion, new Nanorep.OnSuggestionsFetchedListener() {
            @Override
            public void onSuggestionsFetched(NRSuggestions suggestions, NRError error) {
                if (error != null && mconfigFetcherListener != null) {
                    mconfigFetcherListener.onError(error);
                } else if (suggestions != null && suggestions.getSuggestions() != null && mFetcherListener != null) {
                    mFetcherListener.presentSuggestion(suggestion, suggestions.getSuggestions());
                }
            }
        });
    }

    public void startSpeech(NRSpeechRecognizerCompletion completion) {
//        mNanoRep.startVoiceRecognition(completion);
    }

    public void sendLike(NRLikeType likeType, String feedbackText, NRQueryResult result, Nanorep.OnLikeSentListener completion) {
//        if (true) {
            NRFAQLikeParams likeParams = new NRFAQLikeParams(result, feedbackText);
            likeParams.setLikeType(likeType);
            likeParams.setAnswerId(result.getId());
            Nanorep.getInstance().likeForFAQResult(likeParams, completion);
//        } else {
//            NRSearchLikeParams likeParams = new NRSearchLikeParams(result);
//            likeParams.setFeedbackType(likeType);
//            Nanorep.getInstance().likeForSearchResult(likeParams, completion);
//        }
    }

    public void resetLike(String resultId) {
        for (NRQueryResult result : mFaqData.getGroups().get(0).getAnswers()) {
            if (result.getId().equals(resultId)) {
                result.setLikeState(NRQueryResult.LikeState.notSelected);
            }
        }
    }

    public void faqAnswer(final String answerId, Integer answerHash, final OnFAQAnswerFetched answerFetcher) {
        Nanorep.getInstance().fetchFAQAnswer(answerId, answerHash, new Nanorep.OnFAQAnswerFetchedListener() {
            @Override
            public void onFAQAnswerFetched(NRFAQAnswer faqAnswer, NRError error) {
                if (error == null) {
                    answerFetcher.onAnswerFetched(faqAnswer);
                } else {
                    mconfigFetcherListener.onError(error);
                }
            }
        });
    }

    private void onRequestError(NRError error) {}

    public void clearSearchContext() {
        searchContext = null;
    }

    public void fetchLabelFAQ(final NRLabel label, final NanorepUI.FaqsListener listener) {
        Nanorep.getInstance().updateFaqList(Integer.toHexString(label.getId()), label.getContext(), new NRConnection.Listener() {
            @Override
            public void response(Object responseParam, int status, NRError error) {
                try {
                    searchContext = label.getContext();
                    ArrayList<NRFAQGroupItem> groups = new ArrayList<>();
                    if (responseParam instanceof HashMap) {
                        final HashMap<String, Object> map = (HashMap<String, Object>) responseParam;
                        final NRFAQGroupItem group = new NRFAQGroupItem(map);
                        groups.add(group);
                        if (!groups.isEmpty()) {
                            listener.onFaqsFetched(groups);
                        } else {
                            mconfigFetcherListener.onError(NRError.error(TAG, FETCH_DATA, context.getString(R.string.label_error) + label.getTitle()));
                        }
                    }

                } catch (ClassCastException e) {
                    mconfigFetcherListener.onError(NRError.error(TAG, FETCH_DATA, context.getString(R.string.response_cast_error)));
                }
            }

            @Override
            public void log(String tag, String msg) {

            }
        });
    }

    private boolean duplicateFAQ(NRQueryResult nrQueryResult, ArrayList<NRQueryResult> answers) {
        for (NRQueryResult answer : answers) {
            if (answer.getId().equals(nrQueryResult.getId())) {
                return true;
            }
        }
        return false;
    }
}
