/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK.ViewHolders;

import android.text.Editable;
import android.text.TextWatcher;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.List;
import nanorep.nanowidget.Components.formSDK.Interactions.FormViewHolderAdapterInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.Components.formSDK.model.UserInput;
import nanorep.nanowidget.R;

public class EditTextViewHolder
extends FormFieldViewHolder
implements View.OnClickListener,
TextWatcher {
    private EditText editText;
    private TextView fieldTitle;
    private ImageButton clearButton;
    private ImageView emailIcon;
    private FormFields formField;

    public EditTextViewHolder(View itemView, List<FormFields> formFields, FormViewHolderAdapterInteraction formViewHolderAdapterInteraction) {
        super(itemView, formFields, formViewHolderAdapterInteraction);
        this.fieldTitle = (TextView)itemView.findViewById(R.id.holder_field_title);
        this.editText = (EditText)itemView.findViewById(R.id.holder_editText);
        this.clearButton = (ImageButton)itemView.findViewById(R.id.holder_editText_clearButton);
        this.emailIcon = (ImageView)itemView.findViewById(R.id.holder_editText_email);
        this.clearButton.setOnClickListener((View.OnClickListener)this);
        this.editText.addTextChangedListener((TextWatcher)this);
    }

    @Override
    public void bind() {
        this.formField = (FormFields)this.formFields.get(this.getAdapterPosition());
        if (this.isSendClicked() && this.formField.isRequired() && !this.formField.isValid()) {
            this.editText.requestFocus();
            this.setFieldError();
        }
        if (this.formField.getTextInputType() == 1) {
            this.emailIcon.setVisibility(0);
        }
        String fieldLabel = this.formField.getFieldLabel();
        String placeHolder = this.formField.getTextPlaceholder();
        if (placeHolder.length() > 0) {
            this.editText.setHint((CharSequence)placeHolder);
            this.appendFieldTitle(this.formField);
        } else {
            this.appendFieldHint(this.formField, fieldLabel);
        }
        this.keyboardInputConfig(this.formField.getTextInputType());
        this.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 5) {
                    EditTextViewHolder.this.formViewHolderAdapterInteraction.onNextClicked(EditTextViewHolder.this.getAdapterPosition());
                    return true;
                }
                return false;
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    EditTextViewHolder.this.handleUserInput(EditTextViewHolder.this.formField);
                }
            }
        });
    }

    private void appendFieldTitle(FormFields formField) {
        this.fieldTitle.setVisibility(0);
        if (formField.isRequired()) {
            this.fieldTitle.setText((CharSequence)this.redStarEnding(formField.getFieldLabel()));
        } else {
            this.fieldTitle.setText((CharSequence)formField.getFieldLabel());
        }
    }

    private void appendFieldHint(FormFields formField, String fieldLabel) {
        if (formField.isRequired()) {
            this.editText.setHint((CharSequence)this.redStarEnding(fieldLabel));
        } else {
            this.editText.setHint((CharSequence)fieldLabel);
        }
    }

    private void keyboardInputConfig(int inputType) {
        switch (inputType) {
            case 1: {
                this.editText.setInputType(32);
                break;
            }
            case 2: {
                this.editText.setInputType(3);
                break;
            }
            case 3: {
                this.editText.setInputType(2);
                break;
            }
            case 10: {
                this.editText.setInputType(3);
                break;
            }
            default: {
                this.editText.setInputType(1);
            }
        }
        this.editText.setImeOptions(5);
    }

    @Override
    public void handleUserInput(FormFields formField) {
        String value = this.editText.getText().toString();
        if (value.length() > 0) {
            formField.setFieldChecked(true);
            if (formField.getTextInputType() == 1) {
                if (!Patterns.EMAIL_ADDRESS.matcher(value).matches()) {
                    formField.setValid(false);
                } else {
                    formField.setValid(true);
                    formField.setUserInput(new UserInput(formField.getFieldLabel(), NRFormStructure.EMAIL, value, NRFormStructure.EMAIL));
                }
            } else {
                formField.setValid(true);
                formField.setUserInput(new UserInput(formField.getFieldLabel(), NRFormStructure.GENERAL, value, NRFormStructure.GENERAL));
            }
        } else {
            formField.setFieldChecked(false);
            formField.setValid(true);
        }
    }

    @Override
    public void setFieldError() {
        this.clearButton.setVisibility(4);
        if (this.formField.getValidationErrorMessage().length() > 0) {
            this.editText.setError((CharSequence)this.formField.getValidationErrorMessage());
        } else {
            this.editText.setError((CharSequence)this.itemView.getResources().getString(R.string.edit_text_error_message));
        }
    }

    @Override
    public View getErrorFieldPresenter() {
        return this.editText;
    }

    public void onClick(View v) {
        this.editText.setText((CharSequence)"");
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (this.editText.getText().length() > 0) {
            this.clearButton.setVisibility(0);
        } else {
            this.clearButton.setVisibility(4);
        }
    }

    public void afterTextChanged(Editable s) {
    }
}

