/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Components.formSDK;

import android.app.Activity;
import android.app.ActivityOptions;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.ImageButton;
import android.widget.TimePicker;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.formSDK.Adapters.FormAdapter;
import nanorep.nanowidget.Components.formSDK.Decorators.AutoButtonsDecorator;
import nanorep.nanowidget.Components.formSDK.Decorators.DividerItemDecorator;
import nanorep.nanowidget.Components.formSDK.Interactions.AdapterFragmentInteraction;
import nanorep.nanowidget.Components.formSDK.Interactions.FormInputDataRecyclerInteraction;
import nanorep.nanowidget.Components.formSDK.ViewHolders.FormFieldViewHolder;
import nanorep.nanowidget.Components.formSDK.ViewHolders.PickerViewHolder;
import nanorep.nanowidget.Components.formSDK.model.FormFields;
import nanorep.nanowidget.Components.formSDK.model.GetFormResponse;
import nanorep.nanowidget.Components.formSDK.model.NRForm;
import nanorep.nanowidget.Components.formSDK.model.NRFormInputData;
import nanorep.nanowidget.Components.formSDK.model.NRFormStructure;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchViewsProvider;

public class FormFragment
extends Fragment
implements AdapterFragmentInteraction,
FormInputDataRecyclerInteraction {
    public static String TAG = FormFragment.class.getName();
    private NRForm form;
    private List<NRFormStructure> nrFormStructure;
    private RecyclerView formRecyclerView;
    private FormAdapter adapter;
    private PickerViewHolder pickerViewHolder;
    private Drawable divider;
    private ArrayList<String> fileUploadPaths;
    private NRChanneling channel;
    private ConfirmationDialogsTextProvider confirmationDialogsTextProvider;
    private String url = "https://in1-1.nanorep.com/~gojek/api/channeling/v1/getForm?cb=";
    private int formID;
    private SearchViewsProvider viewsProvider;
    private Nanorep.ErrorListener errorListener;
    private FragmentManager fragmentManager;
    private Context context;
    private static final int FILE_REQUEST_CODE = 217;

    public static FormFragment newInstance(NRChanneling channel, ConfirmationDialogsTextProvider confirmationDialogsTextProvider, Nanorep.ErrorListener errorListener) {
        FormFragment formFragment = new FormFragment();
        formFragment.channel = channel;
        formFragment.confirmationDialogsTextProvider = confirmationDialogsTextProvider;
        formFragment.errorListener = errorListener;
        return formFragment;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("formID", this.formID);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.fragmentManager = this.getFragmentManager();
        this.context = this.getContext();
        if (savedInstanceState != null) {
            this.formID = savedInstanceState.getInt("formID");
        } else if (this.channel != null) {
            this.formID = Integer.valueOf(this.channel.getContactForm());
        }
        View rootView = inflater.inflate(R.layout.form_fragment, container, false);
        ImageButton closeButton = (ImageButton)rootView.findViewById(R.id.cancelButton);
        closeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FormFragment.this.discardForm();
            }
        });
        this.fileUploadPaths = new ArrayList();
        if (this.formID > 0) {
            this.formRecyclerView = (RecyclerView)rootView.findViewById(R.id.form_recycler_view);
            if (this.context != null) {
                this.divider = this.context.getResources().getDrawable(R.drawable.divider);
            }
            this.form = new NRForm(this);
            this.getFormAndGenerateRecyclerView(this.url, this.formID);
            this.setRecyclerViewDecoration();
            return rootView;
        }
        this.errorListener.onError(NRError.error((String)TAG, (int)8, (String)this.getString(R.string.form_error_message)));
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
        return null;
    }

    private void getFormAndGenerateRecyclerView(String url, int id2) {
        Uri.Builder formUrl = new Uri.Builder();
        formUrl.scheme("https").authority("in1-1.nanorep.com").appendPath("~gojek").appendPath("api").appendPath("channeling").appendPath("v1").appendPath("getForm").appendQueryParameter("cb", "").appendQueryParameter("contactFormId", String.valueOf(id2));
        NRConnection.connection((Uri.Builder)formUrl, (OnDataResponse)new OnDataResponse<GetFormResponse>(){

            public void onSuccess(GetFormResponse response) {
                if (response.toString().isEmpty() || response.getForms() == null || response.getForms().size() == 0) {
                    Log.e((String)"ServerResponseError", (String)"The response doesn't contain a form");
                    if (FormFragment.this.fragmentManager != null) {
                        FormFragment.this.fragmentManager.popBackStack();
                    }
                    return;
                }
                FormFragment.this.nrFormStructure = response.getForms();
                FormFragment.this.form.setNRformStructure((NRFormStructure)FormFragment.this.nrFormStructure.get(0));
                FormFragment.this.adapter = new FormAdapter(FormFragment.this.form.getStructure().getFields(), FormFragment.this);
                LinearLayoutManager manager = new LinearLayoutManager(FormFragment.this.getActivity().getApplicationContext());
                FormFragment.this.formRecyclerView.setLayoutManager((RecyclerView.LayoutManager)manager);
                FormFragment.this.formRecyclerView.setHasFixedSize(true);
                FormFragment.this.formRecyclerView.setAdapter((RecyclerView.Adapter)FormFragment.this.adapter);
            }

            public void onError(NRConnectionException error) {
                FormFragment.this.errorListener.onError(NRError.error((String)TAG, (int)1, (String)error.getMessage()));
                if (FormFragment.this.fragmentManager != null) {
                    FormFragment.this.fragmentManager.popBackStack();
                }
            }
        });
    }

    private void setRecyclerViewDecoration() {
        DividerItemDecorator dividerItemDecorator = new DividerItemDecorator(this.divider);
        this.formRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecorator);
        AutoButtonsDecorator autoButtonsDecorator = new AutoButtonsDecorator((Activity)this.getActivity(), this.divider);
        this.formRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)autoButtonsDecorator);
    }

    @Override
    public void selectFromPicker(int type, int adapterPosition, PickerViewHolder pickerViewHolder) {
        Calendar correctData = Calendar.getInstance();
        FormFields formField = this.form.getStructure().getFields().get(adapterPosition);
        if (formField.isDatePickerField()) {
            this.selectDateFromPicker(correctData, adapterPosition, pickerViewHolder);
        } else if (formField.isTimePickerField()) {
            this.selectTimeFromPicker(adapterPosition, pickerViewHolder);
        } else {
            this.selectFileFromPicker(pickerViewHolder);
        }
    }

    private void selectDateFromPicker(Calendar correctData, final int adapterPosition, final PickerViewHolder pickerViewHolder) {
        final FormFields formField = this.form.getStructure().getFields().get(adapterPosition);
        int correctYear = correctData.get(1);
        int correctMonth = correctData.get(2);
        int correctDay = correctData.get(5);
        if (this.context != null) {
            DatePickerDialog pickerDialog = new DatePickerDialog(this.context, new DatePickerDialog.OnDateSetListener(){

                public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                    pickerViewHolder.getPickerTitleTextView().setError(null);
                    formField.setTextPlaceholder(pickerViewHolder.getDateString(year, month, dayOfMonth));
                    formField.setFieldChecked(true);
                    formField.setValid(true);
                    pickerViewHolder.handleUserInput(formField);
                    pickerViewHolder.setPickedDataTextView(FormFragment.this.form.getStructure().getFields().get(adapterPosition).getTextPlaceholder());
                    pickerViewHolder.getClearButton().setAlpha(0.5f);
                }
            }, correctYear, correctMonth, correctDay);
            pickerDialog.show();
        }
    }

    private void selectTimeFromPicker(final int adapterPosition, final PickerViewHolder pickerViewHolder) {
        final FormFields formField = this.form.getStructure().getFields().get(adapterPosition);
        boolean correctHour = false;
        boolean correctMinute = false;
        if (this.context != null) {
            TimePickerDialog pickerDialog = new TimePickerDialog(this.context, new TimePickerDialog.OnTimeSetListener(){

                public void onTimeSet(TimePicker view, int hourOfDay, int minute) {
                    pickerViewHolder.getPickerTitleTextView().setError(null);
                    formField.setTextPlaceholder(pickerViewHolder.getTimeString(hourOfDay, minute));
                    formField.setFieldChecked(true);
                    formField.setValid(true);
                    pickerViewHolder.handleUserInput(formField);
                    pickerViewHolder.setPickedDataTextView(FormFragment.this.form.getStructure().getFields().get(adapterPosition).getTextPlaceholder());
                    pickerViewHolder.getClearButton().setAlpha(0.5f);
                }
            }, 0, 0, true);
            pickerDialog.show();
        }
    }

    public void selectFileFromPicker(PickerViewHolder pickerViewHolder) {
        this.pickerViewHolder = pickerViewHolder;
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        if (Build.VERSION.SDK_INT >= 21) {
            this.startActivityForResult(intent, 217, ActivityOptions.makeSceneTransitionAnimation((Activity)this.getActivity(), (Pair[])new Pair[0]).toBundle());
        } else {
            this.startActivityForResult(intent, 217);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent resultData) {
        if (requestCode == 217 && resultCode == -1 && resultData != null) {
            FormFields formField = this.form.getStructure().getFields().get(this.pickerViewHolder.getAdapterPosition());
            Uri uri = resultData.getData();
            this.pickerViewHolder.setFileUri(uri);
            if (this.context != null) {
                this.fileUploadPaths.add(this.pickerViewHolder.getFilePath(this.context, uri));
            }
            formField.setFieldChecked(true);
            formField.setValid(true);
            this.pickerViewHolder.handleUserInput(formField);
            String fileName = this.pickerViewHolder.getFileName(uri);
            this.pickerViewHolder.setPickedDataTextView(fileName);
            this.pickerViewHolder.getClearButton().setAlpha(0.5f);
            this.pickerViewHolder.getPickerTitleTextView().setError(null);
        }
    }

    @Override
    public void validateDataAndSendForm() {
        NRFormInputData nrFormInputData = this.form.getNRformInputData();
        nrFormInputData.integrateFieldsInputsToForm();
        if (nrFormInputData.formValidation()) {
            final String formInputData = nrFormInputData.formInputData();
            if (this.context != null && this.viewsProvider != null && this.viewsProvider.showChannelConfirmationDialogs(this.channel)) {
                this.confirmationDialogsTextProvider.setChannelConfirmationDialogBody(this.channel.getThankYouMessage());
                View view = LayoutInflater.from((Context)this.context).inflate(this.viewsProvider.getConfirmationDialogsView(), null);
                ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(this.context, true, view, this.confirmationDialogsTextProvider);
                confirmationDialogFragment.setListener(new ConfirmationDialogFragment.OnOkClick(){

                    @Override
                    public void okClicked() {
                        Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(formInputData, FormFragment.this.fileUploadPaths);
                        if (FormFragment.this.fragmentManager != null) {
                            FormFragment.this.fragmentManager.popBackStack();
                        }
                    }
                });
                confirmationDialogFragment.show();
            } else {
                Nanorep.getInstance().getWidgetListener().onSubmitSupportForm(formInputData, this.fileUploadPaths);
                if (this.fragmentManager != null) {
                    this.fragmentManager.popBackStack();
                }
            }
        }
    }

    @Override
    public void discardForm() {
        if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }

    @Override
    public void scrollToInvalidatedFieldAndSetError(int position) {
        if (this.formRecyclerView.findViewHolderForAdapterPosition(position) == null) {
            this.formRecyclerView.scrollToPosition(position);
        } else {
            ((FormFieldViewHolder)this.formRecyclerView.findViewHolderForAdapterPosition(position)).getErrorFieldPresenter().requestFocus();
            ((FormFieldViewHolder)this.formRecyclerView.findViewHolderForAdapterPosition(position)).setFieldError();
        }
    }

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }
}

