/*
package nanorep.nanowidget.Fragments;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.Toolbar;
import android.text.Spannable;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroup.LayoutParams;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.ConnectivityReceiver;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRAnswer;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSearchBarView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.BaseListView;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.MyWebView;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRCategoriesView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRResultItem;
import nanorep.nanowidget.Components.NRResultsView;
import nanorep.nanowidget.Components.NRSearchBar;
import nanorep.nanowidget.Components.NRSuggestionsView;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.Components.formSDK.FormFragment;
import nanorep.nanowidget.DataClass.ContextSelectionAdapter;
import nanorep.nanowidget.DataClass.ContextSelectionHandler;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRLabelsAdapter;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter.kt;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.Utilities.Calculate;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRApplicationContentListener;
import nanorep.nanowidget.interfaces.NRConfigFetcherListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.NRFetcherListener;
import nanorep.nanowidget.interfaces.NRSearchBarListener;
import nanorep.nanowidget.interfaces.NRSuggestionsListener;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

import static android.view.View.GONE;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ChatForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.ContactForm;
import static com.nanorep.nanoclient.Channeling.NRChanneling.NRChannelingType.PhoneNumber;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.ARTICLE;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.CONNECTION;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FEEDBACK;
import static com.nanorep.nanoclient.Connection.NRErrorCodes.FORM;
import static com.nanorep.nanoclient.Handlers.NRErrorHandler.ErrorType.TIMEOUT_UPPER_LINE;
import static com.nanorep.nanoclient.Response.NRConfiguration.NO_FEEDBACK_DIALOG_TYPE;

public class NRMainFragment extends Fragment implements NRSearchBarListener, NRLabelsAdapter.NRLabelsListener,
        NRSuggestionsListener,
        NRCategoriesView.Listener,
        NRResultsView.Listener,
        NRContentView.Listener,
        NRChannelItem.OnChannelSelectedListener,
        NRArticleView.Listener,
        NRErrorHandler.Listener, ConnectivityReceiver.ConnectivityListener {

    public static final String TAG = NRMainFragment.class.getName();
    private static final int NO_TITLE_HEIGHT = 100;
    private static final int NO_CONNECTION_HEIGHT = 24;

    private ConnectivityReceiver connectivityReceiver;

    private NRFetchedDataManager mFetchedDataManager;

    private NRCustomViewAdapter viewAdapter;

    private RelativeLayout mLoadingView;

    private SearchViewsProvider viewsProvider;

    private FrameLayout contentMain;

    private Nanorep.NanoRepWidgetListener widgetListener;

    // search bar
    private LinearLayout searchBarContainer;
    private NRCustomSearchBarView searchBarView;

    // suggestion view
    private NRCustomSuggestionsView mSuggestionsView;
    private LinearLayout mSuggestionViewContainer;

    private NRCategoriesView categoriesView;

    private boolean resetSuggestions = false;

    private boolean autocompleteEnabled = true;

    private boolean isFromSuggestion;

    // no connection
    private LinearLayout noConnectionView;

    private AccountParams accountParams;
    private NRConfiguration configuration;
    private Nanorep nanorepInstance;

    private boolean animation = true;

    private NRApplicationContentListener applicationContentListener;
    private NRCustomChannelView channelView;
    private NRCustomLikeView likeView;
    private String articleId;

    private TextView searchContextTextView;
    private LinearLayout searchContextView;
    private String searchContextKey;
    private String searchContextValue;

    private NRLabel currentLabel;
    private TextView actionBarTextView;
    //    private NRResult currentResult;
    private boolean fragmentPaused;
    private NRChannelingView noResultsChannelingRecycler;
    private long previousClickTime;
    private NRResultsView resultsView;
    private AlertDialog contextSelectionDialog;
    private ConfirmationDialogsTextProvider confirmationDialogsTextProvider;
    private boolean connectionOk;
    private BaseListView currentView;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        this.articleId = resultID;
        mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(NRQueryResult result) {
                if (result != null) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            }
        });
    }

    @Override
    public void onStart() {
        super.onStart();
        if (connectivityReceiver == null) {
            connectivityReceiver = new ConnectivityReceiver();
        }

        if (!connectivityReceiver.isConnected()) {
            connectivityReceiver.register(getContext(), this);
        }
    }

    @Override
    public void closeAnswer() {
        // get the last view
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (animation) {
            view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
        } else {
            if (view instanceof NRArticleView && !((NRArticleView) view).getResult().isSingle()) {
                ((NRArticleView) view).setResultUnFoldState(false);
                ((NRArticleView) view).removeTopView();
            }
        }

        contentMain.removeView(view);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        final String predefinedExtraData;
        NRQueryResult currentResult = getCurrentResult();
        if (currentResult == null || currentResult.getExtraData() == null) {
            //
            //            if(channel.getNoResultExtra() == null) {
            //                openChannel(channel);
            //                return;
            //            }
            predefinedExtraData = channel.getNoResultExtra();
        } else {
            predefinedExtraData = getCurrentResult().getExtraData();
        }

        widgetListener
                .personalInfoWithExtraData(
                        channel.getChannelDescription(),
                        predefinedExtraData,
                        new NRExtraDataListener() {
                            @Override
                            public void onExtraData(Map<String, String> extraData) {
                                channel.setExtraData(extraData, predefinedExtraData);
                                openChannel(channel);
                            }
                        });
    }

    private void openChannel(NRChanneling channeling) {

        NRChannelPresenter presenter = NRChannelStrategy.presenter(getContext(), channeling, nanorepInstance);

        if (presenter instanceof NRCustomScriptChannelPresenter) {

            presenter.present();

        } else {

            final FragmentManager fragmentManager = getFragmentManager();

            String url = presenter.getUrl();
            if (url != null && fragmentManager != null && viewsProvider != null) {

                if (channeling.getType() == ContactForm
                        && TextUtils.isDigitsOnly(channeling.getContactForm())
                        && android.os.Build.VERSION.SDK_INT < Build.VERSION_CODES.KITKAT) {

                    FormFragment fragment = FormFragment.newInstance(channeling, configuration.getConfirmationDialogsText(getContext()), widgetListener);
                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment)
                            .commit();

                } else {
                    View view = getView();
                    if (channeling.getType() == ChatForm && view != null) {
                        final RelativeLayout holder = view.findViewById(R.id.fragment_place_holder);
                        holder.setVisibility(View.VISIBLE);
                    }

                    final NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, viewsProvider, widgetListener);

                    fragment.setConfirmationDialogsTextProvider(configuration.getConfirmationDialogsText(getContext()));

                    fragment.setListener(new NRWebContentFragment.WebFormListener() {
                        @Override
                        public void onDismiss(String result) {

                            if (result == null) {
                                widgetListener.onError(NRError.error(TAG, FORM, getString(R.string.null_form_result)));
                            }

                            fragmentManager.popBackStack();

                            fragmentManager.beginTransaction().remove(fragment).commitAllowingStateLoss();

                            hideKeyboard();

                            requestFocus();

                        }
                    });
                    fragmentManager
                            .beginTransaction()
                            .setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out)
                            .add(R.id.content_main, fragment, NRWebContentFragment.TAG)
                            .addToBackStack(null)
                            .commit();
                }
            } else if (channeling.getType() == PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber) channeling).getPhoneNumber();
                widgetListener.onChannel(PhoneNumber, phoneNumber);
                String channelName = channeling.getName();
//                Intent intent = new Intent(Intent.ACTION_DIAL, Uri.fromParts("tel", phoneNumber, null));
//                intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
//                try {
//                    startActivity(intent);
//                } catch (ActivityNotFoundException e) {
//
//                }
            }

        }
        nanorepInstance.reportChanneling(getCurrentResult(), channeling);
    }


    private NRQueryResult getCurrentResult() {
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView) view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched() {
            @Override
            public void onAnswerFetched(final NRQueryResult result) {

                NRResult newResult = new NRResult(result, NRResultItem.RowType.TITLE);
                int height = Integer.valueOf(configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int) Calculate.pxFromDp(getContext(), height));
                newResult.setSingle(true);

                NRArticleView resultTopView = getTopView();
                contentMain.addView(resultTopView);

                resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));

                resultTopView.openOpenedView(newResult);

                requestFocus();
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        if (accountParams.isOpenLinksInternally()) {
            MyWebView webView = new MyWebView(getContext(), url, new MyWebView.Listener() {
                @Override
                public void onDismiss() {
                    contentMain.removeViewAt(contentMain.getChildCount() - 1);
                    requestFocus();
                }
            });

            contentMain.addView(webView);
            requestFocus();
        } else {
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setData(Uri.parse(url));
            try {
                startActivity(intent);
            } catch (Exception e) {

            }
        }
    }

    @Override
    public void onError(NRError error) {
        widgetListener.onError(error);
    }

    @Override
    public void onDismiss() { //for NRContent
        View view = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (view instanceof NRArticleView) {
            Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left);
            animation.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {
                    searchBarView.adaptSearchBarDisplay(false, "");
                    searchBarView.clearText();
                }

                @Override
                public void onAnimationEnd(Animation animation) {

                }

                @Override
                public void onAnimationRepeat(Animation animation) {
                }
            });

            view.setAnimation(animation);
        }
        removeTopView();

    }

    @Override
    public void onLikeClicked(final NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        final NRResult result = view.getResult();
        if (result != null) {
            final NRQueryResult fetchedResult = result.getFetchedResult();
            if (fetchedResult != null) {
                if (isLike) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                    mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener() {
                        @Override
                        public void onLikeSent(boolean success) {
                            final Context context = getContext();
                            if (!success) {
                                fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                                likeView.resetLikeView();
                            } else if (context != null) {
                                likeView.onFeedbackSubmitted();
                            }
                        }
                    });
                } else {
                    if (likeView.shouldOpenDialog()) {
                        openDislikeDialog(fetchedResult, likeView);
                    } else {
                        onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
                    }
                }
            }
        }
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener() {
            @Override
            public void onLikeSent(boolean success) {
                final Context context = getContext();
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    widgetListener.onError(NRError.error(TAG, FEEDBACK, getString(R.string.feedback_error_message)));
                    removeTopView();
                } else if (context != null) {
                    likeView.onFeedbackSubmitted();
                }
            }
        });
    }

    private void onDismissDislike() {
        // update channeling
        nanorepInstance.updateDislikeChanneling(articleId, false, new OnDataResponse<List<NRChanneling>>() {
            @Override
            public void onSuccess(List<NRChanneling> response) {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView) view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                channelView.setVisibility(View.VISIBLE);
                channelView.setChanneling(response);
            }

            @Override
            public void onError(NRConnectionException error) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.update_channeling_error) + error.getData()));
                channelView.setVisibility(GONE);
            }
        });
    }


    private void openDislikeDialog(final NRQueryResult fetchedResult, final NRCustomLikeView likeView) {

        final int dialogType = configuration.getFeedbackDialogType();

        if (dialogType != NO_FEEDBACK_DIALOG_TYPE) {
            final Context context = getContext();
            if (context != null && viewsProvider != null && getFragmentManager() != null) {
                NRCustomDislikeDialog dislikeDialog = viewsProvider.getDislikeDialog(new DislikeConfiguration(configuration) {
                    @Override
                    public DislikeDialogListener getDislikeDialogListener() {
                        return new DislikeDialogListener() {
                            @Override
                            public void onCancel() {
                                likeView.resetLikeView();
                                NRMainFragment.this.onDismissDislike();
                            }

                            @Override
                            public void onDislike(NRLikeType type, String feedbackText) {
                                NRMainFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                            }
                        };
                    }
                });
                dislikeDialog.show(getFragmentManager(), "dislike");
            }
        }
    }

    public static NRMainFragment newInstance(String context) {
        NRMainFragment fragment = new NRMainFragment();
        return fragment;
    }

    */
/***
     * provide the views provider by the search injector
     * @param injector  - If equals to null, a default views provider would be created
     * @return
     *//*

    public static NRMainFragment newInstance(SearchInjector injector) {
        NRMainFragment fragment = new NRMainFragment();

        fragment.viewsProvider = injector.getUiProvider();

        return fragment;
    }

    public static NRMainFragment newInstance() {

        Bundle args = new Bundle();

        NRMainFragment fragment = new NRMainFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);

        if (context instanceof NRCustomViewAdapter) {
            viewAdapter = (NRCustomViewAdapter) context;
        }
    }

    private void initDataManager() {
        mFetchedDataManager = new NRFetchedDataManager(getContext(), new NRConfigFetcherListener() {

            @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
            @Override
            public void onConfigurationReady() {

                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) {
                    contentMain.removeView(view);
                }

                updateTitleNormalText();
                updateSearchBar();
                showSuggestionsView();
                mLoadingView.setVisibility(GONE);
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                try {
                    if (groups != null && groups.size() == 1) {
                        openNRResultView(NRFetchedDataManager.generateNRResultArray(groups.get(0).getAnswers(), getContext()), groups.get(0).getTitle());
                    } else if (accountParams.isLabelsMode()) {
                        openCategoriesView(groups);
                    }
                } catch (Exception e) {
                    return;
                }
            }

            @Override
            public void onError(NRError error) {
                mLoadingView.setVisibility(GONE);

                if (error.getCode() == CONNECTION) {

                    NRErrorView errorView = new NRErrorView(getContext());
                    errorView.setListener(new NRErrorView.Listener() {
                        @Override
                        public void tryAgain() {
                            mFetchedDataManager.fetchConfiguration();
                            mLoadingView.setVisibility(View.VISIBLE);
                        }
                    });
                    contentMain.addView(errorView);
                }

                widgetListener.onError(error);
            }

            @Override
            public void noResultFound(NRResult result, String searchContext) {
                List<NRResult> results = new ArrayList<>();
                results.add(result);
                mFetchedDataManager.getFetcherListener().insertRows(results, searchContext);
                if (searchContextValue == null) {
                    clearContextFromSession();
                }
            }

            @Override
            public void showContextSelectionDialog(ContextValue contextValues) {

                View contextSelectionDialogView = LayoutInflater.from(getContext()).inflate(R.layout.context_selection_dialog, null);
                final TextView contextTitle = contextSelectionDialogView.findViewById(R.id.context_selection_title);
                final Button cancelButton = contextSelectionDialogView.findViewById(R.id.cancelButton);
                RecyclerView recycler = contextSelectionDialogView.findViewById(R.id.context_selection_recycler);
                recycler.setLayoutManager(new LinearLayoutManager(contextSelectionDialogView.getContext()));
                recycler.addItemDecoration(new DividerItemDecoration(contextSelectionDialogView.getContext(), DividerItemDecoration.VERTICAL));

                final ContextSelectionAdapter adapter = new ContextSelectionAdapter(contextValues);
                ContextSelectionHandler contextSelectionHandler = new ContextSelectionHandler(contextValues, new ContextSelectionHandler.ContextSelectionListener() {

                    @Override
                    public void updateContextData(@org.jetbrains.annotations.NotNull ContextValue contextValues) {
                        contextTitle.setText(R.string.contextDialogTitle);
                        contextTitle.append(" " + contextValues.getContextKey());
                        adapter.setContextList(contextValues);
                        adapter.notifyDataSetChanged();
                    }

                    @Override
                    public void onContextSelected(@NonNull String searchContext) {
                        mFetchedDataManager.presentResultsForSelectedContext(searchContext);
                        contextSelectionDialog.dismiss();
                    }
                });

                adapter.setContextListener(contextSelectionHandler);
                recycler.setAdapter(adapter);

                cancelButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {

                        clearContext();

                        resetSuggestions = true;
                        clearSuggestionsView();

                        contentMain.setVisibility(View.VISIBLE);

                        contextSelectionDialog.dismiss();
                    }
                });

                contextTitle.setText(R.string.contextDialogTitle);
                contextTitle.append(" " + contextValues.getContextKey());

                AlertDialog.Builder builder = new AlertDialog.Builder(contextSelectionDialogView.getContext());
                contextSelectionDialog = builder.setView(contextSelectionDialogView).create();
                contextSelectionDialog.setCanceledOnTouchOutside(false);
                contextSelectionDialog.setOnKeyListener(new Dialog.OnKeyListener() {
                    @Override
                    public boolean onKey(DialogInterface arg0, int keyCode,
                                         KeyEvent event) {
                        if (keyCode == KeyEvent.KEYCODE_BACK) {
                            cancelButton.callOnClick();
                            return true;
                        }
                        return true;
                    }
                });

                contextSelectionDialog.show();
            }
        });

        mFetchedDataManager.setFetcherListener(new NRFetcherListener() {

            @Override
            public void reloadWithAnimation() {

            }

            @Override
            public void reload() {

            }

            @Override
            public void insertRows(final List<NRResult> results, final String searchContext) {
                if (isDetached() || getContext() == null) {
                    return;
                }

                hideKeyboard();

                clearSuggestionsView();

                updateContextView(searchContext);


                if (results == null || (results.size() == 1 && results.get(0).getFetchedResult() == null)) {
                    if (searchBarView.getSearchQuery() != null) {
                        while (contentMain.getChildCount() > 2) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    NRResult result;

                    if (results == null) {
                        Map<String, Object> params = new HashMap<>();
                        params.put("originalSearch", "");
                        result = new NRResult(params);
                    } else {
                        result = results.get(0);
                    }

                    final NRArticleView resultTopView = getTopView();

                    resultTopView.setVisibility(View.VISIBLE);
                    contentMain.setVisibility(View.VISIBLE);

                    contentMain.addView(resultTopView);

                    presentResult(result, 0, resultTopView);

                } else if (results.size() == 1) {
                    final NRResult currentResult = results.get(0);
                    if (currentResult != null) {
                        final NRQueryResult fetchedResult = currentResult.getFetchedResult();
                        if (fetchedResult != null) {
                            articleId = fetchedResult.getId();
                            NRArticleView resultTopView = getTopView();

                            contentMain.setVisibility(View.VISIBLE);
                            contentMain.addView(resultTopView);

                            Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left);
                            animation.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                    updateLabelsParallel(fetchedResult.getTitle());
                                    updateContextView(searchContext);
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {
                                    contentMain.getChildAt(contentMain.getChildCount() - 1).setVisibility(View.VISIBLE);
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {
                                }
                            });

                            resultTopView.setAnimation(animation);

                            resultTopView.startAnimation(animation);

                            NRResult result = results.get(0);

                            result.setSingle(true);

                            resultTopView.openOpenedView(result);

                            requestFocus();
                        }
                    }

                } else if (results.size() > 1) {
                    // show results View
                    contentMain.setVisibility(View.VISIBLE);

                    openNRResultView(results, null);
                }
            }

            @Override
            public void presentSuggestion(String querytext, ArrayList<Spannable> suggestions) {
                if (!resetSuggestions && searchBarView.getSearchQuery().length() - querytext.length() <= 1 && autocompleteEnabled) {
                    mSuggestionsView.setSuggestions(suggestions);
                    mSuggestionViewContainer.setVisibility(View.VISIBLE);
                    // hide content view
                    contentMain.setVisibility(GONE);
                }
            }

            @Override
            public void onConnectionFailed(HashMap<String, Object> errorParams) {

            }
        });
    }

    private void hideKeyboard() {
        View view = getView();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager) getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }

    private void renewSession() {
        if (nanorepInstance.getSessionId() == null) {
            return;
        }

        //todo
    }

    private void openCategoriesView(ArrayList<NRFAQGroupItem> groups) {

        if (viewsProvider != null) {

            categoriesView = new NRCategoriesView(getActivity(), viewsProvider.getResultsViewLayout());

            currentView = categoriesView;

            categoriesView.setLabelItemTitleView(viewsProvider.getLabelItemTitleLayout());

            if (accountParams.isLabelsMode()) {
                categoriesView.initLabelsAdapter(configuration.getLabels(), NRMainFragment.this);
            } else {
                categoriesView.setCategories(groups, viewAdapter, NRMainFragment.this);
            }

            contentMain.addView(categoriesView);
        }
    }

    private NRArticleView getTopView() {

        NRArticleView resultTopView = new NRArticleView(getActivity(), viewsProvider);
        resultTopView.setListener(this);
        NRCustomTitleView titleView = viewAdapter.getTitleView(getContext());

        if (titleView == null) {
            titleView = new NRArticleTitleView(getContext(), viewsProvider);
        }

        ((NRArticleTitleView) titleView).configViewObjects(configuration);

        NRCustomContentView contentView = viewAdapter.getContentView(getContext());

        if (contentView == null) {
            contentView = new NRContentView(getContext());
        }

        if (applicationContentListener != null) {
            contentView.setApplicationContentListener(applicationContentListener);
        }

        likeView = viewAdapter.getLikeView(getContext());

        if (likeView == null) {
            likeView = new NRLikeViewText(getContext(), viewsProvider);
        }

        channelView = viewAdapter.getChannelView(getContext());

        if (channelView == null) {
            channelView = new NRChannelingView(getContext(), viewsProvider);
        }

        NRCustomFeedbackView feedbackView = viewAdapter.getFeedbackView(getContext());

        resultTopView.setTitleView(titleView);
        resultTopView.setContentView(contentView, this);


        if (feedbackView != null) {
            feedbackView.setCustomChannelView(channelView);
            feedbackView.setCustomLikeView(likeView);
            resultTopView.setLikeView(feedbackView.getCustomLikeView());
            resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
            resultTopView.setFeedbackView(feedbackView);
        } else {
            resultTopView.setLikeView(likeView);
            resultTopView.setChannelView(channelView, this);
        }

        return resultTopView;
    }

    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {

        nanorepInstance = Nanorep.getInstance();
        configuration = nanorepInstance.getNRConfiguration();
        accountParams = nanorepInstance.getAccountParams();
        confirmationDialogsTextProvider = configuration.getConfirmationDialogsText(getContext());
        widgetListener = nanorepInstance.getWidgetListener();

        if (viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider(viewsProvider);
        } else {
            if (nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider) {
                viewsProvider = (SearchViewsProvider) nanorepInstance.getSearchViewsProvider();
            } else {
                viewsProvider = new SearchInjector.DefaultsInjector().getUiProvider();
            }
        }

        if (viewAdapter == null) {
            viewAdapter = new NRViewAdapter(viewsProvider);
        }

        NRErrorHandler.getInstance().setListener(this);
        View view = inflater.inflate(R.layout.fragment_main, container, false);
        mLoadingView = view.findViewById(R.id.fragment_place_holder);
        contentMain = view.findViewById(R.id.content_main);
        noConnectionView = view.findViewById(R.id.noConnectionView);
        searchContextTextView = view.findViewById(R.id.user_selected_context_textview);
        searchContextView = view.findViewById(R.id.current_user_selected_context_layout);
        noResultsChannelingRecycler = view.findViewById(R.id.channelingView);
        Button clearContextButton = view.findViewById(R.id.clear_user_selected_button);

        clearContextButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                removeAllTopLayers();

                categoriesView.enableAdapterClicks(true);

                clearContext();
            }
        });

        setViews(view);

        initDataManager();
        return view;
    }

    @Override
    public void onClearSearchText() {

        removeAllTopLayers();

        clearContext();

        resetSuggestions = true;

        clearSuggestionsView();

        if (categoriesView != null) {
            categoriesView.enableAdapterClicks(true);
        }

        // show content
        setLoadingState(false);
    }

    private void clearContext() {

        searchContextView.setVisibility(GONE);

        if (searchContextValue != null || currentLabel != null) {

            searchContextValue = null;
            currentLabel = null;

            mFetchedDataManager.clearSearchContext();

            clearContextFromSession();
        }

        clearSuggestionsView();

        contentMain.setVisibility(View.VISIBLE);
    }

    private void setToLabelContext() {

        mFetchedDataManager.clearSearchContext();

        clearContextFromSession();

        clearSuggestionsView();

        nanorepInstance.setContext(currentLabel.getContext(), new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Log.d("DeleteLastContext", "Last Context deleted successfully");
            }

            @Override
            public void onError(NRConnectionException error) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.delete_last_context_error)));
            }
        });

        searchContextValue = currentLabel.getContext();
    }

    private void clearContextFromSession() {
        nanorepInstance.setContext(null, new OnDataResponse<DefaultResponse>() {
            @Override
            public void onSuccess(DefaultResponse response) {
                Log.d("ClearContext", "Context cleared successfully");
            }

            @Override
            public void onError(NRConnectionException error) {
                widgetListener.onError(NRError.error(TAG, CONNECTION, getString(R.string.clear_context_error)));
            }
        });
    }

    private void removeAllTopLayers() {

        int viewLayers = contentMain.getChildCount() - 1;

        while (0 < viewLayers) {
            contentMain.removeViewAt(viewLayers--);
        }

        searchBarView.adaptSearchBarDisplay(false, null);
    }

    private void updateContextView(String updatedContext) {

        if (updatedContext == null || updatedContext.isEmpty()) {
            clearContext();

        } else {
            if (!updatedContext.equals(searchContextValue) || currentLabel != null) {
                StringBuilder builder = new StringBuilder();

                if (currentLabel != null && !currentLabel.getContext().equals(updatedContext)) {
                    updatedContext = currentLabel.getContext() + ','+ updatedContext;
                }

                for (String context : updatedContext.split(",")) {
                    String[] ctx = context.split(":");
                    if (ctx.length != 2) {
                        return;
                    }
                    if (builder.length() > 0) {
                        builder.append(", ");
                    }
                    builder.append(ctx[1]);
                }
                searchContextValue = builder.toString();
            }

            searchContextTextView.setText(searchContextValue);
            searchContextView.setVisibility(View.VISIBLE);
        }
    }

    private void updateSearchBar() {
        NRConfiguration.NRTitle titleConfig = configuration.getTitle();
        NRConfiguration.NRSearchBar searchBarConfig = configuration.getSearchBar();

        searchBarView.setHint(searchBarConfig.getInitialText());
        searchBarView.setViewsProvider(viewsProvider);

        String titleBGColor;

        // titleConfig color
        if (!isEmpty(titleConfig.getTitleBGColor())) {
            titleBGColor = titleConfig.getTitleBGColor();
        } else {
            titleBGColor = "#0aa0ff";
        }

        searchBarContainer.setBackgroundColor(Color.parseColor(titleBGColor));
    }

    private void updateTitleNormalText() {
        NRConfiguration.NRTitle title = configuration.getTitle();
        if (getActivity() != null) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();
            if (actionBar == null) {
                return;
            }

            View customActionBar = getActivity().getLayoutInflater().inflate(R.layout.nr_title_bar, null);
            ActionBar.LayoutParams layout = new ActionBar.LayoutParams(ActionBar.LayoutParams.MATCH_PARENT, ActionBar.LayoutParams.MATCH_PARENT);

            actionBar.setCustomView(customActionBar, layout);
            actionBar.setDisplayShowHomeEnabled(false);
            actionBar.setDisplayShowTitleEnabled(false);
            actionBar.setDisplayShowCustomEnabled(true);

            Toolbar parent = (Toolbar) customActionBar.getParent();
            parent.setPadding(0, 0, 0, 0);//for tab otherwise give space in tab
            parent.setContentInsetsAbsolute(0, 0);

            actionBarTextView = actionBar.getCustomView().findViewById(R.id.titleBarTv);


            // titleConfig text
            String titleText = configuration.getTitleText();
            setActionBarTitleText(titleText);
//        actionBarTextView.setText(titleText);

            // titleConfig color
            if (!isEmpty(title.getTitleColor())) {
                String titleColor = title.getTitleColor();
                actionBarTextView.setTextColor(Color.parseColor(titleColor));
            }

            // titleConfig background color
            if (!isEmpty(title.getTitleBGColor())) {
                String titleBGColor = title.getTitleBGColor();
                RelativeLayout relativeLayout = actionBar.getCustomView().findViewById(R.id.nrTitleBarLayout);
                relativeLayout.setBackgroundColor(Color.parseColor(titleBGColor));
            }

            // titleConfig font
            if (!isEmpty(title.getTitleFont())) {
                String titleFont = title.getTitleFont();
                actionBarTextView.setTypeface(Typeface.create(titleFont, Typeface.NORMAL));
            }
        }
    }

    private void setActionBarTitleText(String title) {
        if (getActivity() != null && !title.isEmpty()) {
            ActionBar actionBar = ((AppCompatActivity) getActivity()).getSupportActionBar();

            if (actionBar == null) {
                return;
            }

            String fixedTitle = accountParams.getFixedTitle();

            TextView tv = actionBar.getCustomView().findViewById(R.id.titleBarTv);
            tv.setText(fixedTitle != null ? fixedTitle : title);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }


    private void setViews(View nanoView) {

        Context context = nanoView.getContext();

        if (context != null && viewAdapter != null) {
            // suggestion view
            mSuggestionViewContainer = nanoView.findViewById(R.id.suggestion_view_container);

            mSuggestionsView = viewAdapter.getSuggestionsView(context);

            if (mSuggestionsView == null) {
                mSuggestionsView = new NRSuggestionsView(context);
            }

            mSuggestionsView.setListener(this);

            if (mSuggestionsView.getParent() != null) {
                ((LinearLayout) mSuggestionsView.getParent()).removeView(mSuggestionsView);
            }

            mSuggestionViewContainer.addView(mSuggestionsView);


            // search bar
            searchBarContainer = nanoView.findViewById(R.id.search_bar_container);


            searchBarView = viewAdapter.getSearchBar(context);

            if (searchBarView == null && viewsProvider != null) {
                searchBarView = new NRSearchBar(context, viewsProvider.getSearchBarLayout());
            }

            searchBarView.setListener(this);

            if (searchBarView.getParent() != null) {
                ((LinearLayout) searchBarView.getParent()).removeView(searchBarView);
            }

            searchBarContainer.addView(searchBarView, new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
        }
    }


    @Override
    public void onStartRecording(ImageButton button) {

    }

    @Override
    public void fetchSuggestionsForText(String text) {
        resetSuggestions = false;
        mFetchedDataManager.searchSuggestion(text);
    }

    @Override
    public void searchForText(String text) {
        resetSuggestions = true;
        clearSuggestionsView();
        mFetchedDataManager.searchText(text);
    }

    @Override
    public void clearAutoComplete() {
        clearSuggestionsView();
        contentMain.setVisibility(View.VISIBLE);
    }

    @Override
    public void onTopBackButtonPressed() {
        BaseInputConnection inputConnection = new BaseInputConnection(getView(), true);
        inputConnection.sendKeyEvent(new KeyEvent(KeyEvent.ACTION_DOWN, KeyEvent.KEYCODE_BACK));
    }

    @Override
    public void onEmptyQuery() {

    }

    @Override
    public void onSelectSuggestion(String suggestion) {
        resetSuggestions = true;
        isFromSuggestion = true;
        hideKeyboard();

        searchBarView.updateText(suggestion);

        resetSuggestions = true;
        mFetchedDataManager.searchText(suggestion);
        clearSuggestionsView();
    }

    private void showSuggestionsView() {
        if (!configuration.getAutocompleteEnabled()) {
            autocompleteEnabled = false;
        }
    }

    @Override
    public void onResultSelected(final int y, NRResultsAdapter.kt.ViewHolder titleViewHolder) {
        if (isBouncing()) {
            return;
        }
        isFromSuggestion = false;
        setLoadingState(true);
        final NRArticleView resultTopView = getTopView();
        final NRResult result = titleViewHolder.getResult();

        if (result.getFetchedResult().getBody() == null) {
            this.articleId = result.getFetchedResult().getId();
            mFetchedDataManager.faqAnswer(result.getFetchedResult().getId(), null, new OnFAQAnswerFetched() {
                @Override
                public void onAnswerFetched(NRQueryResult queryResult) {
                    if (queryResult != null) {
                        updateLabelsParallel(queryResult.getTitle());
                        resultTopView.setVisibility(GONE);
                        contentMain.addView(resultTopView);
                        result.setFetchedResult(queryResult);
                        presentResult(result, y, resultTopView);
                    } else {
                        showConnectionError(TIMEOUT_UPPER_LINE);
                    }
                }
            });
        } else {
            resultTopView.setVisibility(GONE);
            contentMain.addView(resultTopView);
            presentResult(result, y, resultTopView);
        }
    }

    private void presentResult(NRResult result, int y, NRArticleView resultTopView) {

        dismissConnectionError();

        if (getContext() == null) {
            return;
        }

        hideKeyboard();

        setLoadingState(false);

        String title;

        if (result != null && result.getFetchedResult() != null) {
            result.setUnfolded(true);
            resultTopView.setVisibility(View.VISIBLE);
            resultTopView.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left));
            resultTopView.openOpenedView(result);
            title = result.getFetchedResult().getTitle();

        } else {
            resultTopView.showNoResult(result);
            title = getResources().getString(R.string.noResultsTitle);
        }

        if (currentLabel != null && (result == null || (result.getFetchedResult() != null && result.getFetchedResult().getTitle().isEmpty()))) {
            title = currentLabel.getTitle();
        }

        updateLabelsParallel(title);

        requestFocus();
    }

    private void requestFocus() {
        View view = getView();
        if (view != null) {
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

        requestFocus();
        hideKeyboard();

        View.OnKeyListener onKeyListener = new View.OnKeyListener() {
            @Override
            public boolean onKey(View v, int keyCode, KeyEvent event) {

                if (event.getAction() == KeyEvent.ACTION_DOWN) {
                    if (keyCode == KeyEvent.KEYCODE_BACK) {

                        FragmentManager fragmentManager = getFragmentManager();

                        // First categories/results view is presented
                        if (fragmentManager != null && contentMain.getChildCount() == 1 && contentMain.getChildAt(0) instanceof BaseListView) {
                            fragmentManager.beginTransaction().remove(NRMainFragment.this).commitAllowingStateLoss();
                            Activity activity = getActivity();
                            if (activity != null) {
                                ActionBar actionBar = ((AppCompatActivity) activity).getSupportActionBar();
                                if (actionBar != null) {
                                    actionBar.setDisplayShowCustomEnabled(false);
                                }
                            }
                            return true;
                        }

                        // Suggestions view is presented:
                        if (mSuggestionViewContainer.getVisibility() == View.VISIBLE) {
                            resetSuggestions = true;
                            clearSuggestionsView();
                            contentMain.setVisibility(View.VISIBLE);
                            return true;
                        }

                        if (contentMain.getChildCount() > 1) {

                            // When going back to the categories view
                            if (contentMain.getChildCount() == 2) {
                                searchBarView.clearText();
                                searchBarView.adaptSearchBarDisplay(false, null);
                                clearContext();
                            }

                            // get the previous view
                            View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                            view.requestFocus();
                            if (animation) {
                                if (view instanceof NRArticleView) {
                                    if (currentLabel != null) {
                                        view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                        updateLabelsParallel(currentLabel.getTitle());
                                        searchContextView.setVisibility(GONE);
                                        if (currentLabel != null && isFromSuggestion && searchContextValue.split(",").length > 1) {
                                            setToLabelContext();
                                        }

                                    } else if (contentMain.getChildCount() > 2) {
                                        updateContextView(searchContextValue);
                                    } else {
                                        updateLabelsParallel("");
                                    }
                                } else if (view instanceof NRResultsView) {
                                    view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                    searchBarView.adaptSearchBarDisplay(false, null);
                                    searchBarView.clearText();
                                    searchContextView.setVisibility(GONE);

                                }
                                view.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.slide_out_left));
                                removeTopView();

                            } else {
                                // if answer is opened from list, it should be animated
                                if (view instanceof NRArticleView) {// &&
                                    if (!((NRArticleView) view).getResult().isSingle()) { // opened from results lists)
                                        ((NRArticleView) view).setResultUnFoldState(false);
                                        ((NRArticleView) view).removeTopView();

                                        updateSearchBarTextForResultTop(view);

                                    } else {
                                        removeTopView();
                                    }

                                } else {
                                    removeTopView();
                                }
                            }

                            return true;
                        } else {
                            return false;
                        }

                    } else {
                        // if (keyCode == KeyEvent.KEYCODE_BACK)
                        return false;
                    }
                } else {
                    // if (event.getAction() == KeyEvent.ACTION_DOWN)
                    return false;
                }
            }
        };

        View view = getView();
        if (view != null) {
            view.setOnKeyListener(onKeyListener);
        }
    }

    private void removeTopView() {
        dismissConnectionError();

        if (contentMain != null) {
            int oldChildCount = contentMain.getChildCount();

            if (oldChildCount == 2 && currentLabel != null) {
                clearContext();
                currentLabel = null;
            }

            contentMain.removeViewAt(oldChildCount - 1);

            loadCurrentViewAfterRemoval();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = contentMain.getChildAt(contentMain.getChildCount() - 1);

        if (localCurrentView instanceof NRArticleView) {
            updateSearchBarTextForResultTop(localCurrentView);
        } else {

            if (! (localCurrentView != null && contentMain.getChildAt(contentMain.getChildCount() - 1) instanceof NRResultsView)) {
                searchBarView.clearText();
            }

            String title = configuration.getTitleText();

            if (localCurrentView instanceof NRResultsView) {
                if (!isEmpty(((NRResultsView) localCurrentView).getTitle())) {
                    title = ((NRResultsView) localCurrentView).getTitle();
                }
                resultsView.enableAdapterClicks(true);
                currentView = (NRResultsView) localCurrentView;
            }

            if (localCurrentView instanceof NRCategoriesView) {
                categoriesView.enableAdapterClicks(true);
                currentView = (NRCategoriesView) localCurrentView;
            }

            setActionBarTitleText(currentLabel == null ? title : currentLabel.getTitle());
        }

        requestFocus();

        setLoadingState(false);

        if (localCurrentView != null) {
            localCurrentView.setVisibility(View.VISIBLE);
        }
    }

    private void updateSearchBarTextForResultTop(View view) {

        NRArticleView articleView = (NRArticleView) view;

        if (articleView != null) {
            NRResult result = articleView.getResult();
            if (result != null && result.getFetchedResult() instanceof NRAnswer) {
                searchBarView.updateText(result.getFetchedResult().getTitle());
                resetSuggestions = true;
                clearSuggestionsView();
                contentMain.setVisibility(View.VISIBLE);
                requestFocus();
            }
        }
    }

    private void clearSuggestionsView() {
        if (mSuggestionsView != null) {
            mSuggestionsView.setSuggestions(null);
        }

        if (mSuggestionViewContainer != null) {
            mSuggestionViewContainer.setVisibility(GONE);
        }
    }

    private void fadeViews(View view, final float f, long duration, final boolean removeTopTitle) {
        view.animate()
                .alpha(f)
                .setDuration(duration)
                .setListener(new Animator.AnimatorListener() {
                    @Override
                    public void onAnimationStart(Animator animation) {

                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (removeTopTitle) {
                            contentMain.removeViewAt(contentMain.getChildCount() - 1);
                        }
                    }

                    @Override
                    public void onAnimationCancel(Animator animation) {

                    }

                    @Override
                    public void onAnimationRepeat(Animator animation) {

                    }
                });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
        if (beforeGoingDown) {
            animateBGColor(50, contentMain.getChildAt(contentMain.getChildCount() - 1), false, null);

        } else {
            fadeViews(contentMain.getChildAt(contentMain.getChildCount() - 1), 0.0f, 500, true);
        }
    }

    private void animateBGColor(int milliseconds, final View view, final boolean unfold, final NRResultsAdapter.kt.ViewHolder titleViewHolder) {

        int colorFrom = getResources().getColor(R.color.nr_background_color);
        int colorTo = getResources().getColor(R.color.white);

        if (!unfold) {
            colorFrom = Color.WHITE;
            colorTo = getResources().getColor(R.color.nr_background_color);
        }

        ValueAnimator colorAnimation = ValueAnimator.ofObject(new ArgbEvaluator(), colorFrom, colorTo);
        colorAnimation.setDuration(milliseconds); // milliseconds
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {

            @Override
            public void onAnimationUpdate(ValueAnimator animator) {
                view.setBackgroundColor((int) animator.getAnimatedValue());
            }

        });

        colorAnimation.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (unfold) {
//                    titleViewHolder.getTitleView().setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });

        if (unfold) {
            colorAnimation.setStartDelay(300);
        }
        colorAnimation.start();
    }

    @Override
    public void showConnectionError(NRErrorHandler.ErrorType errorType) { // error handler
        switch (errorType) {
            case TIMEOUT_UPPER_LINE:
                setLoadingState(true);
                View view = contentMain.getChildAt(contentMain.getChildCount() - 1);
                if (!(view instanceof NRErrorView)) {
                    noConnectionView.setVisibility(View.VISIBLE);
                    hideKeyboard();
                }

                break;
        }

    }

    @Override
    public void dismissConnectionError() {
        setLoadingState(false);

        if (noConnectionView == null) {
            return;
        }
        noConnectionView.setVisibility(GONE);
    }

    @Override
    public void onLabelSelected(final NRLabel label) {
        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        this.currentLabel = label;

        searchBarView.clearText();

        if (label.getContext().isEmpty()) {
            mFetchedDataManager.fetchLabelFAQ(label);
        } else {
            nanorepInstance.setContext(label.getContext(), new OnDataResponse<DefaultResponse>() {
                @Override
                public void onSuccess(DefaultResponse response) {
                    searchContextValue = label.getContext();
                    mFetchedDataManager.fetchLabelFAQ(label);
                }

                @Override
                public void onError(NRConnectionException error) {
                    showConnectionError(TIMEOUT_UPPER_LINE);
                    widgetListener.onError(NRError.error(TAG, CONNECTION, error.getMessage()));
                }
            });
        }
    }

    private boolean isBouncing() {
        long currentTime = System.currentTimeMillis();
        final long threshold = 300;
        if (currentTime - this.previousClickTime < threshold) {
            return true;
        }
        this.previousClickTime = currentTime;
        return false;
    }

    @Override
    public void onCategorySelected(NRFAQGroupItem groupItem) {

        if (isBouncing()) {
            return;
        }
        setLoadingState(true);
        openNRResultView(NRFetchedDataManager.generateNRResultArray(groupItem.getAnswers(), getContext()), groupItem.getTitle());
    }

    private void openNRResultView(List<NRResult> results, String title) {
        try {

            if (viewsProvider != null) {

                dismissConnectionError();

                hideKeyboard();

                setLoadingState(false);

                resultsView = new NRResultsView(getActivity());

                currentView = resultsView;

                resultsView.setListener(NRMainFragment.this);

                int labelLayout = viewsProvider.getLabelItemTitleLayout();

                resultsView.setResults(results, title, viewAdapter, labelLayout);

                resultsView.setIsAnimated(animation);
                resultsView.enableAdapterClicks(true);

                if (!isEmpty(title)) {
                    setActionBarTitleText(title);
                }

                contentMain.addView(resultsView);
                contentMain.setVisibility(View.VISIBLE);

                if (accountParams.isLabelsMode() && configuration.getLabels() != null) {
                    Animation animation = AnimationUtils.loadAnimation(getContext(), R.anim.slide_in_left);
                    animation.setAnimationListener(new Animation.AnimationListener() {
                        @Override
                        public void onAnimationStart(Animation animation) {
                        }

                        @Override
                        public void onAnimationEnd(Animation animation) {
                            contentMain.getChildAt(contentMain.getChildCount() - 1).setVisibility(View.VISIBLE);
                            if (currentLabel != null) {
                                updateLabelsParallel(currentLabel.getTitle());
                            }
                        }

                        @Override
                        public void onAnimationRepeat(Animation animation) {
                        }
                    });

                    resultsView.startAnimation(animation);
                }

                contentMain.requestFocus();

                requestFocus();
            }
        } catch(Exception e){
            widgetListener.onError(NRError.error(TAG, ARTICLE, getString(R.string.results_view_error)));
        }
    }


    private void setLoadingState(boolean state) {
        if (contentMain.getChildCount() == 0) {
            return;
        }

        if (currentView != null) {
            currentView.setLoading(state);
        }
    }

    public void updateLabelsParallel(String labelTitle) {
        if (labelTitle != null) {
            setActionBarTitleText(labelTitle);
        }
        searchBarView.adaptSearchBarDisplay(true, labelTitle);
    }

    @Override
    public void connectionChanged(boolean isConnected) {
        this.connectionOk = isConnected;
        if (isConnected) {
            dismissConnectionError();
            if (currentView != null) {
                currentView.enableAdapterClicks(true);
            }
        } else {
            showConnectionError(TIMEOUT_UPPER_LINE);
        }
    }

    @Override
    public void onDestroy() {
        connectivityReceiver.unregister(getContext());
        connectivityReceiver = null;
        viewsProvider = null;
        widgetListener = null;
        configuration = null;

        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    @Override
    public void onResume() {
        super.onResume();
        if (fragmentPaused) {
            renewSession();
            fragmentPaused = false;
        }
    }
}*/
