package nanorep.nanowidget.Components

import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.nanorep.nanoclient.model.ContextValue

import nanorep.nanowidget.R

open class ContextSelectionAdapter(private var contextValues: ContextValue?)
    : RecyclerView.Adapter<ContextSelectionAdapter.ViewHolder>() {

    interface ContextHandlerListener {
        fun onContextSelected(adapterPosition: Int)
    }
    private var contextListener: ContextHandlerListener? = null

    open fun setContextListener(contextListener: ContextHandlerListener?) {
        this.contextListener = contextListener
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val context = parent.context
        val view = LayoutInflater.from(context).inflate(R.layout.context_selection_recycler_item, parent, false)

        return ViewHolder(view, contextListener)
    }

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(contextValues)
    }

    override fun getItemCount(): Int {
        if (contextValues?.hasSubContext() == true) {
            return contextValues!!.subContext.size
        }
        return contextValues?.values?.size ?: 0
    }

    class ViewHolder(view: View, private val contextListener: ContextHandlerListener?)
        : RecyclerView.ViewHolder(view) {


        val textView: TextView = view.findViewById<View>(R.id.context_selection_item_textview) as TextView

        init {
            view.setOnClickListener {
                contextListener?.onContextSelected(adapterPosition)
            }
        }

        fun bind(contextValues: ContextValue?) {

            this.textView.text = if (contextValues?.hasSubContext() == true)
                contextValues.subContext[adapterPosition].parentContextValue
            else
                contextValues?.values?.get(adapterPosition)?: ""
        }
    }

    fun setContextList(contextValues: ContextValue?) {
        this.contextValues = contextValues
    }
}