package nanorep.nanowidget.adapters

import android.graphics.drawable.BitmapDrawable
import android.support.v7.widget.RecyclerView
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.nanorep.nanoclient.Nanorep
import com.nanorep.nanoclient.model.NRResult
import com.nanorep.nanoclient.model.ResultResponse
import com.nanorep.nanoclient.model.SupportLabel
import nanorep.nanowidget.R


abstract class ResultsBaseViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {

    private var onClick: (()->Unit?)? = null

    init {
        itemView.setOnClickListener{
            onClick?.invoke()
        }
    }

    open fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        this.onClick = onClick
    }

    open fun clear(){}

    fun loadImage(imageView: ImageView, url: String?) {
        if (url == null || url.isEmpty()) {
            return
        }
        Nanorep.getInstance().widgetListener.onCachedImageRequest(url) { bitmap ->
            if (bitmap != null) {
                imageView.setImageBitmap(bitmap)
            }
        }
    }

}

class LabelViewHolder(itemView: View) : ResultsBaseViewHolder(itemView) {

    private val imageView: ImageView = itemView.findViewById(R.id.label_image)
    private val textView: TextView = itemView.findViewById(R.id.titleTextView)

    override fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        super.bind(listItem, onClick)
        (listItem as? SupportLabel)?.run {
            //loadImage(imageView, icons?.getIconUrl())
            bitmap?.run { imageView.setImageDrawable(BitmapDrawable(itemView.resources, this)) }
            textView.text = name
        }
    }

    override fun clear() {
        imageView.setImageDrawable(null)
    }
}

class FaqViewHolder(view: View) : ResultsBaseViewHolder(view) {

    var textView: TextView = view.findViewById(R.id.titleTextView)

    override fun bind(listItem: ResultResponse, onClick: () -> Unit?) {
        super.bind(listItem, onClick)
        (listItem as? NRResult)?.run {
            textView.text = fetchedResult.title
        }
    }
}