package nanorep.nanowidget.Components.formSDK.model;

import android.util.Log;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

import nanorep.nanowidget.Components.formSDK.Interactions.FormInputDataRecyclerInteraction;

import static nanorep.nanowidget.Components.formSDK.model.FormFieldType.CHECKBOX_LIST;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.CHECK_BOX_LIST;
import static nanorep.nanowidget.Components.formSDK.model.NRFormStructure.GENERIC;

/**
 * Created by Oz on 8/20/2017.
 */

public class NRFormInputData {

    private static String VALUES = "values";
    private static String POST_URL = "postUrl";
    private static String REDIRECT_PARAM = "redirectParam";

    private List<UserInput> userInputs;
    private String postUrl;
    private String redirectParam;
    private NRForm form;
    private JSONObject formUserInputs;
    private FormInputDataRecyclerInteraction setErrorOnFieldHandler;

    public NRFormInputData(NRForm form, FormInputDataRecyclerInteraction setErrorOnFieldHandler) {
        postUrl = "http://example.com";
        redirectParam = null;
        userInputs = new ArrayList<>();
        this.form = form;
        this.setErrorOnFieldHandler = setErrorOnFieldHandler;
    }

    public void integrateFieldsInputsToForm() {
        for (FormFields formField : form.getStructure().getFields()) {
            if (formField.getInputType() == CHECKBOX_LIST && formField.isChecked()) {
                String selectedCheckboxes = "";
                for (SelectionOptions option : formField.getSelectionOptions()) {
                    if (option.isSelected()) {
                        selectedCheckboxes += option.getText() + ",";
                    }
                }
                userInputs.add(new UserInput(formField.getFieldLabel(), CHECK_BOX_LIST, selectedCheckboxes.substring(0, selectedCheckboxes.lastIndexOf(',')), GENERIC));
            } else {
                userInputs.add(formField.getUserInputs());
            }
        }
    }

    public boolean formValidation() {
        List<FormFields> formFields = form.getStructure().getFields();
        for (int i = 0; i < formFields.size(); i++) {
            if (formFields.get(i).isRequired() && (!formFields.get(i).isChecked() || !formFields.get(i).isValid())) {
                setErrorOnFieldHandler.scrollToInvalidatedFieldAndSetError(i);
                return false;
            }

        }
        return true;
    }


    public JSONObject generateFormUserInputsJSON() {
        formUserInputs = new JSONObject();

        Gson gson = new Gson();

        String listString = gson.toJson(
                form.getNRformInputData().userInputs,
                new TypeToken<ArrayList<UserInput>>() {
                }.getType());

        JSONArray jsonArray = null;

        try {
            jsonArray = new JSONArray(listString);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        try {
            formUserInputs.put(VALUES, jsonArray);
            formUserInputs.put(POST_URL, postUrl);
            formUserInputs.put(REDIRECT_PARAM, String.valueOf(redirectParam));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return formUserInputs;
    }

    @Override
    public String toString() {
        return userInputs.toString();
    }

    public String formInputData() {
        return generateFormUserInputsJSON().toString();
    }
}
