package nanorep.nanowidget.Components.ChannelPresenters;

import android.content.Context;
import android.content.Intent;

import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingCustomScript;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Connection.NRUtilities;
import com.nanorep.nanoclient.Nanorep;
import nanorep.nanowidget.DataClass.NRResult;

import org.json.JSONException;
import org.json.JSONObject;

import java.util.Map;

import nanorep.nanowidget.R;

import static com.nanorep.nanoclient.Connection.NRErrorCodes.CHANNEL;

/**
 * Created by noat on 16/11/2016.
 */

public class NRCustomScriptChannelPresenter implements NRChannelPresenter {

    private static String TAG = NRCustomScriptChannelPresenter.class.getName();

    private Context mContext;
    private NRChanneling mChanneling;
    private String to;
    private String subject;
    private Nanorep.ErrorListener errorListener;

    public NRCustomScriptChannelPresenter(Context context, Nanorep.ErrorListener errorListener) {
        mContext = context;
        this.errorListener = errorListener;
    }

    @Override
    public void present() {

        parseJson();

        Intent i = new Intent(Intent.ACTION_SEND);
        i.setType("message/rfc822");
        i.putExtra(Intent.EXTRA_EMAIL  , new String[]{to});
        i.putExtra(Intent.EXTRA_SUBJECT, subject);
        try {
            mContext.startActivity(Intent.createChooser(i, "Send mail..."));
        } catch (android.content.ActivityNotFoundException ex) {
            errorListener.onError(NRError.error(TAG, CHANNEL, mContext.getString(R.string.email_error)));
        }
    }

    private void parseJson() {
        String jsonString = ((NRChannelingCustomScript) mChanneling).getScriptContent();

        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(jsonString);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        Map<String, Object> map = NRUtilities.mapFromJson(jsonObject);

        subject = (String) map.get("title");
        to = (String) map.get("url");
    }

    @Override
    public void setChannel(NRChanneling channeling) {
        mChanneling = channeling;
    }

    @Override
    public NRResult getResult() {
        return null;
    }

    @Override
    public String getUrl() {
        return ((NRChannelingCustomScript)mChanneling).getScriptContent();
    }
}
