package nanorep.nanowidget.Components.AbstractViews;

import android.content.Context;
import android.widget.EditText;
import android.widget.LinearLayout;

import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.NRSearchBarListener;

/**
 * Created by nanorep on 29/09/2016.
 */

public abstract class NRCustomSearchBarView extends LinearLayout{

    protected NRSearchBarListener mListener;
    protected EditText mSearchEditText;

    public NRCustomSearchBarView(Context context) {
        super(context);
    }

    public void setListener(NRSearchBarListener listener) {
        mListener = listener;
    }

    public abstract String getSearchQuery();

    public abstract void updateText(String text, boolean presentSuggestions);

    public abstract void clearText();

    public abstract void presentSuggestions(boolean present);

    public abstract void setHint(String text);

    public abstract void setViewsProvider(SearchViewsProvider viewsProvider);

    public abstract void adaptSearchBarDisplay(boolean displayLabel, String labelOrSearchText, boolean force);
}
