package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.text.Spannable;
import android.view.LayoutInflater;
import android.view.View;

import java.util.ArrayList;

import nanorep.nanowidget.Components.AbstractViews.NRCustomSuggestionsView;
import nanorep.nanowidget.R;

/**
 * Created by nissimpardo on 07/06/16.
 */
public class NRSuggestionsView extends NRCustomSuggestionsView {

    public NRSuggestionsView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.suggestion_view, this);
    }


    public void setSuggestions(ArrayList<Spannable> suggestions) {
        mSuggestions = suggestions;
        mAdapter.notifyDataSetChanged();
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        mRecyclerView = child.findViewById(R.id.recyclerSuggestions);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        mAdapter = new SuggestionsAdapter();
        mRecyclerView.setAdapter(mAdapter);
    }


}
