package nanorep.nanowidget.Components;

import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.List;

import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.DataClass.NRResultsAdapter;
import nanorep.nanowidget.R;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;


/**
 * Created by noat on 08/11/2016.
 */

public class NRResultsView extends BaseListView implements NRResultsAdapter.Listener{
    private RecyclerView mResultsRecyclerView;
    private NRResultsAdapter adapter;
    private Listener listener;
    private boolean isAnimated;
    private String title;
    private ProgressBar loadingView;
    private TextView faqTitle;

    private RelativeLayout frequentlyQuestions;
    private TextView frequentlyQuestionsTv;

    public void setIsAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public boolean isAnimated() {
        return isAnimated;
    }

    public void setAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
    }

    public interface Listener{
        void onResultSelected(int y, NRResultsAdapter.ViewHolder titleViewHolder);
    }

    public NRResultsView(Context context) {
        super(context);
        LayoutInflater.from(context).inflate(R.layout.results_view, this);
    }

    @Override
    public void enableAdapterClicks(boolean enable) {
        if (adapter != null) {
            adapter.setEnabledViewHolderClicks(enable);
        }
    }

    @Override
    public void setLoading(boolean loading) {
        loadingView.setVisibility(loading ? VISIBLE : INVISIBLE);
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);

        adapter = new NRResultsAdapter();
        mResultsRecyclerView = child.findViewById(R.id.resultsListRecycler);
        faqTitle = child.findViewById(R.id.faqTitle);
        mResultsRecyclerView.addItemDecoration(new SimpleDividerItemDecoration(getContext(), getResources(), SimpleDividerItemDecoration.PAGE_RESULTS));
        mResultsRecyclerView.setLayoutManager(new LinearLayoutManager(this.getContext()));
        mResultsRecyclerView.setAdapter(adapter);

        loadingView = child.findViewById(R.id.loading_view);
        faqTitle.setVisibility(VISIBLE);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setResults(List<NRResult> results, String title, NRCustomViewAdapter viewAdapter, int labelItemTitleLayout)  {

//        if(!NR1MainFragment.isEmpty(title)) {
//            frequentlyQuestions.setVisibility(View.VISIBLE);
//            frequentlyQuestionsTv.setText(title);
//        }

        this.title = title;

        adapter.setTitleItemLabelView(labelItemTitleLayout);
        adapter.setListener(this);
        adapter.setViewAdapter(viewAdapter);
        adapter.addItems(results);
    }

    public String getTitle() {
        return title;
    }

    @Override
    public void onResultItemSelected(NRResultsAdapter.ViewHolder titleViewHolder, int pos) {
        listener.onResultSelected(0, titleViewHolder);
    }

}
