/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.TextView;
import com.nanorep.nanoclient.Connection.NRConnection;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.model.DefaultResponse;
import com.nanorep.nanoclient.model.NRLabel;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nanorep.nanowidget.Components.ContextSelectionAdapter;
import nanorep.nanowidget.DataClass.ContextSelectionHandler;
import nanorep.nanowidget.DataClass.NRConfigFetcherListener;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRFetcherListener;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.R;
import org.jetbrains.annotations.NotNull;

public class NanorepUI {
    public static String NoResults = "noResults";
    private String TAG = this.getClass().getName();
    private NRFetchedDataManager dataManager;
    private List<NRResult> faqs;
    private HashMap<String, NRResult> articlesStack = new HashMap();
    private NRLabel label;
    private Context context;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private AlertDialog contextSelectionDialog;
    private NRFetcherListener fetcherListener;
    private String searchContextValue;
    private DataManagerErrorListener dataManagerErrorListener;
    private Nanorep nanorepInstance;
    private static NanorepUI instance;

    public void setContext(Context context) {
        this.context = context;
        this.nanorepInstance = Nanorep.getInstance();
    }

    public void setDataManagerErrorListener(DataManagerErrorListener dataManagerErrorListener) {
        this.dataManagerErrorListener = dataManagerErrorListener;
    }

    public void clearInstance() {
        this.context = null;
        instance = null;
    }

    public void initDataManager(final DataManagerErrorListener dataManagerErrorListener) {
        if (this.context != null) {
            this.dataManager = new NRFetchedDataManager(this.context, new NRConfigFetcherListener(){

                @Override
                @RequiresApi(api=21)
                public void onConfigurationReady() {
                }

                @Override
                public void insertRows(ArrayList<NRFAQGroupItem> groups) {
                }

                @Override
                public void onError(NRError error) {
                    if (dataManagerErrorListener != null) {
                        dataManagerErrorListener.onError(error);
                    }
                    if (NanorepUI.this.widgetListener == null && NanorepUI.this.nanorepInstance != null) {
                        NanorepUI.this.widgetListener = NanorepUI.this.nanorepInstance.getWidgetListener();
                    }
                    if (NanorepUI.this.widgetListener != null) {
                        NanorepUI.this.widgetListener.onError(error);
                    }
                }

                @Override
                public void noResultFound(NRResult result, String searchContext) {
                    ArrayList<NRResult> results = new ArrayList<NRResult>();
                    results.add(result);
                    NanorepUI.this.dataManager.getFetcherListener().insertRows(results, searchContext);
                    if (NanorepUI.this.searchContextValue == null) {
                        NanorepUI.this.clearContextFromSession();
                    }
                }

                @Override
                public void showContextSelectionDialog(ContextValue contextValues) {
                    NanorepUI.this.presentContextDialog(contextValues);
                }
            });
        }
    }

    public void setSearchContextValue(String searchContextValue) {
        this.searchContextValue = searchContextValue;
    }

    public String getSearchContextValue() {
        return this.searchContextValue;
    }

    public static NanorepUI getInstance() {
        if (instance == null) {
            instance = new NanorepUI();
        }
        return instance;
    }

    public NRFetchedDataManager getDataManager(NRFetcherListener fetcherListener) {
        this.fetcherListener = fetcherListener;
        this.dataManager.setFetcherListener(fetcherListener);
        return this.dataManager;
    }

    public NRFetchedDataManager getDataManager() {
        return this.dataManager;
    }

    public List<NRResult> getResults() {
        return this.faqs;
    }

    public void setResults(List<NRResult> faqs) {
        this.faqs = faqs;
    }

    public void addToArticleStuck(NRResult result) {
        if (result != null && result.getFetchedResult() != null) {
            this.articlesStack.put(result.getFetchedResult().getId(), result);
        } else {
            this.articlesStack.put(NoResults, result);
        }
        Log.d((String)"", (String)"");
    }

    public void removeFromArticleStack(String resultID) {
        this.articlesStack.remove(resultID);
    }

    public NRResult getFromArticleStack(String resultID) {
        return this.articlesStack.get(resultID);
    }

    public void setLabel(NRLabel label) {
        this.label = label;
    }

    public void updateLabelContext() {
        if (this.label != null) {
            this.updateSessionContext(this.label.getContext());
        }
    }

    public void clearCurrentLabel() {
        this.label = null;
        this.clearAllContexts();
    }

    public NRLabel getLabel() {
        return this.label;
    }

    private void presentContextDialog(ContextValue contextValues) {
        if (this.context != null) {
            View contextSelectionDialogView = LayoutInflater.from((Context)this.context).inflate(R.layout.context_selection_dialog, null);
            final TextView contextTitle = (TextView)contextSelectionDialogView.findViewById(R.id.context_selection_title);
            final Button cancelButton = (Button)contextSelectionDialogView.findViewById(R.id.cancelButton);
            RecyclerView recycler = (RecyclerView)contextSelectionDialogView.findViewById(R.id.context_selection_recycler);
            recycler.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(contextSelectionDialogView.getContext()));
            recycler.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(contextSelectionDialogView.getContext(), 1));
            final ContextSelectionAdapter adapter = new ContextSelectionAdapter(contextValues);
            ContextSelectionHandler contextSelectionHandler = new ContextSelectionHandler(contextValues, new ContextSelectionHandler.ContextSelectionListener(){

                @Override
                public void updateContextData(@NotNull ContextValue contextValues) {
                    contextTitle.setText(R.string.contextDialogTitle);
                    contextTitle.append((CharSequence)(" " + contextValues.getContextKey()));
                    adapter.setContextList(contextValues);
                    adapter.notifyDataSetChanged();
                }

                @Override
                public void onContextSelected(@NonNull String searchContext) {
                    NanorepUI.this.dataManager.presentResultsForSelectedContext(searchContext);
                    NanorepUI.this.contextSelectionDialog.dismiss();
                }
            });
            adapter.setContextListener(contextSelectionHandler);
            recycler.setAdapter((RecyclerView.Adapter)adapter);
            cancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    NanorepUI.this.fetcherListener.onContextDialogCanceled();
                    NanorepUI.this.contextSelectionDialog.dismiss();
                }
            });
            contextTitle.setText(R.string.contextDialogTitle);
            contextTitle.append((CharSequence)(" " + contextValues.getContextKey()));
            AlertDialog.Builder builder = new AlertDialog.Builder(contextSelectionDialogView.getContext());
            this.contextSelectionDialog = builder.setView(contextSelectionDialogView).create();
            this.contextSelectionDialog.setCanceledOnTouchOutside(false);
            this.contextSelectionDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

                public boolean onKey(DialogInterface arg0, int keyCode, KeyEvent event) {
                    if (keyCode == 4) {
                        cancelButton.callOnClick();
                        return true;
                    }
                    return true;
                }
            });
            this.contextSelectionDialog.show();
        }
    }

    public void hideKeyboard(View view) {
        InputMethodManager imm;
        Context context;
        if (view != null && (context = view.getContext()) != null && (imm = (InputMethodManager)context.getSystemService("input_method")) != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void updateDynamicContextValue(String updatedContext) {
        if ((updatedContext == null || updatedContext.isEmpty()) && this.label != null) {
            this.updateSessionContext(this.label.getContext());
        } else if (updatedContext != null && !updatedContext.equals(this.searchContextValue)) {
            StringBuilder builder = new StringBuilder();
            if (this.label != null && !this.label.getContext().equals(updatedContext)) {
                updatedContext = this.label.getContext() + ',' + updatedContext;
            }
            for (String context : updatedContext.split(",")) {
                String[] ctx = context.split(":");
                if (ctx.length != 2) {
                    return;
                }
                if (builder.length() > 0) {
                    builder.append(", ");
                }
                builder.append(ctx[1]);
            }
            this.setSearchContextValue(builder.toString());
        } else {
            this.setSearchContextValue(updatedContext);
        }
    }

    private void updateSessionContext(final String sessionContext) {
        this.nanorepInstance.setContext(null, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                NanorepUI.this.setSearchContextValue(null);
                Log.d((String)"ContextLog", (String)"Context cleared successfully");
                NanorepUI.this.dataManager.clearSearchContext();
                NanorepUI.this.searchContextValue = null;
                if (sessionContext != null) {
                    NanorepUI.this.nanorepInstance.setContext(sessionContext, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

                        public void onSuccess(DefaultResponse response) {
                            NanorepUI.this.searchContextValue = sessionContext;
                            Log.d((String)"ContextLog", (String)"Context has been updated successfully");
                        }

                        public void onError(NRConnectionException error) {
                            if (NanorepUI.this.widgetListener != null) {
                                NanorepUI.this.widgetListener.onError(NRError.error((String)NanorepUI.this.TAG, (int)1, (String)"Error on update Context"));
                            }
                        }
                    });
                }
            }

            public void onError(NRConnectionException error) {
                if (NanorepUI.this.widgetListener != null) {
                    NanorepUI.this.widgetListener.onError(NRError.error((String)NanorepUI.this.TAG, (int)1, (String)"Error on clearing Context"));
                }
            }
        });
    }

    public void clearAllContexts() {
        if (this.searchContextValue != null || this.label != null) {
            this.searchContextValue = null;
            this.label = null;
            this.clearContextFromSession();
        }
    }

    private void clearContextFromSession() {
        this.nanorepInstance.setContext(null, (OnDataResponse)new OnDataResponse<DefaultResponse>(){

            public void onSuccess(DefaultResponse response) {
                NanorepUI.this.setSearchContextValue(null);
                Log.d((String)"ContextLog", (String)"Context cleared successfully");
            }

            public void onError(NRConnectionException error) {
                if (NanorepUI.this.widgetListener != null) {
                    NanorepUI.this.widgetListener.onError(NRError.error((String)NanorepUI.this.TAG, (int)1, (String)"Error on update Context"));
                }
            }
        });
    }

    public void prepareDataSource(final DataListener dataListener) {
        if (this.nanorepInstance.getAccountParams().isLabelsMode() && this.nanorepInstance.getNRConfiguration().getLabels() != null) {
            dataListener.insertRows(null);
            return;
        }
        NRConnection.Listener listener = new NRConnection.Listener(){

            public void response(Object responseParam, int status, NRError error) {
                if (error != null) {
                    dataListener.onError(error);
                } else {
                    ArrayList<NRFAQGroupItem> groups = new ArrayList<NRFAQGroupItem>();
                    if (responseParam instanceof HashMap) {
                        HashMap map = (HashMap)responseParam;
                        NRFAQGroupItem group = new NRFAQGroupItem(map);
                        groups.add(group);
                        dataListener.insertRows(groups);
                    }
                }
            }

            public void log(String tag, String msg) {
            }
        };
        this.nanorepInstance.updateFaqList(null, this.nanorepInstance.getAccountParams().getContext(), listener);
    }

    public static interface FaqsListener {
        public void onFaqsFetched(ArrayList<NRFAQGroupItem> var1);
    }

    public static interface DataListener
    extends DataManagerErrorListener {
        public void insertRows(ArrayList<NRFAQGroupItem> var1);
    }

    public static interface DataManagerErrorListener {
        public void onError(NRError var1);
    }
}

