/*
 * Decompiled with CFR 0.152.
 */
package nanorep.nanowidget.Fragments;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import com.google.gson.Gson;
import com.nanorep.nanoclient.AccountParams;
import com.nanorep.nanoclient.Channeling.NRChanneling;
import com.nanorep.nanoclient.Channeling.NRChannelingPhoneNumber;
import com.nanorep.nanoclient.Connection.NRError;
import com.nanorep.nanoclient.Handlers.NRErrorHandler;
import com.nanorep.nanoclient.Interfaces.NRExtraDataListener;
import com.nanorep.nanoclient.Interfaces.NRQueryResult;
import com.nanorep.nanoclient.Nanorep;
import com.nanorep.nanoclient.RequestParams.NRLikeType;
import com.nanorep.nanoclient.Response.NRConfiguration;
import com.nanorep.nanoclient.Response.NRFAQGroupItem;
import com.nanorep.nanoclient.exception.NRConnectionException;
import com.nanorep.nanoclient.model.ConfirmationDialogsTextProvider;
import com.nanorep.nanoclient.model.ContextValue;
import com.nanorep.nanoclient.network.OnDataResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nanorep.nanowidget.Components.AbstractViews.NRCustomChannelView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomContentView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomFeedbackView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomLikeView;
import nanorep.nanowidget.Components.AbstractViews.NRCustomTitleView;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.DislikeConfiguration;
import nanorep.nanowidget.Components.AbstractViews.dislikeDialog.NRCustomDislikeDialog;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelPresenter;
import nanorep.nanowidget.Components.ChannelPresenters.NRChannelStrategy;
import nanorep.nanowidget.Components.ChannelPresenters.NRCustomScriptChannelPresenter;
import nanorep.nanowidget.Components.ConfirmationDialogFragment;
import nanorep.nanowidget.Components.NRArticleTitleView;
import nanorep.nanowidget.Components.NRArticleView;
import nanorep.nanowidget.Components.NRChannelItem;
import nanorep.nanowidget.Components.NRChannelingView;
import nanorep.nanowidget.Components.NRContentView;
import nanorep.nanowidget.Components.NRErrorView;
import nanorep.nanowidget.Components.NRLikeViewText;
import nanorep.nanowidget.Components.NRViewAdapter;
import nanorep.nanowidget.DataClass.Calculate;
import nanorep.nanowidget.DataClass.NRConfigFetcherListener;
import nanorep.nanowidget.DataClass.NRFetchedDataManager;
import nanorep.nanowidget.DataClass.NRResult;
import nanorep.nanowidget.Fragments.NRWebContentFragment;
import nanorep.nanowidget.NanorepUI;
import nanorep.nanowidget.R;
import nanorep.nanowidget.SearchInjector;
import nanorep.nanowidget.SearchViewsProvider;
import nanorep.nanowidget.interfaces.DislikeDialogListener;
import nanorep.nanowidget.interfaces.NRCustomViewAdapter;
import nanorep.nanowidget.interfaces.OnFAQAnswerFetched;

public class DeepLinkFragment
extends Fragment
implements NRArticleView.Listener,
NRErrorHandler.Listener,
NRChannelItem.OnChannelSelectedListener,
NRContentView.Listener {
    private FrameLayout contentMain;
    private NRCustomViewAdapter viewAdapter;
    private NRFetchedDataManager mFetchedDataManager;
    private Nanorep.NanoRepWidgetListener widgetListener;
    private NRConfiguration configuration;
    private ConfirmationDialogsTextProvider confirmationDialogsTextProvider;
    private LinearLayout noConnectionView;
    private NRCustomChannelView channelView;
    private String articleId;
    private Map<String, String> articleExtraData = new HashMap<String, String>();
    private SearchViewsProvider viewsProvider;
    private Nanorep nanorepInstance;
    private AccountParams accountParams;
    private FragmentManager fragmentManager;
    private ProgressBar progressBar;
    private NRCustomContentView contentView;
    private String url;
    private NanorepUI nanorepUIInstance;
    private boolean fragmentPaused;
    private ViewGroup container;

    public void setViewsProvider(SearchViewsProvider viewsProvider) {
        this.viewsProvider = viewsProvider;
    }

    public void setArticleId(String articleId) {
        this.articleId = articleId;
    }

    public void setmFetchedDataManager(NRFetchedDataManager mFetchedDataManager) {
        this.mFetchedDataManager = mFetchedDataManager;
    }

    public void setArticleExtraData(Map<String, String> extraData) {
        this.articleExtraData = extraData;
    }

    public static DeepLinkFragment newInstance(String articleId, Nanorep nanorepInstance, deepLinkingServicesProvider servicesProvider) {
        DeepLinkFragment fragment = new DeepLinkFragment();
        if (servicesProvider != null) {
            fragment.viewsProvider = servicesProvider.getSearchViewsProvider();
            fragment.widgetListener = servicesProvider.getWidgetListener();
        }
        fragment.accountParams = nanorepInstance.getAccountParams();
        fragment.articleId = articleId;
        return fragment;
    }

    public static DeepLinkFragment newInstance(@NonNull String articleId, @NonNull AccountParams accountParams, deepLinkingServicesProvider servicesProvider) {
        DeepLinkFragment fragment = new DeepLinkFragment();
        if (servicesProvider != null) {
            fragment.viewsProvider = servicesProvider.getSearchViewsProvider();
            fragment.widgetListener = servicesProvider.getWidgetListener();
        }
        fragment.articleId = articleId;
        fragment.accountParams = accountParams;
        Nanorep.initialize((AccountParams)accountParams);
        return fragment;
    }

    @Deprecated
    public static DeepLinkFragment newInstance(@NonNull String articleId, @NonNull AccountParams accountParams, SearchViewsProvider searchViewsProvider) {
        DeepLinkFragment fragment = new DeepLinkFragment();
        fragment.viewsProvider = searchViewsProvider;
        fragment.articleId = articleId;
        fragment.accountParams = accountParams;
        Nanorep.initialize((AccountParams)accountParams);
        return fragment;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Gson gson = new Gson();
        String accountParamsJson = gson.toJson((Object)this.accountParams);
        outState.putString("articleId", this.articleId);
        outState.putString("url", this.url);
        outState.putString("accountParamsJson", accountParamsJson);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.container = container;
        View view = inflater.inflate(R.layout.fragment_deeplink, container, false);
        if (savedInstanceState != null) {
            String accountParamsJson = savedInstanceState.getString("accountParamsJson");
            Gson gson = new Gson();
            this.accountParams = (AccountParams)gson.fromJson(accountParamsJson, AccountParams.class);
            this.articleId = savedInstanceState.getString("articleId");
            this.url = savedInstanceState.getString("url");
        }
        this.noConnectionView = (LinearLayout)view.findViewById(R.id.deeplink_noConnectionView);
        this.contentMain = (FrameLayout)view.findViewById(R.id.deeplink_content_main);
        this.progressBar = (ProgressBar)view.findViewById(R.id.deeplink_progressBar);
        if (!Nanorep.isInitialized()) {
            Nanorep.initialize((AccountParams)this.accountParams);
        }
        this.nanorepInstance = Nanorep.getInstance();
        this.nanorepInstance.setHttpRequestTimeout(15);
        NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        if (this.widgetListener == null) {
            this.initIndependentWidgetListener(this.configuration != null);
        }
        NanorepUI.getInstance().setContext(this.getContext());
        this.nanorepUIInstance = NanorepUI.getInstance();
        this.setLoadingState(true);
        this.nanorepUIInstance.hideKeyboard(view);
        if (this.viewsProvider != null) {
            Nanorep.getInstance().setSearchViewsProvider((Object)this.viewsProvider);
        } else {
            this.viewsProvider = this.nanorepInstance.getSearchViewsProvider() instanceof SearchViewsProvider ? (SearchViewsProvider)this.nanorepInstance.getSearchViewsProvider() : new SearchInjector.DefaultsInjector().getUiProvider();
        }
        this.viewAdapter = new NRViewAdapter(this.viewsProvider);
        this.fragmentManager = this.getFragmentManager();
        this.nanorepInstance.setWidgetListener(this.widgetListener);
        this.initIndependentDataManager();
        return view;
    }

    private void initIndependentWidgetListener(final boolean hasConfiguration) {
        if (this.nanorepInstance.getNRConfiguration() != null) {
            this.configuration = this.nanorepInstance.getNRConfiguration();
        }
        this.widgetListener = new Nanorep.NanoRepWidgetListener(){

            public void onError(NRError error) {
                Log.e((String)"Widget Error", (String)("error location: " + error.getDomain() + ", error code: " + error.getCode() + ", error description: " + error.getDescription()));
                if (DeepLinkFragment.this.fragmentManager != null) {
                    // empty if block
                }
                if (DeepLinkFragment.this.nanorepInstance != null) {
                    DeepLinkFragment.this.nanorepInstance.clearSession();
                }
            }

            public void personalInfoWithExtraData(String channelDescription, String predefinedExtraData, NRExtraDataListener listener) {
                if (DeepLinkFragment.this.articleExtraData != null) {
                    listener.onExtraData(DeepLinkFragment.this.articleExtraData);
                }
            }

            public void onSubmitSupportForm(String formData, ArrayList<String> fileUploadPaths) {
                if (formData != null) {
                    Log.i((String)"formData", (String)formData);
                } else {
                    this.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)8, (String)DeepLinkFragment.this.getString(R.string.null_form_result)));
                }
                if (fileUploadPaths != null) {
                    Log.i((String)"filesToUpload", (String)fileUploadPaths.toString());
                } else {
                    this.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)8, (String)DeepLinkFragment.this.getString(R.string.null_form_result)));
                }
            }

            public void onConfigurationFetched() {
                if (!hasConfiguration && DeepLinkFragment.this.getActivity() != null) {
                    DeepLinkFragment.this.configuration = DeepLinkFragment.this.nanorepInstance.getNRConfiguration();
                    DeepLinkFragment.this.fetchAnswer();
                }
            }

            public void onCachedImageRequest(String url, Nanorep.NRCachedImageResponder responder) {
            }

            public void onInitializationFailure() {
                Log.e((String)"Widget Error", (String)DeepLinkFragment.this.getString(R.string.initialization_failure));
            }

            public void onEmptyDataResponse() {
                Log.d((String)"Widget Error", (String)DeepLinkFragment.this.getString(R.string.empty_data_response));
            }

            public void onChannel(NRChanneling.NRChannelingType channelingType, Object extraData) {
                switch (channelingType) {
                    case PhoneNumber: {
                        Intent intent = new Intent("android.intent.action.DIAL", Uri.fromParts((String)"tel", (String)((String)extraData), null));
                        intent.setFlags(0x10008000);
                        try {
                            DeepLinkFragment.this.startActivity(intent);
                            break;
                        }
                        catch (ActivityNotFoundException e) {
                            Log.d((String)"dialerError", (String)DeepLinkFragment.this.getString(R.string.dialer_error));
                        }
                    }
                }
            }
        };
    }

    private NRArticleView getTopView() {
        Context context = this.getContext();
        if (context != null) {
            NRArticleView resultTopView = new NRArticleView(context, this.viewsProvider);
            resultTopView.setListener(this);
            NRCustomTitleView titleView = this.viewAdapter.getTitleView(context);
            if (titleView == null) {
                titleView = new NRArticleTitleView(context, this.viewsProvider);
            }
            ((NRArticleTitleView)titleView).configViewObjects(this.configuration);
            this.contentView = this.viewAdapter.getContentView(context);
            if (this.contentView == null) {
                this.contentView = new NRContentView(context);
            }
            this.contentView.setListener(this);
            NRCustomLikeView likeView = this.viewAdapter.getLikeView(context);
            if (likeView == null) {
                likeView = new NRLikeViewText(context, this.viewsProvider);
            }
            this.channelView = this.viewAdapter.getChannelView(context);
            if (this.channelView == null) {
                this.channelView = new NRChannelingView(context, this.viewsProvider);
            }
            NRCustomFeedbackView feedbackView = this.viewAdapter.getFeedbackView(context);
            resultTopView.setTitleView(titleView);
            resultTopView.setContentView(this.contentView, this);
            if (feedbackView != null) {
                feedbackView.setCustomChannelView(this.channelView);
                feedbackView.setCustomLikeView(likeView);
                resultTopView.setLikeView(feedbackView.getCustomLikeView());
                resultTopView.setChannelView(feedbackView.getCustomChannelView(), this);
                resultTopView.setFeedbackView(feedbackView);
            } else {
                resultTopView.setLikeView(likeView);
                resultTopView.setChannelView(this.channelView, this);
            }
            return resultTopView;
        }
        return null;
    }

    private void initIndependentDataManager() {
        this.mFetchedDataManager = new NRFetchedDataManager(this.getContext(), new NRConfigFetcherListener(){

            @Override
            public void onConfigurationReady() {
                Log.d((String)"", (String)"");
            }

            @Override
            public void insertRows(ArrayList<NRFAQGroupItem> groups) {
            }

            @Override
            public void onError(NRError error) {
                DeepLinkFragment.this.widgetListener.onError(error);
            }

            @Override
            public void noResultFound(NRResult response, String searchContext) {
            }

            @Override
            public void showContextSelectionDialog(ContextValue contextValues) {
            }
        });
        if (this.configuration != null && this.getActivity() != null) {
            this.fetchAnswer();
        }
    }

    public void fetchAnswer() {
        if (this.configuration != null) {
            this.confirmationDialogsTextProvider = this.configuration.getConfirmationDialogsText(this.getContext());
        }
        this.mFetchedDataManager.faqAnswer(this.articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult queryResult) {
                DeepLinkFragment.this.setLoadingState(false);
                NRResult deepLinkingResult = new NRResult(queryResult, null);
                NRArticleView resultTopView = DeepLinkFragment.this.getTopView();
                if (resultTopView != null) {
                    resultTopView.setResult(deepLinkingResult);
                    DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                    resultTopView.openOpenedView(deepLinkingResult);
                    DeepLinkFragment.this.contentMain.requestFocus();
                    if (DeepLinkFragment.this.url != null) {
                        DeepLinkFragment.this.onLinkClicked(DeepLinkFragment.this.url);
                    }
                }
            }
        });
    }

    @Override
    public void onFoldItemFinished(boolean beforeGoingDown) {
    }

    @Override
    public void fetchBodyForResult(final NRCustomContentView view, String resultID, Integer resultHash) {
        if (this.getActivity() != null) {
            this.articleId = resultID;
            this.mFetchedDataManager.faqAnswer(resultID, resultHash, new OnFAQAnswerFetched(){

                @Override
                public void onAnswerFetched(NRQueryResult result) {
                    view.loadData(result.getBody(), "text/html", "UTF-8");
                }
            });
        }
    }

    @Override
    public void closeAnswer() {
        NRArticleView articleView;
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView && !(articleView = (NRArticleView)view).getResult().isSingle()) {
            articleView.setResultUnFoldState(false);
            articleView.removeTopView();
        }
        this.contentMain.removeView(view);
    }

    @Override
    public void onLikeClicked(NRArticleView view, final NRCustomLikeView likeView, String resultId, boolean isLike) {
        NRQueryResult fetchedResult;
        NRResult result = view.getResult();
        if (result != null && (fetchedResult = result.getFetchedResult()) != null) {
            if (isLike) {
                fetchedResult.setLikeState(NRQueryResult.LikeState.positive);
                this.mFetchedDataManager.sendLike(NRLikeType.POSITIVE, "", result.getFetchedResult(), new Nanorep.OnLikeSentListener(){

                    public void onLikeSent(boolean success) {
                        if (!success) {
                            fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                            DeepLinkFragment.this.widgetListener.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)5, (String)DeepLinkFragment.this.getString(R.string.feedback_error_message)));
                            likeView.resetLikeView();
                        } else if (DeepLinkFragment.this.getActivity() != null && DeepLinkFragment.this.viewsProvider != null) {
                            View view = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                            if (DeepLinkFragment.this.viewsProvider != null && DeepLinkFragment.this.viewsProvider.showFeedbackConfirmationDialogs()) {
                                ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), false, view, DeepLinkFragment.this.confirmationDialogsTextProvider);
                                confirmationDialogFragment.show();
                            }
                        }
                    }
                });
            } else if (likeView.shouldOpenDialog()) {
                this.openDislikeDialog(fetchedResult, view, likeView);
            } else {
                this.onDislike(fetchedResult, likeView, NRLikeType.INCORRECT_ANSWER, "");
            }
        }
    }

    private void openDislikeDialog(final NRQueryResult fetchedResult, NRArticleView view, final NRCustomLikeView likeView) {
        int dialogType = this.configuration.getFeedbackDialogType();
        if (this.viewsProvider != null && dialogType != -1) {
            NRCustomDislikeDialog dislikeDialog = this.viewsProvider.getDislikeDialog(new DislikeConfiguration(this.configuration){

                @Override
                public DislikeDialogListener getDislikeDialogListener() {
                    return new DislikeDialogListener(){

                        @Override
                        public void onCancel() {
                            likeView.resetLikeView();
                            DeepLinkFragment.this.onDismissDislike();
                        }

                        @Override
                        public void onDislike(NRLikeType type, String feedbackText) {
                            DeepLinkFragment.this.onDislike(fetchedResult, likeView, type, feedbackText);
                        }
                    };
                }
            });
            if (this.fragmentManager != null) {
                dislikeDialog.show(this.fragmentManager, NRCustomDislikeDialog.TAG);
            }
        }
    }

    private void onDismissDislike() {
        this.nanorepInstance.updateDislikeChanneling(this.articleId, false, (OnDataResponse)new OnDataResponse<List<NRChanneling>>(){

            public void onSuccess(List<NRChanneling> response) {
                View view = DeepLinkFragment.this.contentMain.getChildAt(DeepLinkFragment.this.contentMain.getChildCount() - 1);
                if (view instanceof NRArticleView) {
                    NRQueryResult fetchedResult = ((NRArticleView)view).getResult().getFetchedResult();
                    for (NRChanneling channel : response) {
                        channel.setQueryResult(fetchedResult);
                    }
                }
                DeepLinkFragment.this.channelView.setVisibility(0);
                DeepLinkFragment.this.channelView.setChanneling(response);
            }

            public void onError(NRConnectionException error) {
                DeepLinkFragment.this.widgetListener.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)1, (String)(DeepLinkFragment.this.getString(R.string.update_channeling_error) + error.getData())));
                DeepLinkFragment.this.channelView.setVisibility(8);
            }
        });
    }

    private void onDislike(final NRQueryResult fetchedResult, final NRCustomLikeView likeView, NRLikeType type, String feedbackText) {
        fetchedResult.setLikeState(NRQueryResult.LikeState.negative);
        this.mFetchedDataManager.sendLike(type, feedbackText, fetchedResult, new Nanorep.OnLikeSentListener(){

            public void onLikeSent(boolean success) {
                if (!success) {
                    fetchedResult.setLikeState(NRQueryResult.LikeState.notSelected);
                    likeView.resetLikeView();
                    DeepLinkFragment.this.widgetListener.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)5, (String)DeepLinkFragment.this.getString(R.string.feedback_error_message)));
                } else if (DeepLinkFragment.this.getActivity() != null) {
                    View view = DeepLinkFragment.this.getActivity().getLayoutInflater().inflate(R.layout.confirmation_dialog, null);
                    ConfirmationDialogFragment confirmationDialogFragment = new ConfirmationDialogFragment(DeepLinkFragment.this.getContext(), false, view, DeepLinkFragment.this.confirmationDialogsTextProvider);
                    confirmationDialogFragment.show();
                }
            }
        });
    }

    public void showConnectionError(NRErrorHandler.ErrorType errorType) {
        switch (errorType) {
            case TIMEOUT_UPPER_LINE: {
                View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
                if (view instanceof NRErrorView) break;
                this.noConnectionView.setVisibility(0);
            }
        }
    }

    public void dismissConnectionError() {
        if (this.noConnectionView == null) {
            return;
        }
        this.noConnectionView.setVisibility(8);
    }

    @Override
    public void onChannelSelected(final NRChanneling channel) {
        NRQueryResult currentResult = this.getCurrentResult();
        final String predefinedExtraData = currentResult == null || currentResult.getExtraData() == null ? channel.getNoResultExtra() : this.getCurrentResult().getExtraData();
        this.widgetListener.personalInfoWithExtraData(channel.getChannelDescription(), predefinedExtraData, new NRExtraDataListener(){

            public void onExtraData(Map<String, String> extraData) {
                channel.setExtraData(extraData, predefinedExtraData);
                DeepLinkFragment.this.openChannel(channel);
            }
        });
    }

    private void openChannel(NRChanneling channeling) {
        NRChannelPresenter presenter = NRChannelStrategy.presenter(this.getContext(), channeling, this.nanorepInstance);
        if (presenter instanceof NRCustomScriptChannelPresenter) {
            presenter.present();
        } else {
            String url = presenter.getUrl();
            View view = this.getView();
            if (url != null && this.container != null && view != null && this.fragmentManager != null && this.viewsProvider != null) {
                this.setLoadingState(true);
                final NRWebContentFragment fragment = NRWebContentFragment.newInstance(url, channeling, this.viewsProvider, this.widgetListener);
                fragment.setConfirmationDialogsTextProvider(this.configuration.getConfirmationDialogsText(this.getContext()));
                fragment.setListener(new NRWebContentFragment.WebFormListener(){

                    @Override
                    public void onDismiss(String result) {
                        if (result == null) {
                            DeepLinkFragment.this.widgetListener.onError(NRError.error((String)NRCustomDislikeDialog.TAG, (int)8, (String)DeepLinkFragment.this.getString(R.string.null_form_result)));
                        }
                        DeepLinkFragment.this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).remove((Fragment)fragment).commitAllowingStateLoss();
                    }
                });
                this.fragmentManager.beginTransaction().setCustomAnimations(R.anim.fade_in, R.anim.fade_out, R.anim.fade_in, R.anim.fade_out).add(this.container.getId(), (Fragment)fragment, NRWebContentFragment.TAG).commit();
            } else if (channeling.getType() == NRChanneling.NRChannelingType.PhoneNumber) {
                String phoneNumber = ((NRChannelingPhoneNumber)channeling).getPhoneNumber();
                this.widgetListener.onChannel(NRChanneling.NRChannelingType.PhoneNumber, (Object)phoneNumber);
                String string2 = channeling.getName();
            }
        }
        this.nanorepInstance.reportChanneling(this.getCurrentResult(), channeling);
    }

    private void requestFocus() {
        if (this.getView() != null) {
            this.getView().requestFocus();
        }
    }

    private NRQueryResult getCurrentResult() {
        View view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (view instanceof NRArticleView) {
            return ((NRArticleView)view).getResult().getFetchedResult();
        }
        return null;
    }

    @Override
    public void onLinkedArticleClicked(String articleId) {
        this.mFetchedDataManager.faqAnswer(articleId, null, new OnFAQAnswerFetched(){

            @Override
            public void onAnswerFetched(NRQueryResult result) {
                NRResult newResult = new NRResult(result, NRResult.RowType.TITLE);
                int height = Integer.valueOf(DeepLinkFragment.this.configuration.getTitle().getTitleRowHeight());
                newResult.setHeight((int)Calculate.pxFromDp(DeepLinkFragment.this.getContext(), height));
                newResult.setSingle(true);
                NRArticleView resultTopView = DeepLinkFragment.this.getTopView();
                if (resultTopView != null) {
                    DeepLinkFragment.this.contentMain.addView((View)resultTopView);
                    resultTopView.startAnimation(AnimationUtils.loadAnimation((Context)DeepLinkFragment.this.getContext(), (int)R.anim.slide_from_right));
                    resultTopView.openOpenedView(newResult);
                    DeepLinkFragment.this.requestFocus();
                }
            }
        });
    }

    @Override
    public void onLinkClicked(String url) {
        this.url = url;
        if (this.accountParams.isOpenLinksInternally()) {
            this.contentView.loadUrl(url);
        } else {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url));
            try {
                this.startActivity(intent);
            }
            catch (Exception e) {
                Log.d((String)"StartActivityError", (String)"Unable to start activity");
            }
        }
    }

    @Override
    public void onError(NRError error) {
        this.widgetListener.onError(error);
    }

    @Override
    public void onDismiss() {
        View view;
        Fragment fragment;
        if (this.fragmentManager != null && (fragment = this.fragmentManager.findFragmentByTag(NRWebContentFragment.TAG)) == null && (view = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1)) instanceof NRArticleView) {
            view.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_to_right));
        }
        this.removeTopView();
    }

    public void onDestroy() {
        this.clear();
        super.onDestroy();
    }

    private void clear() {
        this.viewsProvider = null;
        this.widgetListener = null;
        this.configuration = null;
        if (this.nanorepInstance != null) {
            this.nanorepInstance.clearSession();
        }
    }

    private void removeTopView() {
        this.dismissConnectionError();
        if (this.contentMain != null) {
            int oldChildCount = this.contentMain.getChildCount();
            this.contentMain.removeViewAt(oldChildCount - 1);
            this.loadCurrentViewAfterRemoval();
        }
    }

    private void loadCurrentViewAfterRemoval() {
        View localCurrentView = this.contentMain.getChildAt(this.contentMain.getChildCount() - 1);
        if (localCurrentView != null && localCurrentView != this.progressBar) {
            this.requestFocus();
            localCurrentView.setVisibility(0);
        } else if (this.fragmentManager != null) {
            this.fragmentManager.popBackStack();
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.requestFocus();
        View.OnKeyListener onKeyListener = new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 0 && keyCode == 4) {
                    DeepLinkFragment.this.removeTopView();
                    return true;
                }
                return false;
            }
        };
        View view = this.getView();
        if (view != null) {
            view.setOnKeyListener(onKeyListener);
        }
    }

    private void setLoadingState(boolean state) {
        this.progressBar.setVisibility(state ? 0 : 8);
    }

    public void onPause() {
        super.onPause();
        super.onPause();
        this.fragmentPaused = true;
        NRErrorHandler.getInstance().setListener(null);
    }

    public void onResume() {
        super.onResume();
        if (this.fragmentPaused) {
            this.fragmentPaused = false;
            NRErrorHandler.getInstance().setListener((NRErrorHandler.Listener)this);
        }
    }

    public static interface deepLinkingServicesProvider {
        public Nanorep.NanoRepWidgetListener getWidgetListener();

        public SearchViewsProvider getSearchViewsProvider();
    }
}

